/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistentimpl.memory;

import com.sap.engine.lib.util.ConcurrentArrayLong;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.EnumerationLong;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIHandleEnumerationImpl;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIHandleImpl;
import com.sap.engine.services.jndi.persistentimpl.memory.Obj;
import java.io.Serializable;

public class Container
implements Serializable {
    static final long serialVersionUID = -9058533831829538267L;
    protected long cid;
    protected String name;
    private byte[] data;
    ConcurrentHashMapLongObject objsById = new ConcurrentHashMapLongObject();
    ConcurrentHashMapObjectObject objsByName = new ConcurrentHashMapObjectObject();

    public Container(String name, long cid) {
        this.cid = cid;
        this.name = name;
    }

    public byte[] getData() {
        return this.data;
    }

    public synchronized void setData(byte[] data) {
        this.data = data;
    }

    JNDIHandle getJNDIHandle(String name) {
        Obj o = (Obj)this.objsByName.get(name);
        if (o != null) {
            return new JNDIHandleImpl(this.cid, o.getOid());
        }
        return null;
    }

    Obj getObject(String name) {
        return (Obj)this.objsByName.get(name);
    }

    Obj getObject(long oid) {
        return (Obj)this.objsById.get(oid);
    }

    Obj getObject(JNDIHandle jh) {
        return this.getObject(jh.getObjectID());
    }

    public long getId() {
        return this.cid;
    }

    public String getContainerName() {
        return this.name;
    }

    public synchronized void setid(long cid) {
        this.cid = cid;
    }

    public synchronized void append(String name, byte[] data, long oid, short type) throws JNDIException {
        if (this.objsByName.contains(name)) {
            throw new JNDIException(JNDIException.OBJECT_ALREADY_BOUND, new Object[]{name}, 0);
        }
        this.objsByName.put(name, new Obj(name, data, oid, type));
        this.objsById.put(oid, new Obj(name, data, oid, type));
    }

    public synchronized void modify(JNDIHandle object, byte[] data) {
        Obj o = (Obj)this.objsById.remove(object.getObjectID());
        if (o != null) {
            o.data = data;
            this.objsById.put(object.getObjectID(), o);
            this.objsByName.remove(o.name);
            this.objsByName.put(o.name, o);
        }
    }

    public synchronized void rename(JNDIHandle object, String newName) {
        Obj o = (Obj)this.objsById.remove(object.getObjectID());
        if (o != null) {
            String oldName = o.name;
            o.name = newName;
            this.objsById.put(object.getObjectID(), o);
            this.objsByName.remove(oldName);
            this.objsByName.put(newName, o);
        }
    }

    public synchronized void deleteObject(JNDIHandle handle) {
        Obj o = (Obj)this.objsById.remove(handle.getObjectID());
        this.objsByName.remove(o.name);
    }

    public byte[] readObject(JNDIHandle object) {
        Obj o = this.getObject(object);
        return o.data;
    }

    public synchronized void createLink(JNDIHandle handleObject, long linkid) {
        Obj o = (Obj)this.objsById.remove(handleObject.getObjectID());
        if (o != null) {
            o.linkid = linkid;
            this.objsById.put(o.oid, o);
            this.objsByName.remove(o.name);
            this.objsByName.put(o.name, o);
        }
    }

    public long getLink(JNDIHandle handleObject) {
        Obj o = this.getObject(handleObject);
        return o.linkid;
    }

    public JNDIHandle getLinkedContainer(JNDIHandle handle) {
        Obj o = this.getObject(handle);
        if (o.linkid != -1L) {
            return new JNDIHandleImpl(o.linkid, -1L);
        }
        return null;
    }

    public synchronized void removeLink(JNDIHandle handle) {
        Obj o = (Obj)this.objsById.remove(handle.getObjectID());
        o.linkid = -1L;
        this.objsById.put(o.oid, o);
        this.objsByName.remove(o.name);
        this.objsByName.put(o.name, o);
    }

    public String getNameOf(JNDIHandle handleObject) {
        Obj o = this.getObject(handleObject);
        if (o != null) {
            return o.getName();
        }
        return null;
    }

    public short getTypeOf(JNDIHandle handleObject) {
        Obj o = this.getObject(handleObject);
        return o.getType();
    }

    public synchronized void setTypeOf(JNDIHandle object, short type) {
        Obj o = (Obj)this.objsById.remove(object.getObjectID());
        if (o != null) {
            o.type = type;
            this.objsById.put(object.getObjectID(), o);
            this.objsByName.remove(o.name);
            this.objsByName.put(o.name, o);
        }
    }

    public long getIdOf(JNDIHandle handleObject) {
        Obj o = this.getObject(handleObject);
        return o.getOid();
    }

    public synchronized JNDIHandleEnumeration getAllByName(String name) {
        ConcurrentArrayLong oids = new ConcurrentArrayLong();
        if (name.equals("") || name.equals("*")) {
            EnumerationLong keys = this.objsById.keys();
            while (keys.hasMoreElements()) {
                oids.add(keys.nextElement());
            }
        } else {
            Obj o = (Obj)this.objsByName.get(name);
            if (o != null) {
                oids.add(o.getOid());
            }
        }
        return new JNDIHandleEnumerationImpl(oids, this.cid);
    }

    protected void printAll() {
        Object[] objects = this.objsById.getAllValues();
        int i = 0;
        while (i < objects.length) {
            Obj c = (Obj)objects[1];
            System.out.print(c.name + "-" + c.oid + " ");
            ++i;
        }
    }
}

