/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistent;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serializator {
    public static byte[] toByteArray(Object obj) throws JNDIException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byte[] arr = baos.toByteArray();
            oos.close();
            baos.close();
            return arr;
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_SERIALIZE_OBJECT, e);
        }
    }

    public static Object toObject(byte[] byteArr) throws JNDIException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArr);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            ois.close();
            bais.close();
            return obj;
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_DESERIALIZE_OBJECT, e);
        }
    }
}

