/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistent;

import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.persistent.CPOInputStream;
import com.sap.engine.services.jndi.persistent.CPOOutputStream;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.SerializatorFactory;
import com.sap.engine.services.jndi.persistent.UnsatisfiedReferenceImpl;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class RemoteSerializator {
    public static ConcurrentHashMapObjectObject LROTable = new ConcurrentHashMapObjectObject();
    public static SerializatorFactory serializatorFactory = null;

    public static byte[] toByteArray(Object obj, ClientContext cc) throws JNDIException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CPOOutputStream oos = new CPOOutputStream(baos, cc);
            oos.writeObject(obj);
            oos.flush();
            byte[] arr = baos.toByteArray();
            oos.close();
            baos.close();
            return arr;
        }
        catch (Exception e) {
            throw new JNDIException(JNDIException.CAN_NOT_SERIALIZE_OBJECT, e);
        }
    }

    public static Object toObject(byte[] byteArr, ClientContext cc) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArr);
            CPOInputStream ois = serializatorFactory.getNewCPOInputStream(bais, cc);
            Object obj = ois.readObject();
            ois.close();
            bais.close();
            return obj;
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.EXCEPTION_IN_DESERIALIZATION, new Object[]{e.toString()});
                JNDIFrame.log.logCatching(e);
            }
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(ostr));
            return new UnsatisfiedReferenceImpl(byteArr, ostr.toString(), e.toString());
        }
        catch (NoClassDefFoundError er) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.logInfo(JNDILogConstants.ERROR_IN_DESERIALIZATION, new Object[]{er.toString()});
                JNDIFrame.log.logCatching(er);
            }
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            er.printStackTrace(new PrintStream(ostr));
            return new UnsatisfiedReferenceImpl(byteArr, ostr.toString(), er.toString());
        }
    }
}

