/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implserver.SearchFilter;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoSuchElementException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.persistent.exceptions.SizeLimitExceededException;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.rmi.RemoteException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.rmi.PortableRemoteObject;

class ServerNamingSearchFilterEnumImpl
extends PortableRemoteObject
implements ServerNamingEnum {
    private boolean moreElements = true;
    private boolean remote;
    private SearchResult nextSearchResult = null;
    private int levelPos = 0;
    private ConcurrentArrayObject jes = null;
    private ConcurrentArrayObject prefix = null;
    private JNDIPersistentRepository persistent = null;
    private SearchFilter searchFilter = null;
    private SearchControls searchControls;
    private long objCount = 0L;
    private boolean objCountExceeded = false;
    private Name rootName = null;
    private boolean onlyLookupAllowed = false;
    private boolean redirectableContext = false;

    public ServerNamingSearchFilterEnumImpl(JNDIPersistentRepository persistent, JNDIHandle parent, JNDIHandle container, byte[] dirObject, String filter, Object[] filterArgs, SearchControls cons, Name rootName, boolean remote, boolean onlyLookup, boolean redirectable) throws RemoteException {
        this.remote = remote;
        this.rootName = rootName;
        this.onlyLookupAllowed = onlyLookup;
        this.redirectableContext = redirectable;
        try {
            if (filterArgs != null) {
                String formattedFilter = SearchFilter.format(filter, filterArgs);
                this.searchFilter = new SearchFilter(formattedFilter);
            } else {
                this.searchFilter = new SearchFilter(filter);
            }
            this.jes = new ConcurrentArrayObject();
            this.prefix = new ConcurrentArrayObject();
            this.prefix.add("");
            this.jes.add(persistent.listObjects(container, "*"));
            this.persistent = persistent;
            if (cons == null) {
                cons = new SearchControls();
            }
            this.searchControls = cons;
            Attributes attr = null;
            if (dirObject != null && this.searchFilter.check(attr = DirObject.getAttributes(dirObject))) {
                if (attr == null) {
                    attr = new BasicAttributes();
                }
                ++this.objCount;
                BasicAttributes selectedAttr = new BasicAttributes();
                String[] attrsToReturn = this.searchControls.getReturningAttributes();
                if (attrsToReturn != null) {
                    int i = 0;
                    while (i < attrsToReturn.length) {
                        Attribute attribute;
                        if (attrsToReturn[i] != null && (attribute = attr.get(attrsToReturn[i])) != null) {
                            selectedAttr.put(attribute);
                        }
                        ++i;
                    }
                    if (this.searchControls.getReturningObjFlag()) {
                        ServerContextImpl sc = null;
                        if (this.redirectableContext) {
                            sc = new ServerContextRedirectableImpl(persistent.getNewConnection(), parent, persistent.getLinkedContainer(parent), (Name)rootName.clone(), remote);
                            sc.onlyLookUpAllowed = this.onlyLookupAllowed;
                        } else {
                            sc = new ServerContextImpl(persistent.getNewConnection(), parent, persistent.getLinkedContainer(parent), (Name)rootName.clone(), remote);
                            sc.onlyLookUpAllowed = this.onlyLookupAllowed;
                        }
                        this.nextSearchResult = new SearchResult("", "javax.naming.Context", (Object)sc, selectedAttr);
                    } else {
                        this.nextSearchResult = new SearchResult("", "javax.naming.Context", null, selectedAttr);
                    }
                } else if (this.searchControls.getReturningObjFlag()) {
                    ServerContextImpl sc = null;
                    if (this.redirectableContext) {
                        sc = new ServerContextRedirectableImpl(persistent.getNewConnection(), parent, persistent.getLinkedContainer(parent), (Name)rootName.clone(), remote);
                        sc.onlyLookUpAllowed = this.onlyLookupAllowed;
                    } else {
                        sc = new ServerContextImpl(persistent.getNewConnection(), parent, persistent.getLinkedContainer(parent), (Name)rootName.clone(), remote);
                        sc.onlyLookUpAllowed = this.onlyLookupAllowed;
                    }
                    this.nextSearchResult = new SearchResult("", "javax.naming.Context", (Object)sc, attr);
                } else {
                    this.nextSearchResult = new SearchResult("", "javax.naming.Context", null, attr);
                }
            } else {
                this.next();
            }
        }
        catch (JNDIException e) {
            JNDIFrame.log.logCatching((Throwable)((Object)e));
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEARCH), (Throwable)((Object)e));
            bre.log();
            throw bre;
        }
        catch (javax.naming.NamingException ne) {
            JNDIFrame.log.logCatching(ne);
            com.sap.engine.services.jndi.persistent.exceptions.RemoteException re = new com.sap.engine.services.jndi.persistent.exceptions.RemoteException(com.sap.engine.services.jndi.persistent.exceptions.RemoteException.CANNOT_SEARCH, ne);
            re.log();
            throw re;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object next() throws RemoteException, javax.naming.NamingException {
        if (!this.moreElements) {
            throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
        }
        try {
            block23: {
                if (!((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).hasMoreElements()) break block23;
                jh = ((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).nextObject();
                found = false;
                attr = null;
                className = null;
                objName = null;
                object /* !! */  = null;
                tempSearchResult = null;
                do {
                    block24: {
                        dirObj = this.persistent.readObject(jh);
                        objName = this.persistent.getObjectName(jh);
                        if (objName == null) break block24;
                        linkedContainer = this.persistent.getLinkedContainer(jh);
                        if (linkedContainer != null) {
                            className = "javax.naming.Context";
                            dobj = dirObj;
                            if (this.redirectableContext) {
                                object /* !! */  = (byte[])new ServerContextRedirectableImpl(this.persistent.getNewConnection(), jh, linkedContainer, (Name)this.rootName.clone(), this.remote);
                                ((ServerContextRedirectableImpl)object /* !! */ ).onlyLookUpAllowed = this.onlyLookupAllowed;
                            } else {
                                object /* !! */  = (byte[])new ServerContextImpl(this.persistent.getNewConnection(), jh, linkedContainer, (Name)this.rootName.clone(), this.remote);
                                ((ServerContextImpl)object /* !! */ ).onlyLookUpAllowed = this.onlyLookupAllowed;
                            }
                            attr = DirObject.getAttributes(dobj);
                            if (this.searchControls.getSearchScope() == 2) {
                                if (this.levelPos != 0) {
                                    this.prefix.add((String)this.prefix.elementAt(this.levelPos) + "/" + objName);
                                } else {
                                    this.prefix.add(objName);
                                }
                                objName = "";
                                ++this.levelPos;
                                this.jes.add(this.persistent.listObjects(this.persistent.getLinkedContainer(jh), "*"));
                            }
                            found = true;
                        } else {
                            object /* !! */  = dirObj;
                            className = object /* !! */  != null ? DirObject.getClassName(object /* !! */ ) : null;
                            attr = DirObject.getAttributes(object /* !! */ );
                            found = true;
                        }
                        if (!this.moreElements || !found) continue;
                        if (attr == null) {
                            attr = new BasicAttributes();
                        }
                        if (this.searchFilter.check(attr)) {
                            selectedAttr = new BasicAttributes();
                            attrsToReturn = this.searchControls.getReturningAttributes();
                            objName = linkedContainer != null || this.levelPos == 0 ? (String)this.prefix.elementAt(this.levelPos) + objName : (String)this.prefix.elementAt(this.levelPos) + "/" + objName;
                            tempSearchResult = null;
                            if (attrsToReturn != null) {
                                i = 0;
                                while (i < attrsToReturn.length) {
                                    if (attrsToReturn[i] != null && (attribute = attr.get(attrsToReturn[i])) != null) {
                                        selectedAttr.put(attribute);
                                    }
                                    ++i;
                                }
                                tempSearchResult = this.searchControls.getReturningObjFlag() ? new SearchResult(objName, className, (Object)object /* !! */ , selectedAttr) : new SearchResult(objName, className, null, selectedAttr);
                            } else {
                                tempSearchResult = this.searchControls.getReturningObjFlag() != false ? new SearchResult(objName, className, (Object)object /* !! */ , attr) : new SearchResult(objName, className, null, attr);
                            }
                            found = true;
                            continue;
                        }
                        if (!((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).hasMoreElements()) ** GOTO lbl69
                        found = false;
                        jh = ((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).nextObject();
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            --this.levelPos;
                            this.jes.removeElementAt(this.jes.size() - 1);
                            this.prefix.removeElementAt(this.prefix.size() - 1);
lbl69:
                            // 2 sources

                            ** while (this.levelPos > 0 && !((JNDIHandleEnumeration)this.jes.elementAt((int)this.levelPos)).hasMoreElements())
                        }
lbl70:
                        // 1 sources

                        if (((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).hasMoreElements()) {
                            found = false;
                            jh = ((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).nextObject();
                            continue;
                        }
                        found = true;
                        this.moreElements = false;
                        continue;
                    }
                    if (!((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).hasMoreElements()) ** GOTO lbl85
                    found = false;
                    jh = ((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).nextObject();
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        --this.levelPos;
                        this.jes.removeElementAt(this.jes.size() - 1);
                        this.prefix.removeElementAt(this.prefix.size() - 1);
lbl85:
                        // 2 sources

                        ** while (this.levelPos > 0 && !((JNDIHandleEnumeration)this.jes.elementAt((int)this.levelPos)).hasMoreElements())
                    }
lbl86:
                    // 1 sources

                    if (((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).hasMoreElements()) {
                        found = false;
                        jh = ((JNDIHandleEnumeration)this.jes.elementAt(this.levelPos)).nextObject();
                        continue;
                    }
                    found = true;
                    this.moreElements = false;
                } while (!found);
                if (this.searchControls.getCountLimit() != 0L && ++this.objCount > this.searchControls.getCountLimit()) {
                    this.moreElements = false;
                    this.objCountExceeded = true;
                    this.levelPos = 0;
                }
                oldSearchResult = this.nextSearchResult;
                this.nextSearchResult = tempSearchResult;
                return oldSearchResult;
            }
            if (this.levelPos == 0) {
                this.moreElements = false;
                return this.nextSearchResult;
            }
            --this.levelPos;
            this.jes.removeElementAt(this.jes.size() - 1);
            this.prefix.removeElementAt(this.prefix.size() - 1);
            return this.next();
        }
        catch (JNDIException e) {
            JNDIFrame.log.logCatching((Throwable)e);
            nge = new NamingException(NamingException.CANNOT_SEARCH, (Throwable)e);
            nge.log();
            throw nge;
        }
    }

    public boolean hasMore() throws RemoteException, javax.naming.NamingException {
        if (this.objCountExceeded) {
            this.moreElements = false;
            int i = this.jes.size() - 1;
            while (i >= 0) {
                ((JNDIHandleEnumeration)this.jes.elementAt(i)).closeEnumeration();
                --i;
            }
            SizeLimitExceededException slee = new SizeLimitExceededException(SizeLimitExceededException.SEARCHED_OBJECT_EXCEEDS_LIMIT);
            slee.log();
            throw slee;
        }
        if (!this.moreElements) {
            int i = this.jes.size() - 1;
            while (i >= 0) {
                ((JNDIHandleEnumeration)this.jes.elementAt(i)).closeEnumeration();
                --i;
            }
        }
        return this.moreElements;
    }

    public void close() throws RemoteException {
        this.moreElements = false;
    }

    public void dump(String s) {
        System.out.println(s);
    }
}

