/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implserver.ModifyAttributes;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoSuchElementException;
import java.rmi.RemoteException;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.rmi.PortableRemoteObject;

class ServerNamingSearchEnumImpl
extends PortableRemoteObject
implements ServerNamingEnum {
    private boolean moreElements = true;
    private boolean remote;
    private SearchResult nextSearchResult = null;
    private String[] attrsToReturn = null;
    private Attributes matchingAttrs = null;
    JNDIHandleEnumeration je = null;
    JNDIPersistentRepository persistent = null;
    private Name rootName = null;
    private boolean onlyLookupAllowed = false;
    private boolean redirectableContext = false;

    public ServerNamingSearchEnumImpl(JNDIPersistentRepository persistent, JNDIHandleEnumeration je, Attributes matchingAttributes, String[] attrsToReturn, Name rootName, boolean remote, boolean onlyLookup, boolean redirectable) throws RemoteException {
        this.remote = remote;
        this.je = je;
        this.persistent = persistent;
        this.attrsToReturn = attrsToReturn;
        this.matchingAttrs = matchingAttributes;
        this.rootName = rootName;
        this.onlyLookupAllowed = onlyLookup;
        this.redirectableContext = redirectable;
        try {
            this.next();
        }
        catch (javax.naming.NamingException ne) {
            JNDIFrame.log.logCatching(ne);
            com.sap.engine.services.jndi.persistent.exceptions.RemoteException re = new com.sap.engine.services.jndi.persistent.exceptions.RemoteException(com.sap.engine.services.jndi.persistent.exceptions.RemoteException.CANNOT_SEARCH, ne);
            re.log();
            throw re;
        }
    }

    public Object next() throws RemoteException, javax.naming.NamingException {
        if (!this.moreElements) {
            throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
        }
        if (this.je.hasMoreElements()) {
            try {
                JNDIHandle jh = this.je.nextObject();
                boolean found = false;
                Attributes attrs = null;
                String objName = null;
                Object dirObject = null;
                SearchResult tempSearchResult = null;
                do {
                    if ((objName = this.persistent.getObjectName(jh)) != null) {
                        byte[] dirObj = this.persistent.readObject(jh);
                        JNDIHandle linkedContainer = this.persistent.getLinkedContainer(jh);
                        if (linkedContainer != null) {
                            if (this.redirectableContext) {
                                dirObject = new ServerContextRedirectableImpl(this.persistent.getNewConnection(), jh, linkedContainer, ((Name)this.rootName.clone()).add(objName), this.remote);
                                ((ServerContextRedirectableImpl)dirObject).onlyLookUpAllowed = this.onlyLookupAllowed;
                            } else {
                                dirObject = new ServerContextImpl(this.persistent.getNewConnection(), jh, linkedContainer, ((Name)this.rootName.clone()).add(objName), this.remote);
                                ((ServerContextImpl)dirObject).onlyLookUpAllowed = this.onlyLookupAllowed;
                            }
                            attrs = DirObject.getAttributes(dirObj);
                        } else {
                            dirObject = dirObj;
                            attrs = DirObject.getAttributes(dirObject);
                        }
                        if (attrs == null) {
                            attrs = new BasicAttributes();
                        }
                        if (ModifyAttributes.matchingAttributes(attrs, this.matchingAttrs)) {
                            BasicAttributes selectedAttr = new BasicAttributes();
                            if (this.attrsToReturn != null) {
                                int i = 0;
                                while (i < this.attrsToReturn.length) {
                                    selectedAttr.put(attrs.get(this.attrsToReturn[i]));
                                    ++i;
                                }
                                tempSearchResult = new SearchResult(objName, null, dirObject, selectedAttr);
                            } else {
                                tempSearchResult = new SearchResult(objName, null, dirObject, attrs);
                            }
                            found = true;
                            continue;
                        }
                        if (this.je.hasMoreElements()) {
                            found = false;
                            jh = this.je.nextObject();
                            continue;
                        }
                        found = true;
                        this.moreElements = false;
                        continue;
                    }
                    if (this.je.hasMoreElements()) {
                        found = false;
                        jh = this.je.nextObject();
                        continue;
                    }
                    found = true;
                    this.moreElements = false;
                } while (!found);
                SearchResult oldSearchResult = this.nextSearchResult;
                this.nextSearchResult = tempSearchResult;
                return oldSearchResult;
            }
            catch (JNDIException e) {
                JNDIFrame.log.logCatching((Throwable)((Object)e));
                NamingException ne = new NamingException(NamingException.CANNOT_SEARCH, (Throwable)((Object)e));
                ne.log();
                throw ne;
            }
        }
        this.moreElements = false;
        return this.nextSearchResult;
    }

    public boolean hasMore() throws RemoteException, javax.naming.NamingException {
        if (!this.moreElements) {
            this.je.closeEnumeration();
        }
        return this.moreElements;
    }

    public void close() throws RemoteException {
        this.je.closeEnumeration();
    }

    public void dump(String s) {
        System.out.println(s);
    }
}

