/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implserver.SearchFilter;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NoSuchElementException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.rmi.RemoteException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.rmi.PortableRemoteObject;

class ServerNamingOneObjectEnumImpl
extends PortableRemoteObject
implements ServerNamingEnum {
    private boolean moreElements = true;
    private boolean remote;
    private Name rootName = null;
    private SearchResult nextSearchResult = null;
    private SearchFilter searchFilter = null;
    private boolean onlyLookupAllowed = false;
    private boolean redirectableContext = false;

    public ServerNamingOneObjectEnumImpl(JNDIPersistentRepository persistent, JNDIHandle object, String filter, Object[] filterArgs, SearchControls searchControls, Name rootName, boolean remote, boolean onlyLookup, boolean redirectable) throws RemoteException {
        this.rootName = rootName;
        this.remote = remote;
        this.onlyLookupAllowed = onlyLookup;
        this.redirectableContext = redirectable;
        try {
            if (searchControls == null) {
                searchControls = new SearchControls();
            }
            if (filterArgs != null) {
                String formattedFilter = SearchFilter.format(filter, filterArgs);
                this.searchFilter = new SearchFilter(formattedFilter);
            } else {
                this.searchFilter = new SearchFilter(filter);
            }
            byte[] data = persistent.readObject(object);
            JNDIHandle linkedContainer = persistent.getLinkedContainer(object);
            if (linkedContainer != null) {
                String className = "javax.naming.Context";
                ServerContextImpl objectToReturn = null;
                if (this.redirectableContext) {
                    objectToReturn = new ServerContextRedirectableImpl(persistent.getNewConnection(), object, linkedContainer, (Name)rootName.clone(), remote);
                    objectToReturn.onlyLookUpAllowed = this.onlyLookupAllowed;
                } else {
                    objectToReturn = new ServerContextImpl(persistent.getNewConnection(), object, linkedContainer, (Name)rootName.clone(), remote);
                    ((ServerContextImpl)objectToReturn).onlyLookUpAllowed = this.onlyLookupAllowed;
                }
                Attributes attr = DirObject.getAttributes(data);
                if (this.searchFilter.check(attr)) {
                    BasicAttributes selectedAttr = new BasicAttributes();
                    String[] attrsToReturn = searchControls.getReturningAttributes();
                    if (attrsToReturn != null) {
                        int i = 0;
                        while (i < attrsToReturn.length) {
                            selectedAttr.put(attr.get(attrsToReturn[i]));
                            ++i;
                        }
                        this.nextSearchResult = searchControls.getReturningObjFlag() ? new SearchResult("", className, (Object)objectToReturn, selectedAttr) : new SearchResult("", className, null, selectedAttr);
                    } else {
                        this.nextSearchResult = searchControls.getReturningObjFlag() ? new SearchResult("", className, (Object)objectToReturn, attr) : new SearchResult("", className, null, attr);
                    }
                    this.moreElements = true;
                } else {
                    this.moreElements = false;
                }
            } else {
                Attributes attr;
                String className = null;
                if (data != null) {
                    className = DirObject.getClassName(data);
                }
                if (this.searchFilter.check(attr = DirObject.getAttributes(data))) {
                    BasicAttributes selectedAttr = new BasicAttributes();
                    String[] attrsToReturn = searchControls.getReturningAttributes();
                    if (attrsToReturn != null) {
                        int i = 0;
                        while (i < attrsToReturn.length) {
                            selectedAttr.put(attr.get(attrsToReturn[i]));
                            ++i;
                        }
                        if (searchControls.getReturningObjFlag()) {
                            byte[] objectToReturn = data;
                            this.nextSearchResult = new SearchResult("", className, (Object)objectToReturn, selectedAttr);
                        } else {
                            this.nextSearchResult = new SearchResult("", className, null, selectedAttr);
                        }
                    } else if (searchControls.getReturningObjFlag()) {
                        byte[] objectToReturn = data;
                        this.nextSearchResult = new SearchResult("", className, (Object)objectToReturn, attr);
                    } else {
                        this.nextSearchResult = new SearchResult("", className, null, attr);
                    }
                    this.moreElements = true;
                } else {
                    this.moreElements = false;
                }
            }
        }
        catch (JNDIException e) {
            JNDIFrame.log.logCatching((Throwable)((Object)e));
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEARCH), (Throwable)((Object)e));
            bre.log();
            throw bre;
        }
        catch (NamingException ne) {
            JNDIFrame.log.logCatching(ne);
            com.sap.engine.services.jndi.persistent.exceptions.RemoteException re = new com.sap.engine.services.jndi.persistent.exceptions.RemoteException(com.sap.engine.services.jndi.persistent.exceptions.RemoteException.CANNOT_SEARCH, ne);
            re.log();
            throw re;
        }
    }

    public Object next() throws RemoteException, NamingException {
        if (!this.moreElements) {
            throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
        }
        this.moreElements = false;
        return this.nextSearchResult;
    }

    public boolean hasMore() throws RemoteException, NamingException {
        return this.moreElements;
    }

    public void close() throws RemoteException {
    }

    public void dump(String s) {
        System.out.println(s);
    }
}

