/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.persistent.exceptions.SecurityException;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.rmi.RemoteException;

public class ServerCtxCrossObjectFactory
implements CrossObjectFactory {
    protected static JNDIPersistentRepository db = null;
    protected static JNDIHandle rootObject;
    protected static JNDIHandle jndiRootContainer;

    public ServerCtxCrossObjectFactory(JNDIPersistentRepository db, JNDIHandle rootObject, JNDIHandle jndiRootContainer, boolean remote) throws RemoteException {
        ServerCtxCrossObjectFactory.db = db;
        ServerCtxCrossObjectFactory.rootObject = rootObject;
        ServerCtxCrossObjectFactory.jndiRootContainer = jndiRootContainer;
    }

    public Object getObject(String s) {
        boolean onlyLookupAllowed = false;
        try {
            if (!SecurityBase.WITHOUT_SECURITY) {
                if (SecurityBase.isOperationLegal("jndi_get_initial_context")) {
                    if (!SecurityBase.isOperationLegal("jndi_all_operations")) {
                        onlyLookupAllowed = true;
                    }
                } else {
                    SecurityException se = new SecurityException(SecurityException.NOT_ALLOWED_TO_GET_INITIAL_CONTEXT);
                    se.log();
                    throw se;
                }
            }
            return new ServerContextRedirectableImpl(db.getNewConnection(), rootObject, jndiRootContainer, true, onlyLookupAllowed);
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.ERROR_OBTAINING_CONNECTION_TO_JNDI), (Throwable)e);
            bre.log();
            throw bre;
        }
    }
}

