/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.services.jndi.DeployNotificationListenerImpl;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cache.Cache;
import com.sap.engine.services.jndi.cache.CacheHashtableImpl;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.implserver.AbstractServerContextImpl;
import com.sap.engine.services.jndi.implserver.ModifyAttributes;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.implserver.ServerNamingEnumImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingOneObjectEnumImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingSearchEnumImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingSearchFilterEnumImpl;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.AttributeModificationException;
import com.sap.engine.services.jndi.persistent.exceptions.ContextNotEmptyException;
import com.sap.engine.services.jndi.persistent.exceptions.InvalidNameException;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NameAlreadyBoundException;
import com.sap.engine.services.jndi.persistent.exceptions.NameNotFoundException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException;
import com.sap.engine.services.jndi.persistent.exceptions.NotContextException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.pool.ServerContextImplPool;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.rmi.PortableRemoteObject;

public class ServerContextImpl
extends AbstractServerContextImpl {
    public JNDIPersistentRepository persistent = null;
    protected JNDIHandle parentObject = null;
    protected JNDIHandle rootContainer = null;
    protected Name rootName = null;
    public static Cache cache = null;
    public static int numberOfBindings = 0;
    private String lastCompoundComponentVariable = null;
    private static ServerContextImplPool scPool = new ServerContextImplPool(20, 5);
    private boolean disposed = false;
    private boolean remote = false;
    public boolean onlyLookUpAllowed = false;
    protected boolean redirectableContext = false;
    private static HashMapLongObject keys = new HashMapLongObject();

    public ServerContextImpl(boolean remote) throws RemoteException {
        super(remote);
        this.remote = remote;
    }

    public ServerContextImpl(JNDIPersistentRepository persistent, JNDIHandle parentObject, JNDIHandle container, boolean remote, boolean onlyLookUpOperation) throws RemoteException {
        super(remote);
        this.remote = remote;
        this.onlyLookUpAllowed = onlyLookUpOperation;
        this.persistent = persistent;
        this.parentObject = parentObject;
        this.rootContainer = container;
    }

    public ServerContextImpl(JNDIPersistentRepository persistent, JNDIHandle parentObject, JNDIHandle container, Name name, boolean remote) throws RemoteException {
        super(remote);
        this.remote = remote;
        this.persistent = persistent;
        this.parentObject = parentObject;
        this.rootContainer = container;
        this.rootName = name;
    }

    protected Name transformName(Name name) {
        if (name.size() == 0) {
            return name;
        }
        if (name.get(name.size() - 1).trim().equals("")) {
            try {
                name.remove(name.size() - 1);
            }
            catch (Exception ex) {
                JNDIFrame.log.logCatching(ex);
                JNDIFrame.log.infoT(JNDILogConstants.CANNOT_TRANSFORM_NAME_PARAMETER, new Object[]{name});
            }
        }
        return name;
    }

    private String makeCacheName(Name name) {
        int i0 = this.rootName == null ? 0 : this.rootName.size();
        int i1 = name.size();
        int i = 0;
        String cacheName = "";
        i = 0;
        while (i < i0) {
            cacheName = cacheName + "/" + this.rootName.get(i);
            ++i;
        }
        i = 0;
        while (i < i1) {
            cacheName = cacheName + "/" + name.get(i);
            ++i;
        }
        return cacheName;
    }

    public Name getCtxName() throws javax.naming.NamingException {
        try {
            return new CompositeName(this.persistent.getObjectName(this.parentObject));
        }
        catch (JNDIException de) {
            JNDIFrame.log.logCatching((Throwable)((Object)de));
            NamingException ne = new NamingException(NamingException.CANNOT_DETERMINE_CONTEXT_NAME, (Throwable)((Object)de));
            ne.log();
            throw ne;
        }
    }

    protected JNDIHandle getLastContainer(JNDIHandle container, Name name) throws javax.naming.NamingException {
        try {
            JNDIHandle tempContainer = container;
            int count = name.size() - 1;
            int componentIndex = 0;
            while (componentIndex < count) {
                String compositeString = name.get(componentIndex);
                JNDIHandle containerCandidate = this.persistent.findObject(tempContainer, compositeString);
                if (containerCandidate == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.PATH_TO_OBJECT_DOES_NOT_EXISTS, new Object[]{compositeString, name});
                    }
                    throw new NameNotFoundException(NameNotFoundException.PATH_TO_OBJECT_DOES_NOT_EXISTS, new Object[]{compositeString, name});
                }
                tempContainer = this.persistent.getLinkedContainer(containerCandidate);
                if (tempContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.INTERMEDIATE_CONTEXT_NOT_FOUND, new Object[]{compositeString, name});
                    }
                    throw new NamingException(NamingException.INTERMEDIATE_CONTEXT_NOT_FOUND, new Object[]{compositeString, name});
                }
                ++componentIndex;
            }
            try {
                this.lastCompoundComponentVariable = name.get(count);
            }
            catch (Exception e) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.INVALID_NAME_PARAMETER, new Object[]{name});
                    JNDIFrame.log.logCatching(e);
                }
                NamingException ne = new NamingException(NamingException.INVALID_NAME_PARAMETER, new Object[]{name}, e);
                ne.log();
                throw ne;
            }
            return tempContainer;
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.ERROR_IN_PROCESSING_NAME_PARAMETER, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.ERROR_IN_PROCESSING_NAME_PARAMETER, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    protected JNDIHandle getLastContextObject(JNDIHandle container, Name name) throws javax.naming.NamingException {
        try {
            JNDIHandle tempContainer = container;
            JNDIHandle containerCandidate = null;
            int count = name.size() - 1;
            int componentIndex = 0;
            while (componentIndex < count) {
                String compositeString = name.get(componentIndex);
                containerCandidate = this.persistent.findObject(tempContainer, compositeString);
                if (containerCandidate == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.PATH_TO_OBJECT_DOES_NOT_EXISTS, new Object[]{compositeString, name});
                    }
                    throw new NameNotFoundException(NameNotFoundException.PATH_TO_OBJECT_DOES_NOT_EXISTS, new Object[]{compositeString, name});
                }
                tempContainer = this.persistent.getLinkedContainer(containerCandidate);
                if (tempContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.INTERMEDIATE_CONTEXT_NOT_FOUND, new Object[]{compositeString, name});
                    }
                    throw new NamingException(NamingException.INTERMEDIATE_CONTEXT_NOT_FOUND, new Object[]{compositeString, name});
                }
                ++componentIndex;
            }
            try {
                this.lastCompoundComponentVariable = name.get(count);
            }
            catch (Exception e) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.INVALID_NAME_PARAMETER, new Object[]{name});
                    JNDIFrame.log.logCatching(e);
                }
                NamingException ne = new NamingException(NamingException.INVALID_NAME_PARAMETER, new Object[]{name}, e);
                ne.log();
                throw ne;
            }
            return containerCandidate;
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.ERROR_IN_PROCESSING_NAME_PARAMETER, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.ERROR_IN_PROCESSING_NAME_PARAMETER, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public void bind(Name name, byte[] objectData, short type, boolean lastSerializationType) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"bind", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_BIND);
        }
        try {
            if (name.size() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_BIND_EMPTY_NAME);
                }
                throw new InvalidNameException(InvalidNameException.CAN_NOT_BIND_EMPTY_NAME);
            }
            JNDIHandle lastContext = this.getLastContextObject(this.rootContainer, name);
            JNDIHandle lastContainer = this.rootContainer;
            if (lastContext != null) {
                lastContainer = this.persistent.getLinkedContainer(lastContext);
            }
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (type != 2 && type != 4 && lastContext != null && this.persistent.getObjectType(lastContext) == 2) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(NamingException.BIND_LOCAL_OBJECT_IN_GLOBAL_CONTEXT, new Object[]{name});
                        }
                        throw new NamingException(NamingException.BIND_LOCAL_OBJECT_IN_GLOBAL_CONTEXT, new Object[]{name});
                    }
                } else {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.NAME_ALREADY_BOUND, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{this.lastCompoundComponentVariable});
                }
                this.persistent.bindObject(lastContainer, this.lastCompoundComponentVariable, objectData, type);
                ServerContextImpl.increaseNumberOfBindings();
            }
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NAME_ALREADY_BOUND, new Object[]{this.lastCompoundComponentVariable});
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{this.lastCompoundComponentVariable}, (Throwable)((Object)jde));
            }
            JNDIFrame.log.logCatching((Throwable)((Object)jde));
            NamingException ne = new NamingException(NamingException.CANNOT_BIND, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebind(Name name, byte[] objectData, short type, boolean lastSerializationType) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (!JNDIFrame.log.toLogInfoInCategory()) throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_REBIND);
            JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"rebind", name});
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_REBIND);
        }
        try {
            if (name.size() == 0) {
                if (!JNDIFrame.log.toLogInfoInCategory()) throw new InvalidNameException(InvalidNameException.CAN_NOT_REBIND_EMPTY_NAME);
                JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_REBIND_EMPTY_NAME);
                throw new InvalidNameException(InvalidNameException.CAN_NOT_REBIND_EMPTY_NAME);
            }
            JNDIHandle lastContext = this.getLastContextObject(this.rootContainer, name);
            JNDIHandle lastContainer = this.rootContainer;
            if (lastContext != null) {
                lastContainer = this.persistent.getLinkedContainer(lastContext);
            }
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object;
                block22: {
                    object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                    if (object != null) {
                        if (this.persistent.getLinkedContainer(object) != null) {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_TO_REBIND_OVER_CONTEXT, new Object[]{name});
                            }
                            throw new NamingException(NamingException.ATTEMPT_TO_REBIND_OVER_CONTEXT, new Object[]{name});
                        }
                        if (type == 2 || type == 4) {
                            short objectType = this.persistent.getObjectType(object);
                            if (objectType == 2 || objectType == 4 || objectType == -1) {
                                cache.removeClusterCache(this.makeCacheName(name));
                                this.persistent.unbindObject(object, type);
                                ServerContextImpl.decreaseNumberOfBindings();
                                break block22;
                            } else {
                                if (JNDIFrame.log.toLogInfoInCategory()) {
                                    JNDIFrame.log.infoT(JNDILogConstants.REBIND_GLOBAL_OBJECT_OVER_LOCAL_OBJECT, new Object[]{name});
                                }
                                throw new NamingException(NamingException.REBIND_GLOBAL_OBJECT_OVER_LOCAL_OBJECT, new Object[]{name});
                            }
                        }
                        if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(JNDILogConstants.REBIND_LOCAL_OBJECT_OVER_GLOBAL_OBJECT, new Object[]{name});
                            }
                            throw new NamingException(NamingException.REBIND_LOCAL_OBJECT_OVER_GLOBAL_OBJECT, new Object[]{name});
                        }
                        cache.removeLocalCache(this.makeCacheName(name));
                        this.persistent.unbindObject(object, type);
                        ServerContextImpl.decreaseNumberOfBindings();
                    } else if (type != 2 && type != 4 && lastContext != null && this.persistent.getObjectType(lastContext) == 2) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.REBIND_LOCAL_OBJECT_IN_GLOBAL_CONTEXT, new Object[]{name});
                        }
                        throw new NamingException(NamingException.REBIND_LOCAL_OBJECT_IN_GLOBAL_CONTEXT, new Object[]{name});
                    }
                }
                object = this.persistent.bindObject(lastContainer, this.lastCompoundComponentVariable, objectData, type);
                ServerContextImpl.increaseNumberOfBindings();
                return;
            }
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                if (JNDIFrame.log.toLogPathInCategory()) {
                    JNDIFrame.log.logPath(NamingException.CANNOT_REBIND, new Object[]{name});
                    JNDIFrame.log.logPath(JNDILogConstants.NAME_ALREADY_BOUND, new Object[]{this.lastCompoundComponentVariable});
                    JNDIFrame.log.logCatching((Throwable)((Object)jde));
                }
                this.rebind(name, objectData, type, lastSerializationType);
                return;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_REBIND, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_REBIND, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public Object lookup(Name name, short type) throws javax.naming.NamingException, RemoteException {
        try {
            String cacheName = this.makeCacheName(name);
            byte[] cached = (byte[])cache.lookupCache(cacheName, false);
            if (cached != null) {
                return cached;
            }
            if (name.size() == 0) {
                ServerContextImpl server = scPool.getObject(this.remote);
                server.reuse(this.persistent.getNewConnection(), this.parentObject, this.rootContainer, (Name)(this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName).clone(), this.onlyLookUpAllowed);
                return server;
            }
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.logInfo(JNDILogConstants.NAME_NOT_FOUND_IN_LOOKUP, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.NAME_NOT_FOUND_IN_LOOKUP, new Object[]{this.lastCompoundComponentVariable});
                }
                JNDIHandle objectContainer = this.persistent.getLinkedContainer(object);
                if (objectContainer != null) {
                    ServerContextImpl server = scPool.getObject(this.remote);
                    server.reuse(this.persistent.getNewConnection(), object, objectContainer, ((Name)(this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName).clone()).addAll(name), this.onlyLookUpAllowed);
                    ServerContextImpl serverContextImpl = server;
                    return serverContextImpl;
                }
                byte[] result = this.persistent.readObject(object);
                if (result != null) {
                    cache.addCache(cacheName, result, false);
                }
                byte[] byArray = result;
                return byArray;
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LOOKUP, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LOOKUP, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unbind(Name name, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (!JNDIFrame.log.toLogInfoInCategory()) throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_UNBIND);
            JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"unbind", name});
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_UNBIND);
        }
        try {
            if (name.size() == 0) {
                if (!JNDIFrame.log.toLogInfoInCategory()) throw new InvalidNameException(InvalidNameException.CAN_NOT_UNBIND_CURRENT_CONTEXT);
                JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_UNBIND_CURRENT_CONTEXT);
                throw new InvalidNameException(InvalidNameException.CAN_NOT_UNBIND_CURRENT_CONTEXT);
            }
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                block16: {
                    JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                    if (object == null) {
                        return;
                    }
                    if (this.persistent.getLinkedContainer(object) != null) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.CANNOT_UNBIND_CONTEXT, new Object[]{name});
                        }
                        throw new NamingException(NamingException.CANNOT_UNBIND_CONTEXT, new Object[]{name});
                    }
                    if (type == 2 || type == 4) {
                        short objectType = this.persistent.getObjectType(object);
                        if (objectType == 2 || objectType == 4 || objectType == -1) {
                            cache.removeClusterCache(this.makeCacheName(name));
                            this.persistent.unbindObject(object, type);
                            ServerContextImpl.decreaseNumberOfBindings();
                            break block16;
                        } else {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(JNDILogConstants.GLOBAL_UNBIND_OVER_LOCAL_OBJECT, new Object[]{name});
                            }
                            throw new NamingException(NamingException.GLOBAL_UNBIND_OVER_LOCAL_OBJECT, new Object[]{name});
                        }
                    }
                    if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                        this.persistent.unbindObject(object, (short)3);
                        ServerContextImpl.decreaseNumberOfBindings();
                    } else {
                        cache.removeLocalCache(this.makeCacheName(name));
                        this.persistent.unbindObject(object, type);
                        ServerContextImpl.decreaseNumberOfBindings();
                    }
                }
                return;
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_UNBIND, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_UNBIND, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public void rename(Name oldName, Name newName, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"rename", oldName});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_RENAME);
        }
        try {
            if (newName.size() == 0 || oldName.size() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_RENAME_WITH_OR_EMPTY_NAME, new Object[]{newName, oldName});
                }
                throw new InvalidNameException(InvalidNameException.CAN_NOT_RENAME_WITH_OR_EMPTY_NAME, new Object[]{newName, oldName});
            }
            if (oldName.equals(newName)) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_RENAME_WITH_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), newName.get(newName.size() - 1)});
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.CANNOT_RENAME_WITH_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), newName.get(newName.size() - 1)});
            }
            JNDIHandle oldLastContainer = this.getLastContainer(this.rootContainer, oldName);
            String oldNameLastComponent = this.lastCompoundComponentVariable;
            JNDIHandle newLastContext = this.getLastContextObject(this.rootContainer, newName);
            JNDIHandle newLastContainer = this.rootContainer;
            Long l = ServerContextImpl.getLockObject(oldLastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object;
                if (newLastContext != null) {
                    newLastContainer = this.persistent.getLinkedContainer(newLastContext);
                }
                if ((object = this.persistent.findObject(oldLastContainer, oldNameLastComponent)) == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.NAME_NOT_FOUND_IN_RENAME, new Object[]{oldNameLastComponent});
                    }
                    throw new NameNotFoundException(NameNotFoundException.NAME_NOT_FOUND_IN_RENAME, new Object[]{oldNameLastComponent});
                }
                if (this.persistent.findObject(newLastContainer, this.lastCompoundComponentVariable) != null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_RENAME_TO_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), this.lastCompoundComponentVariable});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.CANNOT_RENAME_TO_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), this.lastCompoundComponentVariable});
                }
                if (oldLastContainer.getContainerID() == newLastContainer.getContainerID()) {
                    if (type == 2 || type == 4) {
                        short objectType = this.persistent.getObjectType(object);
                        if (objectType == 2 || objectType == 4 || objectType == -1) {
                            cache.removeClusterCache(this.makeCacheName(oldName));
                            this.persistent.renameObject(oldLastContainer, oldNameLastComponent, this.lastCompoundComponentVariable, type);
                            return;
                        }
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.GLOBAL_RENAME_OVER_LOCAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                        }
                        throw new NamingException(NamingException.GLOBAL_RENAME_OVER_LOCAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                    }
                    if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.LOCAL_RENAME_OVER_GLOBAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                        }
                        throw new NamingException(NamingException.LOCAL_RENAME_OVER_GLOBAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                    }
                    cache.removeLocalCache(this.makeCacheName(oldName));
                    this.persistent.renameObject(oldLastContainer, oldNameLastComponent, this.lastCompoundComponentVariable, type);
                    return;
                }
                if (type == 2 || type == 4) {
                    short objectType = this.persistent.getObjectType(object);
                    if (objectType == 2 || objectType == 4 || objectType == -1) {
                        cache.removeClusterCache(this.makeCacheName(oldName));
                        this.persistent.moveObject(oldLastContainer, oldNameLastComponent, newLastContainer, this.lastCompoundComponentVariable, type);
                        return;
                    }
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.GLOBAL_RENAME_OVER_LOCAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                    }
                    throw new NamingException(NamingException.GLOBAL_RENAME_OVER_LOCAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                }
                if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.LOCAL_RENAME_OVER_GLOBAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                    }
                    throw new NamingException(NamingException.LOCAL_RENAME_OVER_GLOBAL_OBJECT, new Object[]{oldName.get(newName.size() - 1)});
                }
                cache.removeLocalCache(this.makeCacheName(oldName));
                this.persistent.moveObject(oldLastContainer, oldNameLastComponent, newLastContainer, this.lastCompoundComponentVariable, type);
                return;
            }
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_RENAME_TO_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), this.lastCompoundComponentVariable});
                    JNDIFrame.log.logCatching((Throwable)((Object)jde));
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.CANNOT_RENAME_TO_NAME__WHICH_IS_ALREADY_BOUND, new Object[]{oldName.get(newName.size() - 1), this.lastCompoundComponentVariable});
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_RENAME, new Object[]{oldName, newName});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_RENAME, new Object[]{oldName, newName});
            ne.log();
            throw ne;
        }
    }

    public ServerContextInface createSubcontext(Name name, Attributes attr, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"createSubcontext", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_CREATE_SUBCONTEXT);
        }
        try {
            if (name.size() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_CREATE_CONTEXT_OVER_ROOT_CONTEXT);
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.CANNOT_CREATE_CONTEXT_OVER_ROOT_CONTEXT);
            }
            JNDIHandle lastContext = this.getLastContextObject(this.rootContainer, name);
            JNDIHandle lastContainer = this.rootContainer;
            if (lastContext != null) {
                lastContainer = this.persistent.getLinkedContainer(lastContext);
            }
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle contextObject = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (contextObject != null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CONTEXT_ALREADY_EXISTS, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.CONTEXT_ALREADY_EXISTS, new Object[]{this.lastCompoundComponentVariable});
                }
                boolean toReplicate = false;
                JNDIHandle handle = null;
                if (type == 2 || type == 4) {
                    toReplicate = true;
                }
                handle = this.persistent.bindObject(lastContainer, this.lastCompoundComponentVariable, DirObject.getNewDirObject(attr, null), type);
                Properties properties = new Properties();
                try {
                    if (lastContainer != null) {
                        properties = (Properties)Serializator.toObject(this.persistent.readContainer(lastContainer));
                    }
                }
                catch (Exception e) {
                    properties = new Properties();
                }
                String containerName = this.persistent.getContainerName(lastContainer) + "/" + this.lastCompoundComponentVariable;
                JNDIHandle newContainer = this.persistent.createContainer(containerName, Serializator.toByteArray(properties), toReplicate);
                this.persistent.linkObjectToContainer(handle, newContainer, toReplicate ? type : (short)3);
                ServerContextImpl newContext = scPool.getObject(this.remote);
                newContext.reuse(this.persistent.getNewConnection(), handle, newContainer, ((Name)(this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName).clone()).addAll(name), this.onlyLookUpAllowed);
                ServerContextImpl serverContextImpl = newContext;
                return serverContextImpl;
            }
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CONTEXT_ALREADY_EXISTS, new Object[]{this.lastCompoundComponentVariable});
                    JNDIFrame.log.logCatching((Throwable)((Object)jde));
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.CONTEXT_ALREADY_EXISTS, new Object[]{this.lastCompoundComponentVariable});
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_CREATE_SUBCONTEXT, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_CREATE_SUBCONTEXT, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroySubcontext(Name name, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (!JNDIFrame.log.toLogInfoInCategory()) throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_DESTROY_SUBCONTEXT);
            JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"destroySubcontext", name});
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_DESTROY_SUBCONTEXT);
        }
        try {
            if (name.size() == 0) {
                if (!JNDIFrame.log.toLogInfoInCategory()) throw new NamingException(NamingException.CANNOT_DESTROY_CURRENT_CONTEXT);
                JNDIFrame.log.infoT(JNDILogConstants.CANNOT_DESTROY_CURRENT_CONTEXT);
                throw new NamingException(NamingException.CANNOT_DESTROY_CURRENT_CONTEXT);
            }
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle lastContainerObject = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (lastContainerObject == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.NAME_NOT_FOUND_IN_DESTROY_SUBCONTEXT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.NAME_NOT_FOUND_IN_DESTROY_SUBCONTEXT, new Object[]{this.lastCompoundComponentVariable});
                }
                JNDIHandle toDeleteContainer = this.persistent.getLinkedContainer(lastContainerObject);
                if (toDeleteContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_DESTROY_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NotContextException(NotContextException.CANNOT_DESTROY_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                }
                long cid = toDeleteContainer.getContainerID();
                Long l2 = ServerContextImpl.getLockObject(cid);
                synchronized (l2) {
                    try {
                        block23: {
                            JNDIHandleEnumeration en = this.persistent.listObjects(toDeleteContainer, "*");
                            try {
                                if (en.hasMoreElements()) {
                                    if (JNDIFrame.log.toLogInfoInCategory()) {
                                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_DESTROY_NOT_EMPTY_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                                    }
                                    throw new ContextNotEmptyException(ContextNotEmptyException.CANNOT_DESTROY_NOT_EMPTY_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                                }
                                Object var12_12 = null;
                                en.closeEnumeration();
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                en.closeEnumeration();
                                throw throwable;
                            }
                            if (type == 2 || type == 4) {
                                short objectType = this.persistent.getObjectType(lastContainerObject);
                                if (objectType == 2 || objectType == 4 || objectType == -1) {
                                    this.persistent.deleteContainer(toDeleteContainer, true);
                                    this.persistent.unbindObject(lastContainerObject, type);
                                    break block23;
                                } else {
                                    if (JNDIFrame.log.toLogInfoInCategory()) {
                                        JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_FOR_GLOBAL_DESTROY_OF_LOCAL_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                                    }
                                    throw new NamingException(NamingException.ATTEMPT_FOR_GLOBAL_DESTROY_OF_LOCAL_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                                }
                            }
                            this.persistent.deleteContainer(toDeleteContainer, false);
                            this.persistent.unbindObject(lastContainerObject, type);
                        }
                        Object var14_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        ServerContextImpl.unlockObject(cid);
                        throw throwable;
                    }
                    ServerContextImpl.unlockObject(cid);
                    return;
                }
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_DESTROY_SUBCONTEXT, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_DESTROY_SUBCONTEXT, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public ServerNamingEnum listBindings(Name name, short type, boolean onserver) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"listBindings", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_LIST_BINDINGS);
        }
        try {
            Serializable object;
            JNDIHandle lastContainer;
            if (name.size() == 0) {
                lastContainer = this.rootContainer;
            } else {
                lastContainer = this.getLastContainer(this.rootContainer, name);
                object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.PATH_TO_OBJECT_DOESNOT_EXISTS_IN_LISTBINDINGS, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.PATH_TO_OBJECT_DOESNOT_EXISTS_IN_LISTBINDINGS, new Object[]{this.lastCompoundComponentVariable});
                }
                lastContainer = this.persistent.getLinkedContainer((JNDIHandle)object);
                if (lastContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_LISTBINDINGS_IN_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NotContextException(NotContextException.CANNOT_LISTBINDINGS_IN_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                }
            }
            object = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (object) {
                JNDIHandleEnumeration jhe = this.persistent.listObjects(lastContainer, "*");
                if (jhe == null) {
                    // empty if block
                }
                ServerNamingEnumImpl serverNamingEnumImpl = new ServerNamingEnumImpl(this.persistent.getNewConnection(), jhe, 1, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.onlyLookUpAllowed, this.remote, this.redirectableContext);
                return serverNamingEnumImpl;
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LIST_BINDINGS, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LIST_BINDINGS, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public ServerNamingEnum list(Name name, short type, boolean onserver) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"list", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_LIST);
        }
        try {
            Serializable object;
            JNDIHandle lastContainer;
            if (name.size() == 0) {
                lastContainer = this.rootContainer;
            } else {
                lastContainer = this.getLastContainer(this.rootContainer, name);
                object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.PATH_TO_OBJECT_DOESNOT_EXISTS_IN_LIST, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.PATH_TO_OBJECT_DOESNOT_EXISTS_IN_LIST, new Object[]{this.lastCompoundComponentVariable});
                }
                lastContainer = this.persistent.getLinkedContainer((JNDIHandle)object);
                if (lastContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_LIST_IN_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NotContextException(NotContextException.CANNOT_LIST_IN_OBJECT_OR_FOREIGN_CONTEXT, new Object[]{this.lastCompoundComponentVariable});
                }
            }
            object = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (object) {
                JNDIHandleEnumeration jhe = this.persistent.listObjects(lastContainer, "*");
                if (jhe == null) {
                    // empty if block
                }
                ServerNamingEnumImpl serverNamingEnumImpl = new ServerNamingEnumImpl(this.persistent.getNewConnection(), jhe, 2, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.onlyLookUpAllowed, this.remote, this.redirectableContext);
                return serverNamingEnumImpl;
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LIST, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LIST, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public Attributes getAttributes(Name name, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"getAttributes", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_GET_ATTRIBUTES);
        }
        try {
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.OBJECT_DOESNOT_EXISTS_IN_GET_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.OBJECT_DOESNOT_EXISTS_IN_GET_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                }
                Attributes attrToReturn = DirObject.getAttributes(this.persistent.readObject(object));
                if (attrToReturn == null) {
                    attrToReturn = new BasicAttributes();
                }
                Attributes attributes = attrToReturn;
                return attributes;
            }
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public Attributes getAttributes(Name name, String[] attrIDs, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"getAttributes", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_GET_ATTRIBUTES);
        }
        try {
            Attributes attrsToReturn = new BasicAttributes();
            Attributes attrs = this.getAttributes(name, type);
            if (attrIDs == null) {
                attrsToReturn = attrs;
            } else if (attrIDs.length != 0) {
                int i = 0;
                while (i < attrIDs.length) {
                    String tempID = attrIDs[i];
                    Attribute attribute = attrs.get(tempID);
                    if (attribute != null) {
                        attrsToReturn.put(attribute);
                    }
                    ++i;
                }
            }
            return attrsToReturn;
        }
        catch (Exception jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(jde);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name}, jde);
            ne.log();
            throw ne;
        }
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs, short type) throws javax.naming.directory.AttributeModificationException, javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"modifyAttributes", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_MODIFY_ATTRIBUTES);
        }
        try {
            if (attrs == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.ATTRIBUTES_FOR_MODIFICATION_CANNOT_BE_NULL);
                }
                throw new AttributeModificationException(AttributeModificationException.ATTRIBUTES_FOR_MODIFICATION_CANNOT_BE_NULL);
            }
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.OBJECT_DOESNOT_EXISTS_IN_MODIFY_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.OBJECT_DOESNOT_EXISTS_IN_MODIFY_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                }
                byte[] data = this.persistent.readObject(object);
                Attributes attrToModify = DirObject.getAttributes(data);
                if (attrToModify == null) {
                    attrToModify = new BasicAttributes();
                }
                ModifyAttributes.modAttr(attrToModify, mod_op, attrs);
                data = DirObject.setAttributes(data, attrToModify);
                if (type == 2 || type == 4) {
                    short objectType = this.persistent.getObjectType(object);
                    if (objectType == 2 || objectType == 4 || objectType == -1) {
                        cache.removeClusterCache(this.makeCacheName(name));
                        this.persistent.rebindObject(object, data, type);
                        return;
                    }
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_FOR_GLOBAL_MODIFY_ATTRIBUTES_OF_LOCAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NamingException(NamingException.ATTEMPT_FOR_GLOBAL_MODIFY_ATTRIBUTES_OF_LOCAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                }
                if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_FOR_LOCAL_MODIFY_ATTRIBUTES_OF_GLOBAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NamingException(NamingException.ATTEMPT_FOR_LOCAL_MODIFY_ATTRIBUTES_OF_GLOBAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                }
                cache.removeLocalCache(this.makeCacheName(name));
                this.persistent.rebindObject(object, data, type);
                return;
            }
        }
        catch (javax.naming.directory.AttributeModificationException ame) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ame);
            }
            AttributeModificationException amex = new AttributeModificationException(AttributeModificationException.CANNOT_MODIFY_ATTRIBUTES, ame);
            amex.log();
            throw amex;
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() != 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                    JNDIFrame.log.logCatching((Throwable)((Object)jde));
                }
                NamingException ne = new NamingException(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name}, (Throwable)((Object)jde));
                ne.log();
                throw ne;
            }
            this.modifyAttributes(name, mod_op, attrs, type);
            return;
        }
    }

    public void modifyAttributes(Name name, ModificationItem[] mods, short type) throws javax.naming.directory.AttributeModificationException, javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"modifyAttributes", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_MODIFY_ATTRIBUTES);
        }
        try {
            if (mods == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.MODIFICATION_ITEM_ARRAY_CANNOT_BE_NULL);
                }
                throw new AttributeModificationException(AttributeModificationException.MODIFICATION_ITEM_ARRAY_CANNOT_BE_NULL);
            }
            JNDIHandle lastContainer = this.getLastContainer(this.rootContainer, name);
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.OBJECT_DOESNOT_EXISTS_IN_MODIFY_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.OBJECT_DOESNOT_EXISTS_IN_MODIFY_ATRIBUTES, new Object[]{this.lastCompoundComponentVariable});
                }
                byte[] dobj = this.persistent.readObject(object);
                Attributes attrToModify = DirObject.getAttributes(dobj);
                if (attrToModify == null) {
                    attrToModify = new BasicAttributes();
                }
                ModifyAttributes.modAttr(attrToModify, mods);
                dobj = DirObject.setAttributes(dobj, attrToModify);
                if (type == 2 || type == 4) {
                    short objectType = this.persistent.getObjectType(object);
                    if (objectType == 2 || objectType == 4 || objectType == -1) {
                        cache.removeClusterCache(this.makeCacheName(name));
                        this.persistent.rebindObject(object, dobj, type);
                        return;
                    }
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_FOR_GLOBAL_MODIFY_ATTRIBUTES_OF_LOCAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NamingException(NamingException.ATTEMPT_FOR_GLOBAL_MODIFY_ATTRIBUTES_OF_LOCAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                }
                if (this.persistent.getObjectType(object) == 2 || this.persistent.getObjectType(object) == 4) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.ATTEMPT_FOR_LOCAL_MODIFY_ATTRIBUTES_OF_GLOBAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NamingException(NamingException.ATTEMPT_FOR_LOCAL_MODIFY_ATTRIBUTES_OF_GLOBAL_OBJECT, new Object[]{this.lastCompoundComponentVariable});
                }
                cache.removeLocalCache(this.makeCacheName(name));
                this.persistent.rebindObject(object, dobj, type);
                return;
            }
        }
        catch (javax.naming.directory.AttributeModificationException ame) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ame);
            }
            AttributeModificationException amex = new AttributeModificationException(AttributeModificationException.CANNOT_MODIFY_ATTRIBUTES, ame);
            amex.log();
            throw amex;
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() != 0) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                    JNDIFrame.log.logCatching((Throwable)((Object)jde));
                }
                NamingException ne = new NamingException(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name}, (Throwable)((Object)jde));
                ne.log();
                throw ne;
            }
            this.modifyAttributes(name, mods, type);
            return;
        }
    }

    public ServerNamingEnum search(Name name, Attributes matchingAttributes, String[] attributesToReturn, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"search", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_SEARCH);
        }
        try {
            JNDIHandle lastContainer;
            JNDIHandleEnumeration jhe = null;
            if (name.size() == 0) {
                lastContainer = this.rootContainer;
            } else {
                lastContainer = this.getLastContainer(this.rootContainer, name);
                JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                if (object == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.OBJECT_DOESNOT_EXISTS_IN_SEARCH, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NameNotFoundException(NameNotFoundException.OBJECT_DOESNOT_EXISTS_IN_SEARCH, new Object[]{this.lastCompoundComponentVariable});
                }
                lastContainer = this.persistent.getLinkedContainer(object);
                if (lastContainer == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH_OVER_BINDING, new Object[]{this.lastCompoundComponentVariable});
                    }
                    throw new NotContextException(NotContextException.CANNOT_SEARCH_OVER_BINDING, new Object[]{this.lastCompoundComponentVariable});
                }
            }
            Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
            synchronized (l) {
                jhe = this.persistent.listObjects(lastContainer, "*");
                if (jhe == null) {
                    // empty if block
                }
            }
            if (matchingAttributes == null) {
                matchingAttributes = new BasicAttributes();
            }
            return new ServerNamingSearchEnumImpl(this.persistent.getNewConnection(), jhe, matchingAttributes, attributesToReturn, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.remote, this.onlyLookUpAllowed, this.redirectableContext);
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_SEARCH, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_SEARCH, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public ServerNamingEnum search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"search", name});
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_SEARCH);
        }
        try {
            JNDIHandle parentHandle;
            JNDIHandle lastContainer;
            if (filterExpr == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH_LIST_OPERATION_IS_NOT_ALLOWED, new Object[]{name});
                }
                throw new NamingException(NamingException.CANNOT_SEARCH_LIST_OPERATION_IS_NOT_ALLOWED, new Object[]{name});
            }
            byte[] dobj = null;
            if (name.size() == 0) {
                lastContainer = this.rootContainer;
                parentHandle = this.parentObject;
                if (cons.getSearchScope() == 0) {
                    return new ServerNamingOneObjectEnumImpl(this.persistent.getNewConnection(), parentHandle, filterExpr, filterArgs, cons, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.remote, this.onlyLookUpAllowed, this.redirectableContext);
                }
            } else {
                lastContainer = this.getLastContainer(this.rootContainer, name);
                Long l = ServerContextImpl.getLockObject(lastContainer.getContainerID());
                synchronized (l) {
                    JNDIHandle object = this.persistent.findObject(lastContainer, this.lastCompoundComponentVariable);
                    if (object == null) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.OBJECT_DOESNOT_EXISTS_IN_SEARCH, new Object[]{this.lastCompoundComponentVariable});
                        }
                        throw new NameNotFoundException(NameNotFoundException.OBJECT_DOESNOT_EXISTS_IN_SEARCH, new Object[]{this.lastCompoundComponentVariable});
                    }
                    if (cons.getSearchScope() == 0) {
                        ServerNamingOneObjectEnumImpl serverNamingOneObjectEnumImpl = new ServerNamingOneObjectEnumImpl(this.persistent.getNewConnection(), object, filterExpr, filterArgs, cons, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.remote, this.onlyLookUpAllowed, this.redirectableContext);
                        return serverNamingOneObjectEnumImpl;
                    }
                    dobj = this.persistent.readObject(object);
                    parentHandle = object;
                    lastContainer = this.persistent.getLinkedContainer(object);
                    if (lastContainer == null) {
                        if (cons.getSearchScope() != 1) {
                            ServerNamingOneObjectEnumImpl serverNamingOneObjectEnumImpl = new ServerNamingOneObjectEnumImpl(this.persistent.getNewConnection(), object, filterExpr, filterArgs, cons, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.remote, this.onlyLookUpAllowed, this.redirectableContext);
                            return serverNamingOneObjectEnumImpl;
                        }
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH_OVER_BINDING, new Object[]{this.lastCompoundComponentVariable});
                        }
                        throw new NotContextException(NotContextException.CANNOT_SEARCH_OVER_BINDING, new Object[]{this.lastCompoundComponentVariable});
                    }
                }
            }
            return new ServerNamingSearchFilterEnumImpl(this.persistent.getNewConnection(), parentHandle, lastContainer, dobj, filterExpr, filterArgs, cons, this.rootName == null ? (this.rootName = new CompositeName("")) : this.rootName, this.remote, this.onlyLookUpAllowed, this.redirectableContext);
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_SEARCH, new Object[]{name});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_SEARCH, new Object[]{name}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public Properties getEnvironment(short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION_TO_GET_ENVIROMENT);
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_GET_ENVIROMENT);
        }
        try {
            byte[] tempb = this.persistent.readContainer(this.rootContainer);
            Properties temp = tempb != null ? (Properties)Serializator.toObject(tempb) : new Properties();
            return temp;
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_ENVIROMENT);
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_ENVIROMENT, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public String removeFromEnvironment(String propName, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION_TO_REMOVE_FROM_ENVIROMENT);
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_REMOVE_FROM_ENVIROMENT);
        }
        try {
            byte[] tempb = this.persistent.readContainer(this.rootContainer);
            Properties temp = tempb != null ? (Properties)Serializator.toObject(tempb) : new Properties();
            String toReturn = temp.getProperty(propName);
            ((Hashtable)temp).remove(propName);
            this.persistent.modifyContainer(this.rootContainer, Serializator.toByteArray(temp), false);
            return toReturn;
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_REMOVE_FROM_ENVIROMENT);
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_REMOVE_FROM_ENVIROMENT, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public String addToEnvironment(String propName, String propVal, short type) throws javax.naming.NamingException, RemoteException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NoPermissionException.NO_PERMISSION_TO_ADD_TO_ENVIROMENT);
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_ADD_TO_ENVIROMENT);
        }
        try {
            byte[] tempb = this.persistent.readContainer(this.rootContainer);
            Properties temp = tempb != null ? (Properties)Serializator.toObject(tempb) : new Properties();
            String toReturn = temp.getProperty(propName);
            temp.setProperty(propName, propVal);
            this.persistent.modifyContainer(this.rootContainer, Serializator.toByteArray(temp), false);
            return toReturn;
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                return this.addToEnvironment(propName, propVal, type);
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_ADD_TO_ENVIROMENT);
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_ADD_TO_ENVIROMENT, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public boolean targetMustExist() throws javax.naming.NamingException, RemoteException {
        return true;
    }

    public void close() throws RemoteException, javax.naming.NamingException {
        if (!this.disposed) {
            try {
                PortableRemoteObject.unexportObject((Remote)this);
                this.disposed = true;
            }
            catch (Exception e) {
                this.disposed = true;
            }
        }
    }

    public String getObjectName(JNDIHandle object) throws RemoteException, javax.naming.NamingException {
        try {
            return this.persistent.getObjectName(object);
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_OBJECT_NAME);
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_OBJECT_NAME, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public void finalize() {
        if (!this.disposed) {
            this.disposed = true;
            try {
                super.finalize();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (OutOfMemoryError o) {
                JNDIFrame.log.logError(JNDILogConstants.OUT_OF_MEMORY_ERROR);
                JNDIFrame.log.logCatching(o);
                LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), JNDILogConstants.OUT_OF_MEMORY_ERROR);
                System.out.println(formater.toString());
                System.exit(666);
            }
            catch (Throwable t) {
                JNDIFrame.log.logCatching(t);
                BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.ERROR_IN_FINALIZE_METHOD), t);
                bre.log();
                throw bre;
            }
            scPool.releaseObject(this);
        }
    }

    public void reuse(JNDIPersistentRepository jp, JNDIHandle parentObject, JNDIHandle container) {
        this.persistent = jp;
        this.parentObject = parentObject;
        this.rootContainer = container;
        this.disposed = false;
    }

    public void reuse(JNDIPersistentRepository jp, JNDIHandle parentObject, JNDIHandle container, Name name, boolean onlyLookupAllowed) {
        this.persistent = jp;
        this.parentObject = parentObject;
        this.rootContainer = container;
        this.disposed = false;
        this.rootName = name;
        this.onlyLookUpAllowed = onlyLookupAllowed;
    }

    public void print(PrintStream outStrm) throws RemoteException, javax.naming.NamingException {
        if (!SecurityBase.WITHOUT_SECURITY && this.onlyLookUpAllowed) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION_TO_LIST);
            }
            throw new NoPermissionException(NoPermissionException.NO_PERMISSION_TO_LIST);
        }
        try {
            this.persistent.printTree(outStrm);
        }
        catch (JNDIException jde) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(NamingException.CANNOT_PRINT);
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_PRINT, (Throwable)((Object)jde));
            ne.setRootCause((Throwable)((Object)jde));
            throw ne;
        }
    }

    public void allowOperation(String userName, String permissionName, boolean isGroup) throws javax.naming.NamingException, RemoteException {
        try {
            SecurityBase.allowOperation(userName, permissionName, isGroup);
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                this.allowOperation(userName, permissionName, isGroup);
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CAN_NOT_ALLOW_OPERATION, new Object[]{userName, permissionName});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CAN_NOT_ALLOW_OPERATION, new Object[]{userName, permissionName}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    public void denyOperation(String userName, String permissionName, boolean isGroup) throws javax.naming.NamingException, RemoteException {
        try {
            SecurityBase.denyOperation(userName, permissionName, isGroup);
        }
        catch (JNDIException jde) {
            if (jde.getExceptionType() == 0) {
                this.allowOperation(userName, permissionName, isGroup);
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CAN_NOT_DENY_OPERATION, new Object[]{userName, permissionName});
                JNDIFrame.log.logCatching((Throwable)((Object)jde));
            }
            NamingException ne = new NamingException(NamingException.CAN_NOT_DENY_OPERATION, new Object[]{userName, permissionName}, (Throwable)((Object)jde));
            ne.log();
            throw ne;
        }
    }

    private void dump(String s) {
        System.out.println(" -> " + s);
    }

    private void dumplist(String s) {
        this.dump("SERVER_LIST:" + s);
    }

    private void dumpsearch(String s) {
        this.dump("SERVER_LIST:" + s);
    }

    private void dumpbind(String s) {
        this.dump("SERVER_BIND:" + s);
    }

    private void dumplookup(String s) {
        this.dump("SERVER_LOOKUP:" + s);
    }

    private void dumprename(String s) {
        this.dump("SERVER_RENAME:" + s);
    }

    private void dumprebind(String s) {
        this.dump("SERVER_REBIND:" + s);
    }

    private void dumpunbind(String s) {
        this.dump("SERVER_UNBIND:" + s);
    }

    private void dumpgetattributes(String s) {
        this.dump("GET_ATTRIBUTES:" + s);
    }

    private void dumpmodifyattributes(String s) {
        this.dump("MODIFY_ATTRIBUTES:" + s);
    }

    private void dumpget(String s) {
        this.dump("SERVER_GET_LAST_CONTAINER:" + s);
    }

    private void dumpcsub(String s) {
        this.dump("SERVER_CREATE_SUBCONTEXT:" + s);
    }

    private void dumpdestroy(String s) {
        this.dump("SERVER_DESTROY_SUBCONTEXT:" + s);
    }

    public static synchronized void increaseNumberOfBindings() {
        ++numberOfBindings;
    }

    public static synchronized void decreaseNumberOfBindings() {
        --numberOfBindings;
    }

    public static synchronized int getNumberOfBindings() {
        return numberOfBindings;
    }

    public static Long getLockObject(long id) {
        HashMapLongObject hashMapLongObject = keys;
        synchronized (hashMapLongObject) {
            Long result = (Long)keys.get(id);
            if (result == null) {
                result = new Long(id);
                keys.put(id, result);
                Long l = result;
                return l;
            }
            Long l = result;
            return l;
        }
    }

    public static void unlockObject(long id) {
        HashMapLongObject hashMapLongObject = keys;
        synchronized (hashMapLongObject) {
            keys.remove(id);
        }
    }

    static {
        if (JNDIFrame.getCacheCommunicator() != null) {
            cache = new CacheHashtableImpl(JNDIFrame.getCacheCommunicator());
            DeployNotificationListenerImpl.setCache(cache);
        }
    }
}

