/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.implserver.AttrFilter;
import com.sap.engine.services.jndi.implserver.StringFilter;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.exceptions.OperationNotSupportedException;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchFilterException;

public class SearchFilter
implements AttrFilter {
    String filter;
    int pos;
    private StringFilter rootFilter;
    protected static final boolean debug = false;
    protected static final char BEGIN_FILTER_TOKEN = '(';
    protected static final char END_FILTER_TOKEN = ')';
    protected static final char AND_TOKEN = '&';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static final int EQUAL_MATCH = 1;
    static final int APPROX_MATCH = 2;
    static final int GREATER_MATCH = 3;
    static final int LESS_MATCH = 4;

    public SearchFilter(String s) throws InvalidSearchFilterException {
        this.filter = s;
        this.pos = 0;
        this.normalizeFilter();
        this.rootFilter = this.createNextFilter();
    }

    public boolean check(Attributes attributes) throws NamingException {
        if (attributes == null) {
            return false;
        }
        return this.rootFilter.check(attributes);
    }

    protected void consumeChar() {
        ++this.pos;
    }

    protected void consumeChars(int i) {
        this.pos += i;
    }

    protected StringFilter createNextFilter() throws InvalidSearchFilterException {
        StringFilter obj;
        this.skipWhiteSpace();
        try {
            if (this.getCurrentChar() != '(') {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.EXPECTED_LEFT_BRACKET, new Object[]{new Integer(this.pos)});
                }
                throw new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.EXPECTED_LEFT_BRACKET, new Object[]{new Integer(this.pos)});
            }
            this.consumeChar();
            this.skipWhiteSpace();
            switch (this.getCurrentChar()) {
                case '&': {
                    obj = new CompoundFilter(true);
                    ((StringFilter)obj).parse();
                    break;
                }
                case '|': {
                    obj = new CompoundFilter(false);
                    ((StringFilter)obj).parse();
                    break;
                }
                case '!': {
                    obj = new NotFilter();
                    ((StringFilter)obj).parse();
                    break;
                }
                default: {
                    obj = new AtomicFilter();
                    ((StringFilter)obj).parse();
                }
            }
            this.skipWhiteSpace();
            if (this.getCurrentChar() != ')') {
                throw new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.EXPECTED_RIGHT_BRACKET, new Object[]{new Integer(this.pos)});
            }
            this.consumeChar();
        }
        catch (InvalidSearchFilterException e) {
            JNDIFrame.log.logCatching(e);
            com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException isfe = new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.ERROR_WHILE_PROCCESING_FILTER, new Object[]{this.filter}, e);
            isfe.log();
            throw isfe;
        }
        catch (Exception exception) {
            JNDIFrame.log.logCatching(exception);
            com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException isfe = new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.CANNOT_PARSE_CHARACTER, new Object[]{new Integer(this.pos), this.filter}, exception);
            isfe.log();
            throw isfe;
        }
        return obj;
    }

    public static int findUnescaped(char c, String s, int i) {
        int j = s.length();
        while (i < j) {
            int k = s.indexOf(c, i);
            if (k == i || k == -1 || s.charAt(k - 1) != '\\') {
                return k;
            }
            i = k + 1;
        }
        return -1;
    }

    public static String format(String s, Object[] aobj) throws NamingException {
        int j = 0;
        int k = 0;
        StringBuffer stringbuffer = new StringBuffer(s.length());
        while ((j = SearchFilter.findUnescaped('{', s, k)) >= 0) {
            int i;
            int l = j + 1;
            int i1 = s.indexOf(125, l);
            if (i1 < 0) {
                throw new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.UNBALANCED_OPEN_BRACKET, new Object[]{s});
            }
            try {
                i = Integer.parseInt(s.substring(l, i1));
            }
            catch (NumberFormatException ex) {
                com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException isfe = new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.INTEGER_EXCPECTED_INSIDE_BRACKETS, new Object[]{s}, ex);
                isfe.log();
                throw isfe;
            }
            if (i >= aobj.length) {
                throw new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.NUMBER_EXCEEDS_ARGUMENT_LIST, new Object[]{new Integer(i)});
            }
            stringbuffer.append(s.substring(k, j)).append(SearchFilter.getEncodedStringRep(aobj[i]));
            k = i1 + 1;
        }
        if (k < s.length()) {
            stringbuffer.append(s.substring(k));
        }
        return stringbuffer.toString();
    }

    public static String format(Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            return "objectClass=*";
        }
        String s = "(& ";
        NamingEnumeration<? extends Attribute> namingenumeration = attributes.getAll();
        while (namingenumeration.hasMore()) {
            Attribute attribute = namingenumeration.next();
            if (attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null) {
                s = s + "(" + attribute.getID() + "=" + "*)";
                continue;
            }
            NamingEnumeration<?> namingenumeration1 = attribute.getAll();
            while (namingenumeration1.hasMore()) {
                String s1 = SearchFilter.getEncodedStringRep(namingenumeration1.next());
                if (s1 == null) continue;
                s = s + "(" + attribute.getID() + "=" + s1 + ")";
            }
        }
        s = s + ")";
        return s;
    }

    protected char getCurrentChar() {
        return this.filter.charAt(this.pos);
    }

    private static String getEncodedStringRep(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            byte[] abyte0 = (byte[])obj;
            StringBuffer stringbuffer = new StringBuffer(abyte0.length * 3);
            int j = 0;
            while (j < abyte0.length) {
                stringbuffer.append('\\');
                SearchFilter.hexDigit(stringbuffer, abyte0[j]);
                ++j;
            }
            return stringbuffer.toString();
        }
        String s = !(obj instanceof String) ? obj.toString() : (String)obj;
        int i = s.length();
        StringBuffer stringbuffer1 = new StringBuffer(i);
        int k = 0;
        while (k < i) {
            char c = s.charAt(k);
            switch (c) {
                case '*': {
                    stringbuffer1.append("\\2a");
                    break;
                }
                case '(': {
                    stringbuffer1.append("\\28");
                    break;
                }
                case ')': {
                    stringbuffer1.append("\\29");
                    break;
                }
                case '\\': {
                    stringbuffer1.append("\\5c");
                    break;
                }
                case '\u0000': {
                    stringbuffer1.append("\\00");
                    break;
                }
                default: {
                    stringbuffer1.append(c);
                }
            }
            ++k;
        }
        return stringbuffer1.toString();
    }

    private static void hexDigit(StringBuffer stringbuffer, byte byte0) {
        char c = (char)(byte0 >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringbuffer.append(c);
        c = (char)(byte0 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringbuffer.append(c);
    }

    protected void normalizeFilter() {
        this.skipWhiteSpace();
        if (this.getCurrentChar() != '(') {
            this.filter = '(' + this.filter + ')';
        }
    }

    protected char relCharAt(int i) {
        return this.filter.charAt(this.pos + i);
    }

    protected int relIndexOf(int i) {
        return this.filter.indexOf(i, this.pos) - this.pos;
    }

    protected String relSubstring(int i, int j) {
        return this.filter.substring(i + this.pos, j + this.pos);
    }

    public static Attributes selectAttributes(Attributes attributes, String[] as) {
        if (as == null) {
            return attributes;
        }
        BasicAttributes basicattributes = new BasicAttributes();
        int i = 0;
        while (i < as.length) {
            Attribute attribute = attributes.get(as[i]);
            if (attribute != null) {
                basicattributes.put(attribute);
            }
            ++i;
        }
        return basicattributes;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.getCurrentChar())) {
            this.consumeChar();
        }
    }

    final class AtomicFilter
    implements StringFilter {
        private String attrID;
        private String value;
        private int matchType;

        /*
         * Unable to fully structure code
         */
        public boolean check(Attributes attributes) {
            namingenumeration = null;
            try {
                attribute = attributes.get(this.attrID);
                if (attribute == null) {
                    return false;
                }
                namingenumeration = attribute.getAll();
                if (true) ** GOTO lbl25
            }
            catch (NamingException ex) {
                JNDIFrame.log.logCatching(ex);
                return false;
            }
            block7: do {
                s = namingenumeration.nextElement().toString();
                switch (this.matchType) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (!this.substringMatch(this.value, s)) continue block7;
                        return true;
                    }
                    case 3: {
                        if (s.compareTo(this.value) < 0) continue block7;
                        return true;
                    }
                    case 4: {
                        if (s.compareTo(this.value) > 0) continue block7;
                        return true;
                    }
                }
lbl25:
                // 5 sources

            } while (namingenumeration.hasMoreElements());
            return false;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.skipWhiteSpace();
            try {
                int i = SearchFilter.this.relIndexOf(41);
                int j = SearchFilter.this.relIndexOf(61);
                char c = SearchFilter.this.relCharAt(j - 1);
                switch (c) {
                    case '~': {
                        this.matchType = 2;
                        this.attrID = SearchFilter.this.relSubstring(0, j - 1);
                        this.value = SearchFilter.this.relSubstring(j + 1, i);
                        break;
                    }
                    case '>': {
                        this.matchType = 3;
                        this.attrID = SearchFilter.this.relSubstring(0, j - 1);
                        this.value = SearchFilter.this.relSubstring(j + 1, i);
                        break;
                    }
                    case '<': {
                        this.matchType = 4;
                        this.attrID = SearchFilter.this.relSubstring(0, j - 1);
                        this.value = SearchFilter.this.relSubstring(j + 1, i);
                        break;
                    }
                    case ':': {
                        throw new OperationNotSupportedException(OperationNotSupportedException.EXTENSIBLE_MATCH_NOT_SUPPORTED);
                    }
                    default: {
                        this.matchType = 1;
                        this.attrID = SearchFilter.this.relSubstring(0, j);
                        this.value = SearchFilter.this.relSubstring(j + 1, i);
                    }
                }
                this.attrID = this.attrID.trim();
                this.value = this.value.trim();
                SearchFilter.this.consumeChars(i);
            }
            catch (Exception exception) {
                JNDIFrame.log.logCatching(exception);
                com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException isfe = new com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException(com.sap.engine.services.jndi.persistent.exceptions.InvalidSearchFilterException.CANNOT_PARSE_CHARACTER, new Object[]{new Integer(SearchFilter.this.pos), SearchFilter.this.filter}, exception);
                isfe.log();
                throw isfe;
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean substringMatch(String s, String s1) {
            if (s.equals(new Character('*').toString())) {
                return true;
            }
            if (s.indexOf(42) == -1) {
                return s.equalsIgnoreCase(s1);
            }
            i = 0;
            stringtokenizer = new StringTokenizer(s, "*", false);
            if (s.charAt(0) == '*' || s1.toString().toLowerCase().startsWith(stringtokenizer.nextToken().toLowerCase())) ** GOTO lbl14
            return false;
lbl-1000:
            // 1 sources

            {
                s2 = stringtokenizer.nextToken();
                i = s1.toLowerCase().indexOf(s2.toLowerCase(), i);
                if (i == -1) {
                    return false;
                }
                i += s2.length();
lbl14:
                // 2 sources

                ** while (stringtokenizer.hasMoreTokens())
            }
lbl15:
            // 1 sources

            return s.charAt(s.length() - 1) == '*' || i == s1.length();
        }

        AtomicFilter() {
        }
    }

    final class NotFilter
    implements StringFilter {
        private StringFilter filter = null;

        public boolean check(Attributes attributes) throws NamingException {
            return this.filter.check(attributes) ^ true;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            this.filter = SearchFilter.this.createNextFilter();
        }

        NotFilter() {
        }
    }

    final class CompoundFilter
    implements StringFilter {
        private ConcurrentArrayObject subFilters = new ConcurrentArrayObject();
        private boolean polarity = false;

        public boolean check(Attributes attributes) throws NamingException {
            int i = 0;
            while (i < this.subFilters.size()) {
                StringFilter stringfilter = (StringFilter)this.subFilters.elementAt(i);
                if (stringfilter.check(attributes) != this.polarity) {
                    return this.polarity ^ true;
                }
                ++i;
            }
            return this.polarity;
        }

        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            while (SearchFilter.this.getCurrentChar() != ')') {
                StringFilter stringfilter = SearchFilter.this.createNextFilter();
                this.subFilters.addElement(stringfilter);
                SearchFilter.this.skipWhiteSpace();
            }
        }

        CompoundFilter(boolean flag) {
            this.polarity = flag;
        }
    }
}

