/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import javax.naming.CompositeName;

public class Schema
extends CompositeName {
    private String schema = "corbaname";
    private String name = null;
    private String host = null;
    private String objName = null;
    private String objKey = null;
    private String proto = "";
    public boolean isCname = false;
    private int port;
    private int minor;
    private int major;
    int index = 0;
    int[] found;
    char delim = (char)58;
    static final long serialVersionUID = -8579756623211706227L;

    public Schema(String name) throws javax.naming.NamingException {
        super(name);
        this.name = name;
        this.parseSchema();
    }

    public void parseSchema() throws javax.naming.NamingException {
        block5: {
            this.init(this.name);
            int index = 0;
            try {
                if (this.found.length != 0 && this.name.substring(0, this.found[index]).equals("corbaname")) {
                    this.isCname = true;
                    this.proto = this.name.substring(this.found[index] + 1, this.found[index + 1]);
                    if (++index < this.found.length - 1) {
                        this.parseWithPort(this.name, index);
                    } else {
                        this.parseWithoutP(this.name, index);
                    }
                }
            }
            catch (Exception e) {
                if (!JNDIFrame.log.toLogInfoInLocation()) break block5;
                JNDIFrame.log.logInfo(JNDILogConstants.UNABLE_TO_PARSE_NAME);
                JNDIFrame.log.logCatching(e);
            }
        }
    }

    public void parseWithoutP(String s1, int index) throws javax.naming.NamingException {
        int next = 0;
        int next2 = 0;
        next = s1.indexOf("#");
        if (next != -1) {
            this.host = s1.substring(this.found[index] + 1, next);
            this.objKey = s1.substring(next);
        } else {
            next = s1.indexOf("/");
            this.host = s1.substring(this.found[index] + 1, next);
            this.objKey = s1.substring(next);
        }
        next2 = this.host.indexOf("@");
        if (next2 != -1) {
            this.major = Integer.parseInt(this.host.substring(0, 1));
            this.minor = Integer.parseInt(this.host.substring(2, 3));
            char maj = this.host.substring(0, 1).charAt(0);
            char min = this.host.substring(2, 3).charAt(0);
            if (!Character.isDigit(maj) || !Character.isDigit(min)) {
                if (JNDIFrame.log.toLogInfoInLocation()) {
                    JNDIFrame.log.logInfo(JNDILogConstants.VERSION_IS_NOT_A_DIGIT);
                }
                throw new NamingException(NamingException.VERSION_IS_NOT_A_DIGIT);
            }
            if (this.major > 1 || this.major < 0 || this.minor > 3 || this.minor < 0) {
                if (JNDIFrame.log.toLogInfoInLocation()) {
                    JNDIFrame.log.logInfo(JNDILogConstants.BAD_VERSION_NUMBER);
                }
                throw new NamingException(NamingException.BAD_VERSION_NUMBER);
            }
            this.host = this.host.substring(next2 + 1);
        }
        this.objName = this.objKey;
    }

    public void parseWithPort(String s1, int index) throws javax.naming.NamingException {
        this.host = s1.substring(this.found[index] + 1, this.found[index + 1]);
        int next = 0;
        next = this.host.indexOf("@");
        if (next != -1) {
            this.major = Integer.parseInt(this.host.substring(0, 1));
            this.minor = Integer.parseInt(this.host.substring(2, 3));
            char maj = this.host.substring(0, 1).charAt(0);
            char min = this.host.substring(2, 3).charAt(0);
            if (!Character.isDigit(maj) || !Character.isDigit(min)) {
                if (JNDIFrame.log.toLogInfoInLocation()) {
                    JNDIFrame.log.logInfo(JNDILogConstants.VERSION_IS_NOT_A_DIGIT);
                }
                throw new NamingException(NamingException.VERSION_IS_NOT_A_DIGIT);
            }
            if (this.major > 1 || this.major < 0 || this.minor > 3 || this.minor < 0) {
                if (JNDIFrame.log.toLogInfoInLocation()) {
                    JNDIFrame.log.logInfo(JNDILogConstants.BAD_VERSION_NUMBER);
                }
                throw new NamingException(NamingException.BAD_VERSION_NUMBER);
            }
            this.host = this.host.substring(next + 1);
        }
        int next2 = 0;
        next2 = s1.indexOf("#");
        if (next2 != -1) {
            this.port = Integer.parseInt(s1.substring(this.found[index + 1] + 1, next2));
        } else {
            next2 = s1.indexOf("/");
            this.port = Integer.parseInt(s1.substring(this.found[index + 1] + 1, next2));
        }
        this.objName = this.objKey = s1.substring(next2);
    }

    public void init(String s) {
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == this.delim) {
                ++count;
            }
            ++i;
        }
        this.found = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            if (s.charAt(i2) == this.delim) {
                this.found[count] = i2;
                ++count;
            }
            ++i2;
        }
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public String getObjKey() {
        return this.objKey;
    }

    public String getObjName() {
        return this.objName;
    }

    public String getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.proto;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }
}

