/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.implclient.LoginHelper;
import com.sap.engine.services.jndi.implclient.RemoteObjectReferenceFactory;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.OperationNotSupportedException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.NamingManager;

public class OffsetClientContext
extends ClientContext {
    static final long serialVersionUID = 3791215843613427260L;
    private String prefix;
    private String applicationName;
    private ClassLoader classLoader = null;
    private ClassLoader additionalLoader = null;
    private boolean cacheEnabled = true;
    private boolean runOnServer;
    private boolean usePrefix;
    private String root;

    public OffsetClientContext(Hashtable environment, ServerContextInface remoteContext, boolean runOnServer, RemoteObjectReferenceFactory refrenceFactory, String prefix, boolean usePrefix, LoginHelper loginCtx) throws javax.naming.NamingException {
        super(environment, remoteContext, runOnServer, refrenceFactory, loginCtx);
        this.runOnServer = runOnServer;
        this.usePrefix = usePrefix;
        this.cacheEnabled = !"off".equalsIgnoreCase((String)environment.get("cache"));
        int lindex = prefix.lastIndexOf(58);
        if (lindex != -1) {
            this.prefix = prefix.substring(0, lindex);
            this.applicationName = prefix.substring(lindex + 1);
            this.classLoader = JNDIFrame.getClassLoader(this.applicationName);
            this.applicationName = this.applicationName + ":";
        } else {
            this.prefix = prefix;
            this.classLoader = JNDIFrame.getClassLoader("service:naming");
            this.applicationName = "common:";
        }
        this.root = this.prefix;
        if (!usePrefix) {
            this.prefix = "";
        }
        try {
            Object temp = environment.get("SampleLoader");
            if (temp != null) {
                this.additionalLoader = (ClassLoader)temp;
            } else {
                temp = environment.get("SampleClass");
                if (temp != null) {
                    this.additionalLoader = temp.getClass().getClassLoader();
                }
            }
        }
        catch (ClassCastException e) {
            JNDIFrame.log.logCatching(e);
            this.additionalLoader = null;
        }
        this.fullNameInSpace = new CompositeName();
        String loaderName = "n/a";
        String parentName = "n/a";
        String contextClassLoader = "n/a";
        try {
            loaderName = ((ReferencedLoader)this.classLoader).getName();
            parentName = ((ReferencedLoader)this.classLoader).getParentName();
            contextClassLoader = Thread.currentThread().getContextClassLoader().toString();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (OutOfMemoryError o) {
            o.printStackTrace();
            JNDIFrame.log.logError(JNDILogConstants.OUT_OF_MEMORY_ERROR);
            JNDIFrame.log.logCatching(o);
            System.exit(666);
        }
        catch (Throwable t) {
            JNDIFrame.log.logCatching(t);
        }
        if (JNDIFrame.log.toLogPathInLocation()) {
            JNDIFrame.log.logPath(JNDILogConstants.OFFSET_CONTEXT_CREATED, new Object[]{this.applicationName, this.prefix, String.valueOf(usePrefix), this.classLoader, loaderName, parentName, contextClassLoader, String.valueOf(this.cacheEnabled)});
        }
    }

    public ClassLoader getApplicationClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getAdditionalClassLoader() {
        return this.additionalLoader;
    }

    public Object lookup(Name name) throws javax.naming.NamingException {
        Object obj;
        block17: {
            String originalName = name.toString();
            name = this.cleanName(name);
            Object cached = null;
            if (this.cacheEnabled && this.usePrefix) {
                try {
                    cached = ServerContextImpl.cache.lookupCache(this.applicationName + "/" + name.toString(), true);
                }
                catch (ThreadDeath td) {
                    JNDIFrame.log.logCatching(td);
                    throw td;
                }
                catch (OutOfMemoryError o) {
                    JNDIFrame.log.logCatching(o);
                    System.exit(666);
                }
                catch (Throwable e) {
                    JNDIFrame.log.logCatching(e);
                    NamingException ne = new NamingException(NamingException.CANNOT_LOOKUP, new Object[]{name}, e);
                    ne.log();
                }
            }
            if (cached != null) {
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.LOOKUP_FROM_CACHE, new Object[]{this.applicationName + "/" + name.toString()});
                }
                return cached;
            }
            obj = null;
            try {
                obj = super.lookup(name);
                if (obj instanceof ClientContext) {
                    String originalPrefix = name.toString();
                    ClientContext returnedContext = (ClientContext)obj;
                    if (this.applicationName != null && !"common:".equals(this.applicationName)) {
                        originalPrefix = originalPrefix + ":" + this.applicationName.substring(0, this.applicationName.length() - 1);
                    }
                    obj = this.usePrefix ? new OffsetClientContext(returnedContext.getEnvironment(), this.remoteContext, this.runOnServer, returnedContext.referenceFactory, originalPrefix, this.usePrefix, returnedContext.loginContext) : new OffsetClientContext(returnedContext.getEnvironment(), returnedContext.remoteContext, this.runOnServer, returnedContext.referenceFactory, originalPrefix, this.usePrefix, returnedContext.loginContext);
                    if (!this.usePrefix) {
                        ((OffsetClientContext)obj).fullNameInSpace = new CompositeName(returnedContext.getNameInNamespace());
                    } else {
                        ((OffsetClientContext)obj).root = this.root;
                    }
                    break block17;
                }
                if (obj instanceof Reference) {
                    try {
                        Thread thisThread = Thread.currentThread();
                        ClassLoader oldClassLoader = thisThread.getContextClassLoader();
                        ClassLoader newClassLoader = this.classLoader;
                        thisThread.setContextClassLoader(newClassLoader);
                        obj = NamingManager.getObjectInstance(obj, name, this, this.getEnvironment());
                        thisThread.setContextClassLoader(oldClassLoader);
                    }
                    catch (Exception e) {
                        NamingException ne = new NamingException(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name}, e);
                        ne.log();
                        throw ne;
                    }
                }
                if (this.cacheEnabled && this.usePrefix && obj != null && !(obj instanceof Reference)) {
                    ServerContextImpl.cache.addCache(this.applicationName + "/" + name.toString(), obj, true);
                }
            }
            catch (NameNotFoundException e) {
                obj = super.lookup(ClientContext.parse(originalName));
                if (!JNDIFrame.log.toLogPathInLocation()) break block17;
                JNDIFrame.log.logPath(JNDILogConstants.NOT_SPECIFIED_LOOKUP_FROM_ROOT, new Object[]{name, this.applicationName});
            }
        }
        return obj;
    }

    public Object lookup(String name) throws javax.naming.NamingException {
        return this.lookup(ClientContext.parse(name));
    }

    public void bind(String name, Object obj, Attributes attrs) throws javax.naming.NamingException {
        this.bind(ClientContext.parse(name), obj, attrs);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.bind(name, obj, attrs);
    }

    public void bind(String name, Object obj) throws javax.naming.NamingException {
        this.bind(ClientContext.parse(name), obj, null);
    }

    public void bind(Name name, Object obj) throws javax.naming.NamingException {
        this.bind(name, obj, null);
    }

    public void rebind(Name name, Object obj) throws javax.naming.NamingException {
        this.rebind(name, obj, null);
    }

    public void rebind(String name, Object obj) throws javax.naming.NamingException {
        this.rebind(ClientContext.parse(name), obj, null);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.rebind(name, obj, attrs);
        if (this.cacheEnabled && this.usePrefix) {
            ServerContextImpl.cache.removeClusterCache(this.applicationName + "/" + name.toString());
        }
    }

    public void rebind(String name, Object obj, Attributes attrs) throws javax.naming.NamingException {
        this.rebind(ClientContext.parse(name), obj, attrs);
    }

    public void unbind(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.unbind(name);
        if (this.cacheEnabled && this.usePrefix) {
            ServerContextImpl.cache.removeClusterCache(this.applicationName + "/" + name.toString());
        }
    }

    public void unbind(String name) throws javax.naming.NamingException {
        this.unbind(ClientContext.parse(name));
    }

    public void rename(Name oldname, Name newname) throws javax.naming.NamingException {
        oldname = this.cleanName(oldname);
        newname = this.cleanName(newname);
        super.rename(oldname, newname);
        if (this.cacheEnabled && this.usePrefix) {
            ServerContextImpl.cache.removeClusterCache(this.applicationName + "/" + oldname.toString());
        }
    }

    public void rename(String oldname, String newname) throws javax.naming.NamingException {
        this.rename(ClientContext.parse(oldname), ClientContext.parse(newname));
    }

    public NamingEnumeration list(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.list(name);
    }

    public NamingEnumeration list(String name) throws javax.naming.NamingException {
        return this.list(ClientContext.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws javax.naming.NamingException {
        return this.listBindings(ClientContext.parse(name));
    }

    public void destroySubcontext(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws javax.naming.NamingException {
        this.destroySubcontext(ClientContext.parse(name));
    }

    public Name cleanName(Name name) throws javax.naming.NamingException {
        String tempString;
        this.transformName(name);
        this.verifyName(name);
        String operation = "";
        if (name.size() != 0 && (tempString = name.get(0).trim()).startsWith("*")) {
            name.remove(0);
            operation = tempString + "/";
        }
        String sufix = name.toString();
        String slash = "/";
        if (this.prefix.trim().equals("") || sufix.equals("")) {
            slash = "";
        }
        name = new CompositeName(operation + this.prefix + slash + sufix);
        return name;
    }

    public DirContext createSubcontext(Name name, Attributes newattr) throws javax.naming.NamingException {
        name = this.cleanName(name);
        ClientContext returnedContext = (ClientContext)super.createSubcontext(name, newattr);
        String originalPrefix = name.toString();
        OffsetClientContext result = null;
        if (this.applicationName != null && !"common:".equals(this.applicationName)) {
            originalPrefix = originalPrefix + ":" + this.applicationName.substring(0, this.applicationName.length() - 1);
        }
        result = this.usePrefix ? new OffsetClientContext(returnedContext.getEnvironment(), this.remoteContext, this.runOnServer, returnedContext.referenceFactory, originalPrefix, this.usePrefix, returnedContext.loginContext) : new OffsetClientContext(returnedContext.getEnvironment(), returnedContext.remoteContext, this.runOnServer, returnedContext.referenceFactory, originalPrefix, this.usePrefix, returnedContext.loginContext);
        if (!this.usePrefix) {
            result.fullNameInSpace = new CompositeName(returnedContext.getNameInNamespace());
        } else {
            result.root = this.root;
        }
        return result;
    }

    public DirContext createSubcontext(String name, Attributes newattr) throws javax.naming.NamingException {
        return this.createSubcontext(ClientContext.parse(name), newattr);
    }

    public Context createSubcontext(Name name) throws javax.naming.NamingException {
        return this.createSubcontext(name, null);
    }

    public Context createSubcontext(String name) throws javax.naming.NamingException {
        return this.createSubcontext(ClientContext.parse(name), null);
    }

    public Object lookupLink(String name) throws javax.naming.NamingException {
        return this.lookup(ClientContext.parse(name));
    }

    public Object lookupLink(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return this.lookup(name);
    }

    public Attributes getAttributes(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.getAttributes(name);
    }

    public Attributes getAttributes(Name name, String[] attrIDs) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.getAttributes(name, attrIDs);
    }

    public Attributes getAttributes(String name) throws javax.naming.NamingException {
        return this.getAttributes(ClientContext.parse(name));
    }

    public Attributes getAttributes(String name, String[] attrIDs) throws javax.naming.NamingException {
        if (attrIDs == null) {
            return this.getAttributes(ClientContext.parse(name));
        }
        return this.getAttributes(ClientContext.parse(name), attrIDs);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws javax.naming.NamingException {
        name = this.cleanName(name);
        super.modifyAttributes(name, mods);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws javax.naming.NamingException {
        this.modifyAttributes(ClientContext.parse(name), mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws javax.naming.NamingException {
        this.modifyAttributes(ClientContext.parse(name), mods);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.search(name, filter, cons);
    }

    public DirContext getSchemaClassDefinition(Name name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchemaClassDefinition(String name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(Name name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(String name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public NameParser getNameParser(String name) throws javax.naming.NamingException {
        return this.getNameParser(ClientContext.parse(name));
    }

    public NameParser getNameParser(Name name) throws javax.naming.NamingException {
        name = this.cleanName(name);
        return super.getNameParser(name);
    }

    public String composeName(String name, String prefix) throws javax.naming.NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws javax.naming.NamingException {
        this.transformName(name);
        this.verifyName(name);
        return this.cleanName(prefix).addAll(name);
    }

    public Object addToEnvironment(String propName, Object propVal) throws javax.naming.NamingException {
        return super.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws javax.naming.NamingException {
        return super.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws javax.naming.NamingException {
        return super.getEnvironment();
    }

    public boolean targetMustExist() throws javax.naming.NamingException {
        return super.targetMustExist();
    }

    public void close() throws javax.naming.NamingException {
        super.close();
    }

    public String getNameInNamespace() throws javax.naming.NamingException {
        String name = "";
        if (this.usePrefix) {
            if (!this.root.equals(this.prefix)) {
                name = this.prefix.substring(this.root.length() + 1);
            }
        } else {
            name = super.getNameInNamespace();
        }
        return name;
    }

    public ClientContext getClient() {
        return this;
    }
}

