/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.gui;

import com.sap.engine.services.jndi.gui.ImageLoader;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class JNDITreeGrabberRenderer
extends JLabel
implements TreeCellRenderer {
    private static final short INFO = 0;
    private static final short OBJECT = 1;
    private static final short CONTEXT = 2;
    static final long serialVersionUID = -5093169134729810803L;

    public JNDITreeGrabberRenderer() {
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        switch (this.isContext(value)) {
            case 0: {
                this.setIcon(null);
                break;
            }
            case 2: {
                this.setIcon(ImageLoader.getIcon("big_blue"));
                break;
            }
            case 1: {
                this.setIcon(ImageLoader.getIcon("big_red"));
            }
        }
        this.setText(value != null ? value.toString() : "");
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    private short isContext(Object value) {
        if (value == null) {
            return 0;
        }
        if (((DefaultMutableTreeNode)value).getAllowsChildren()) {
            String name = (String)((DefaultMutableTreeNode)value).getUserObject();
            int index = name.indexOf("[Context]");
            if (index == -1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }
}

