/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.gui.ImageLoader;
import com.sap.engine.services.jndi.gui.JNDITreeGrabberContext;
import com.sap.engine.services.jndi.gui.JNDITreeGrabberPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public abstract class JNDIRuntimeView
extends JPanel
implements VisualRuntimeControl,
ActionListener,
ListSelectionListener,
TreeSelectionListener,
ChangeListener {
    protected JNDITreeGrabberPanel jndiBrowser = null;
    protected JButton refreshButton = new JButton();
    protected JButton exportButton = new JButton();
    protected JButton expandButton = new JButton();
    protected JButton collapseButton = new JButton();
    protected JButton[] browserButtons = new JButton[4];
    protected JTabbedPane tabbedPane = new JTabbedPane();
    static final long serialVersionUID = 428567510641346849L;

    public JNDIRuntimeView() {
        try {
            Dimension dim = new Dimension(24, 24);
            this.refreshButton.setPreferredSize(dim);
            this.refreshButton.setToolTipText("Refresh Tree");
            this.refreshButton.addActionListener(this);
            this.refreshButton.setIcon(ImageLoader.getIcon("reset"));
            this.browserButtons[0] = this.refreshButton;
            this.exportButton.setPreferredSize(dim);
            this.exportButton.setToolTipText("Export to File");
            this.exportButton.addActionListener(this);
            this.exportButton.setIcon(ImageLoader.getIcon("set"));
            this.browserButtons[1] = this.exportButton;
            this.expandButton.setPreferredSize(dim);
            this.expandButton.setToolTipText("Expand Tree");
            this.expandButton.addActionListener(this);
            this.expandButton.setIcon(ImageLoader.getIcon("expandtree"));
            this.browserButtons[2] = this.expandButton;
            this.collapseButton.setPreferredSize(dim);
            this.collapseButton.setToolTipText("Collapse Tree");
            this.collapseButton.addActionListener(this);
            this.collapseButton.setIcon(ImageLoader.getIcon("colapstree"));
            this.browserButtons[3] = this.collapseButton;
            JNDITreeGrabberContext jndiContext = new JNDITreeGrabberContext();
            this.jndiBrowser = new JNDITreeGrabberPanel(jndiContext);
            this.tabbedPane.setTabPlacement(3);
            this.tabbedPane.addTab("Browser", this.jndiBrowser);
            this.tabbedPane.addChangeListener(this);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.tabbedPane);
        }
        catch (Exception ex) {
            JNDIFrame.log.logCatching(ex);
        }
    }

    public abstract void stateChanged(ChangeEvent var1);

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract void setTaskManager(EditorViewManager var1);

    public abstract void freeResources();

    public abstract void setFrame(Frame var1);

    public abstract JButton[] getRuntimeButtons();

    public abstract JMenu getRuntimeMenu();

    public abstract JComponent getRuntimeControlComponent();

    public abstract void show(ManagementInterface var1);

    public abstract void setEnvironment(String var1, Object var2) throws UnsupportedEditorException;
}

