/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cosnaming;

import com.sap.engine.services.jndi.cosnaming.CosNamingContext;
import com.sap.engine.services.jndi.cosnaming.NamingContextImpl;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NamingEnumerationImpl
implements NamingEnumeration {
    private static final NoSuchElementException NO_MORE_ELEMENTS = new NoSuchElementException();
    private BindingIterator iterator;
    private BindingHolder holder;
    private boolean hasMore;
    private NamingContext context;
    private boolean bindings;

    NamingEnumerationImpl(BindingIterator i, NamingContext ctx, boolean binds) {
        this.iterator = i;
        this.holder = new BindingHolder();
        this.hasMore = true;
        this.bindings = binds;
        this.context = ctx;
    }

    public java.lang.Object next() throws NamingException {
        if (!this.hasMore) {
            this.close();
            throw NO_MORE_ELEMENTS;
        }
        try {
            this.hasMore = this.iterator.next_one(this.holder);
            Binding bind = this.holder.value;
            String bindingName = NamingContextImpl.toString(bind.binding_name[bind.binding_name.length - 1]);
            Object obj = null;
            try {
                obj = this.context.resolve(bind.binding_name);
            }
            catch (NotFound nf) {
                obj = null;
            }
            String className = obj == null ? "" : obj.getClass().getName();
            return this.bindings ? new javax.naming.Binding(bindingName, className, obj, true) : new NameClassPair(bindingName, className, true);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public boolean hasMore() throws NamingException {
        return this.hasMore;
    }

    public java.lang.Object nextElement() {
        java.lang.Object result = null;
        try {
            result = this.next();
        }
        catch (Exception e) {
            throw NO_MORE_ELEMENTS;
        }
        return result;
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public void close() throws NamingException {
        if (this.iterator != null) {
            this.iterator.destroy();
        }
        this.iterator = null;
        this.holder = null;
        this.context = null;
    }
}

