/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cosnaming;

import com.sap.engine.services.jndi.cosnaming.NamingContextImpl;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NamingContextExtImpl
extends NamingContextImpl
implements NamingContextExt {
    private static final char[] escapeExceptions = new char[]{';', '/', ':', '?', '@', '&', '=', '+', '$', ',', '-', '_', '.', '!', '~', '*', '\u0092', '(', ')'};
    String[] ids = new String[]{"IDL:omg.org/CosNaming/NamingContextExt:1.0", "IDL:omg.org/CosNaming/NamingContext:1.0"};
    static final long serialVersionUID = 3133912374574004838L;

    public NamingContextExtImpl() {
    }

    public NamingContextExtImpl(String root) {
        super(root);
    }

    public String[] _ids() {
        return this.ids;
    }

    public Object resolve_str(String sn) throws NotFound, CannotProceed, InvalidName {
        return super.resolve(this.to_name(sn));
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return NamingContextImpl.toNameComponent(sn);
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return NamingContextImpl.toString(n);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (addr == null || addr.length() == 0) {
            throw new InvalidAddress();
        }
        if (sn == null) {
            sn = "";
        }
        addr = NamingContextExtImpl.escapeURL(addr);
        sn = NamingContextExtImpl.escapeURL(sn);
        return "corbaname://" + addr + "#" + sn;
    }

    private static String escapeURL(String s) {
        StringBuffer sb = new StringBuffer();
        int size = s.length();
        int c = 0;
        while (c < size) {
            char ch = s.charAt(c);
            if (NamingContextExtImpl.isEscapable(ch)) {
                sb.append(NamingContextExtImpl.escape(ch));
            } else {
                sb.append(ch);
            }
            ++c;
        }
        return sb.toString();
    }

    private static boolean isEscapable(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        int c = 0;
        while (c < escapeExceptions.length) {
            if (ch == escapeExceptions[c]) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private static String escape(char ch) {
        String hex = "0123456789abcdef";
        int charAsInt = ch & 0xFF;
        return "%" + hex.charAt(charAsInt >> 4) + hex.charAt(charAsInt & 0xF);
    }
}

