/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cluster;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.GroupInfo;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.gui.AccessListObject;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.SecurityException;
import java.security.Guard;
import java.util.ArrayList;
import java.util.Iterator;

public class SecurityBase
implements Guard {
    public static boolean WITHOUT_SECURITY = true;
    private static final boolean DUMP_SECURITY = false;
    private static ApplicationContainerContext containerContext = null;
    private static String sid = null;
    private static SecurityBase sinfo = null;
    private static ThreadSystem threadSystem = null;
    private static SecurityContext securityContext;
    public static final String ID_JNDI_ALL_OPERATIONS_PERMISSION = "jndi_all_operations";
    public static final String ID_JNDI_GET_INITIAL_CONTEXT_PERMISSION = "jndi_get_initial_context";

    public SecurityBase(ApplicationServiceContext sc) throws JNDIException {
        this(false, null, null, null, sc);
    }

    public SecurityBase(boolean setFactory, JNDIPersistentRepository db, JNDIHandle rc, JNDIHandle cpoc, ApplicationServiceContext sc) throws JNDIException {
        containerContext = sc.getContainerContext();
        threadSystem = sc.getCoreContext().getThreadSystem();
        int ID = sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        sid = Integer.toString(ID);
        if (!WITHOUT_SECURITY) {
            securityContext = JNDIFrame.namingSecurityContext;
        }
        sinfo = this;
    }

    public static void setSecurityContext(SecurityContext securityContext) {
        SecurityBase.securityContext = securityContext;
    }

    public static synchronized boolean isOperationLegal(String permission) {
        if (WITHOUT_SECURITY) {
            return true;
        }
        try {
            ThreadContext threadContext = threadSystem.getThreadContext();
            if (threadContext == null) {
                return true;
            }
            SecurityContextObject securityContextObject = (SecurityContextObject)((Object)threadContext.getContextObject("security"));
            if (securityContextObject == null) {
                return true;
            }
            SecuritySession securitySession = securityContextObject.getSession();
            if (securitySession == null) {
                return true;
            }
            boolean result = securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(permission).isCallerInRole();
            return result;
        }
        catch (java.lang.SecurityException e) {
            JNDIFrame.log.logCatching(e);
            return false;
        }
    }

    public static synchronized void allowOperation(String userName, String permission, boolean isGroup) throws JNDIException {
        if (WITHOUT_SECURITY) {
            return;
        }
        try {
            SecurityRole securityRole = securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(permission);
            if (securityRole == null) {
                SecurityException se = new SecurityException(SecurityException.SUCH_PERMISSION_IS_NOT_DEFINED_IN_SERVER, new Object[]{permission});
                JNDIFrame.log.logThrowable(se);
                throw se;
            }
            GroupInfo groupInfo = null;
            UserInfo userInfo = null;
            try {
                if (isGroup) {
                    groupInfo = securityContext.getUserStoreContext().getActiveUserStore().getGroupContext().getGroupInfo(userName);
                } else {
                    userInfo = securityContext.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(userName);
                }
            }
            catch (java.lang.SecurityException e) {
                SecurityException se = null;
                JNDIFrame.log.logCatching(e);
                if (isGroup) {
                    se = new SecurityException(SecurityException.SUCH_GROUP_IS_NOT_DEFINED_IN_SERVER, new Object[]{userName}, e);
                    JNDIFrame.log.logThrowable(se);
                    throw se;
                }
                se = new SecurityException(SecurityException.SUCH_USER_IS_NOT_DEFINED_IN_SERVER, new Object[]{userName}, e);
                JNDIFrame.log.logThrowable(se);
                throw se;
            }
            if (isGroup) {
                securityRole.addGroup(userName);
            } else {
                securityRole.addUser(userName);
            }
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogWarningInLocation()) {
                JNDIFrame.log.logWarning(JNDIException.CAN_NOT_ALLOW_OPERATION, new Object[]{userName, permission});
                JNDIFrame.log.logCatching(e);
            }
            JNDIException jde = new JNDIException(JNDIException.CAN_NOT_ALLOW_OPERATION, new Object[]{userName, permission}, e);
            jde.log();
            throw jde;
        }
    }

    public static synchronized void denyOperation(String userName, String permission, boolean isGroup) throws JNDIException {
        if (WITHOUT_SECURITY) {
            return;
        }
        try {
            SecurityRole securityRole = securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(permission);
            if (securityRole == null) {
                SecurityException se = new SecurityException(SecurityException.SUCH_PERMISSION_IS_NOT_DEFINED_IN_SERVER, new Object[]{permission});
                JNDIFrame.log.logThrowable(se);
                throw se;
            }
            if (isGroup) {
                securityRole.removeGroup(userName);
            } else {
                securityRole.removeUser(userName);
            }
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogWarningInLocation()) {
                JNDIFrame.log.logWarning(JNDIException.CAN_NOT_DENY_OPERATION, new Object[]{userName, permission});
                JNDIFrame.log.logCatching(e);
            }
            JNDIException jde = new JNDIException(JNDIException.CAN_NOT_DENY_OPERATION, new Object[]{userName, permission}, e);
            jde.log();
            throw jde;
        }
    }

    public static synchronized Object getPermissions() throws JNDIException {
        return SecurityBase.getPrincipals();
    }

    public static synchronized Object getPermissions(String permissionName) throws JNDIException {
        return SecurityBase.getPrincipals(permissionName);
    }

    public static synchronized AccessListObject[][] getPrincipals() throws JNDIException {
        AccessListObject[][] result = new AccessListObject[][]{SecurityBase.getPrincipals(ID_JNDI_ALL_OPERATIONS_PERMISSION), SecurityBase.getPrincipals(ID_JNDI_GET_INITIAL_CONTEXT_PERMISSION)};
        return result;
    }

    public static synchronized AccessListObject[] getPrincipals(String permission) throws JNDIException {
        if (WITHOUT_SECURITY) {
            return new AccessListObject[0];
        }
        try {
            SecurityRole role = securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(permission);
            if (role == null) {
                SecurityException se = new SecurityException(SecurityException.SUCH_PERMISSION_IS_NOT_DEFINED_IN_SERVER, new Object[]{permission});
                JNDIFrame.log.logThrowable(se);
                throw se;
            }
            String[] groups = role.getGroups();
            String[] users = role.getUsers();
            AccessListObject[] result = new AccessListObject[groups.length + users.length];
            int index = 0;
            int i = 0;
            while (i < groups.length) {
                result[index++] = new AccessListObject(groups[i], false);
                ++i;
            }
            int i2 = 0;
            while (i2 < users.length) {
                result[index++] = new AccessListObject(users[i2], true);
                ++i2;
            }
            return result;
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDIException.CAN_NOT_GET_PRINCIPLES_FOR_PERMISSION, new Object[]{permission});
                JNDIFrame.log.logThrowable(e);
            }
            JNDIException jde = new JNDIException(JNDIException.CAN_NOT_GET_PRINCIPLES_FOR_PERMISSION, new Object[]{permission});
            jde.log();
            throw jde;
        }
    }

    public static String getPermissionName(int index) {
        if (index == 0) {
            return ID_JNDI_ALL_OPERATIONS_PERMISSION;
        }
        if (index == 1) {
            return ID_JNDI_GET_INITIAL_CONTEXT_PERMISSION;
        }
        return null;
    }

    public static SecurityBase getServerInfo() {
        return sinfo;
    }

    public static String getServerIDString() {
        return sid;
    }

    public static boolean isActive() {
        return sid != null;
    }

    public static void setServerIDString(String s) {
        sid = s;
    }

    public static void close() {
        sid = null;
        sinfo = null;
    }

    public void checkGuard(Object object) throws java.lang.SecurityException {
        if (!(object instanceof SecurityBase)) {
            SecurityException se = new SecurityException(SecurityException.CAN_NOT_USE_SECURITY_RESOURCES);
            JNDIFrame.log.logThrowable(se);
            throw se;
        }
    }

    private static void dump(String s) {
        System.out.println("SECURITY_DUMP: " + s);
    }

    private static void dumpWrite(String s) {
        System.out.print(s);
    }

    public static Object getUsersTree() {
        try {
            GroupContext groupContext = securityContext.getUserStoreContext().getActiveUserStore().getGroupContext();
            UserNode rootNode = new UserNode("", 0, false);
            ArrayList<UserNode> list = new ArrayList<UserNode>();
            Iterator i = groupContext.listRootGroups();
            while (i.hasNext()) {
                String name = (String)i.next();
                UserNode childNode = new UserNode(name, 0, false);
                childNode.setParents(new UserNode[]{rootNode});
                list.add(childNode);
                SecurityBase.addChild(groupContext, groupContext.getGroupInfo(name).getName(), childNode);
            }
            Iterator childIterator = securityContext.getUserStoreContext().getActiveUserStore().getUserContext().listRootUsers();
            while (childIterator.hasNext()) {
                String name = (String)childIterator.next();
                UserNode childNode = new UserNode(name, 0, true);
                childNode.setParents(new UserNode[]{rootNode});
                list.add(childNode);
            }
            UserNode[] children = new UserNode[list.size()];
            int n = 0;
            while (n < children.length) {
                children[n] = (UserNode)list.get(n);
                ++n;
            }
            rootNode.setChildren(children);
            return rootNode;
        }
        catch (Throwable t) {
            JNDIFrame.log.logCatching(t);
            return null;
        }
    }

    private static void addChild(GroupContext groupContext, String parent, UserNode node) {
        Iterator childIterator = null;
        UserNode childNode = null;
        String name = null;
        ArrayList<UserNode> list = new ArrayList<UserNode>();
        childIterator = groupContext.getChildGroups(parent);
        while (childIterator.hasNext()) {
            name = (String)childIterator.next();
            childNode = new UserNode(name, 0, false);
            childNode.setParents(new UserNode[]{node});
            list.add(childNode);
            SecurityBase.addChild(groupContext, groupContext.getGroupInfo(name).getName(), childNode);
        }
        childIterator = groupContext.getUsersOfGroup(parent);
        while (childIterator.hasNext()) {
            name = (String)childIterator.next();
            childNode = new UserNode(name, 0, true);
            childNode.setParents(new UserNode[]{node});
            list.add(childNode);
        }
        UserNode[] children = new UserNode[list.size()];
        int i = 0;
        while (i < children.length) {
            children[i] = (UserNode)list.get(i);
            ++i;
        }
        node.setChildren(children);
    }
}

