/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.services.jndi.cache.CacheQueue;
import com.sap.engine.services.jndi.cache.CacheQueueItem;

public class CacheQueueMRUSingleVector
implements CacheQueue {
    protected static final int MIN_SIZE_DEFAULT = 10;
    protected static final int MAX_SIZE_DEFAULT = 100;
    protected int maxSize;
    protected int minSize;
    protected int size;
    protected ConcurrentArrayObject vector;

    public CacheQueueMRUSingleVector() {
        this(10, 100);
    }

    public CacheQueueMRUSingleVector(int maxSize) {
        this(10, maxSize);
    }

    public CacheQueueMRUSingleVector(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = 0;
        this.vector = new ConcurrentArrayObject(maxSize, 0);
    }

    public void update(CacheQueueItem node) {
        CacheQueueItem cacheQueueItem = node;
        synchronized (cacheQueueItem) {
            ++node.accessFreq;
            node.preCalcPriority();
            int index = this.vector.indexOf(node);
            ConcurrentArrayObject concurrentArrayObject = this.vector;
            synchronized (concurrentArrayObject) {
                if (index != 0 && ((CacheQueueItem)this.vector.get((int)(index - 1))).accessFreq < node.accessFreq) {
                    CacheQueueItem temp = (CacheQueueItem)this.vector.get(index - 1);
                    this.vector.setElementAt(node, index - 1);
                    this.vector.setElementAt(temp, index);
                }
            }
        }
    }

    public synchronized CacheQueueItem add(CacheQueueItem node) {
        CacheQueueItem removed = null;
        if (this.size < this.maxSize) {
            ++this.size;
            this.vector.add(node);
            return null;
        }
        removed = (CacheQueueItem)this.vector.elementAt(this.maxSize - 1);
        this.vector.setElementAt(node, this.maxSize - 1);
        return removed;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public synchronized CacheQueueItem remove(CacheQueueItem node) {
        CacheQueueItem snode = node;
        --this.size;
        this.vector.remove(node);
        return snode;
    }

    public synchronized CacheQueueItem removeLast() {
        CacheQueueItem node = (CacheQueueItem)this.vector.elementAt(this.size);
        this.vector.removeElementAt(this.size);
        return node;
    }

    public synchronized void print() {
        System.out.print("QUEUE ");
        System.out.print("(size:" + this.size + ")");
        if (this.size != 0) {
            System.out.print("{ f " + ((CacheQueueItem)this.vector.elementAt((int)0)).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)0)).accessFreq + " } ");
            int i = 1;
            while (i < this.vector.size() - 1) {
                if (this.size != 0) {
                    System.out.print("{ m " + ((CacheQueueItem)this.vector.elementAt((int)i)).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)i)).accessFreq + " } ");
                }
                ++i;
            }
            System.out.println("{ l " + ((CacheQueueItem)this.vector.elementAt((int)(this.vector.size() - 1))).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)(this.vector.size() - 1))).accessFreq + " } ");
        } else {
            System.out.println("Queue empty.");
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getSize() {
        return this.size;
    }
}

