/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.services.jndi.cache.CacheQueue;
import com.sap.engine.services.jndi.cache.CacheQueueItem;

public class CacheQueueMRUSingle
implements CacheQueue {
    protected static final int MIN_SIZE_DEFAULT = 10;
    protected static final int MAX_SIZE_DEFAULT = 100;
    protected int maxSize;
    protected int minSize;
    protected int size;
    protected CacheQueueItem first;
    protected CacheQueueItem last;

    public CacheQueueMRUSingle() {
        this(10, 100);
    }

    public CacheQueueMRUSingle(int maxSize) {
        this(10, maxSize);
    }

    public CacheQueueMRUSingle(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    public void update(CacheQueueItem node) {
        CacheQueueItem cacheQueueItem = node;
        synchronized (cacheQueueItem) {
            ++node.accessFreq;
            node.preCalcPriority();
            if (node != this.first && node.prev != null) {
                CacheQueueItem cacheQueueItem2 = node.prev;
                synchronized (cacheQueueItem2) {
                    CacheQueueItem cacheQueueItem3 = this.last;
                    synchronized (cacheQueueItem3) {
                        CacheQueueItem cacheQueueItem4 = this.last.prev;
                        synchronized (cacheQueueItem4) {
                            CacheQueueItem cacheQueueItem5 = this.first;
                            synchronized (cacheQueueItem5) {
                                CacheQueueItem cacheQueueItem6 = node.next;
                                synchronized (cacheQueueItem6) {
                                    if (node.accessFreq > node.prev.accessFreq) {
                                        if (node == this.last) {
                                            this.first.prev = this.last.prev;
                                            this.last.next = this.last.prev;
                                            this.last.prev = this.last.next.prev;
                                            this.last.prev.next = this.last;
                                            this.last.next.prev = this.last;
                                            this.last.next.next = this.first;
                                            this.last = this.last.next;
                                        } else {
                                            CacheQueueItem tobe;
                                            node.next.prev = tobe = node.prev;
                                            tobe.prev.next = node;
                                            tobe.next = node.next;
                                            node.prev = tobe.prev;
                                            tobe.prev = node;
                                            node.next = tobe;
                                            if (tobe == this.first) {
                                                this.first = node;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public CacheQueueItem add(CacheQueueItem node) {
        CacheQueueItem removed = null;
        if (this.size < this.maxSize) {
            ++this.size;
            if (this.first == null) {
                node.prev = node;
                node.next = node;
                this.first = node;
                this.last = node;
            } else {
                node.next = this.first;
                node.prev = this.last;
                this.last.next = node;
                this.first.prev = node;
                this.last = node;
            }
            return null;
        }
        node.prev = this.last.prev;
        node.next = this.first;
        this.last.prev.next = node;
        this.first.prev = node;
        removed = this.last;
        this.last = node;
        return removed;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public CacheQueueItem remove(CacheQueueItem node) {
        CacheQueueItem snode = node;
        --this.size;
        if (this.size > 0) {
            if (this.first == node) {
                this.last.next = this.first = node.next;
                node.prev.next = node.next;
                node.next.prev = node.prev;
            } else if (this.last == node) {
                this.first.prev = this.last = node.prev;
                node.prev.next = node.next;
                node.next.prev = node.prev;
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            node.next = null;
            node.prev = null;
        } else {
            this.first = null;
            this.last = null;
        }
        return snode;
    }

    public CacheQueueItem removeLast() {
        return this.remove(this.last);
    }

    public void print() {
        System.out.print("QUEUE ");
        System.out.print("(size:" + this.size + ")");
        if (this.first != null) {
            System.out.print("{ f " + this.first.name + " acc: " + this.first.accessFreq + " } ");
            CacheQueueItem temp = this.first.next;
            while (temp != this.last) {
                System.out.print("{ m " + temp.name + " acc: " + temp.accessFreq + " } ");
                temp = temp.next;
            }
            System.out.println("{ l " + this.last.name + " acc: " + this.last.accessFreq + " } ");
        } else {
            System.out.println("Queue empty.");
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getSize() {
        return this.size;
    }
}

