/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.services.jndi.cache.CacheQueue;
import com.sap.engine.services.jndi.cache.CacheQueueItem;

public class CacheQueueLRUVector
implements CacheQueue {
    protected static final int MIN_SIZE_DEFAULT = 10;
    protected static final int MAX_SIZE_DEFAULT = 100;
    protected int maxSize;
    protected int minSize;
    protected int size;
    protected ConcurrentArrayObject vector;

    public CacheQueueLRUVector() {
        this(10, 100);
    }

    public CacheQueueLRUVector(int maxSize) {
        this(10, maxSize);
    }

    public CacheQueueLRUVector(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = 0;
        this.vector = new ConcurrentArrayObject(maxSize, 0);
    }

    public synchronized void update(CacheQueueItem node) {
        ++node.accessFreq;
        node.preCalcPriority();
        this.vector.remove(node);
        this.vector.insertElementAt(node, 0);
    }

    public synchronized CacheQueueItem add(CacheQueueItem node) {
        CacheQueueItem removed = null;
        if (this.size < this.maxSize) {
            ++this.size;
            this.vector.insertElementAt(node, 0);
        } else {
            removed = (CacheQueueItem)this.vector.removeAt(this.maxSize - 1);
            this.vector.insertElementAt(node, 0);
        }
        return removed;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public synchronized CacheQueueItem remove(CacheQueueItem node) {
        CacheQueueItem snode = node;
        --this.size;
        if (this.size > 0) {
            this.vector.remove(node);
        } else {
            this.vector.remove(node);
        }
        return snode;
    }

    public synchronized CacheQueueItem removeLast() {
        CacheQueueItem node = (CacheQueueItem)this.vector.elementAt(this.size);
        this.vector.removeElementAt(this.size);
        return node;
    }

    public void print() {
        System.out.print("QUEUE ");
        System.out.print("(size:" + this.size + ")");
        if (this.size != 0) {
            System.out.print("{ f " + ((CacheQueueItem)this.vector.elementAt((int)0)).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)0)).accessFreq + " } ");
            int i = 1;
            while (i < this.vector.size() - 1) {
                if (this.size != 0) {
                    System.out.print("{ m " + ((CacheQueueItem)this.vector.elementAt((int)i)).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)i)).accessFreq + " } ");
                }
                ++i;
            }
            System.out.println("{ l " + ((CacheQueueItem)this.vector.elementAt((int)(this.vector.size() - 1))).name + " acc: " + ((CacheQueueItem)this.vector.elementAt((int)(this.vector.size() - 1))).accessFreq + " } ");
        } else {
            System.out.println("Queue empty.");
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getSize() {
        return this.size;
    }
}

