/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.services.jndi.cache.CacheQueue;
import com.sap.engine.services.jndi.cache.CacheQueueItem;
import com.sap.engine.services.jndi.cache.CacheQueueLRU;
import com.sap.engine.services.jndi.cache.CacheQueueMRUSingle;

public class CacheQueueCombined
implements CacheQueue {
    private static final int MIN_SIZE_DEFAULT = 10;
    private static final int MAX_SIZE_DEFAULT = 100;
    private static final int REPLACEABLE_DEFAULT = 30;
    private int maxSize;
    private int minSize;
    private int replSize;
    private int size;
    private CacheQueueItem first;
    private CacheQueueItem last;
    protected CacheQueueLRU cacheL;
    protected CacheQueueMRUSingle cacheM;

    public CacheQueueCombined() {
        this(10, 100, 30);
    }

    public CacheQueueCombined(int maxSize) {
        this(10, maxSize, 30);
    }

    public CacheQueueCombined(int minSize, int maxSize) {
        this(minSize, maxSize, 30);
    }

    public CacheQueueCombined(int minSize, int maxSize, int replSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.replSize = replSize;
        this.size = 0;
        this.first = null;
        this.last = null;
        System.out.println("MRU cache: " + (maxSize - replSize));
        System.out.println("Replacable cache: " + replSize);
        this.cacheM = new CacheQueueMRUSingle(minSize, maxSize - replSize);
        this.cacheL = new CacheQueueLRU(minSize, replSize);
    }

    public void update(CacheQueueItem node) {
        if (node.inReplaceable) {
            if (node == this.cacheL.first && node.accessFreq >= this.cacheM.first.accessFreq) {
                this.cacheL.remove(node);
                node.inReplaceable = false;
                CacheQueueItem temp = this.cacheM.add(node);
                this.cacheM.update(node);
                this.cacheL.add(temp);
                temp.inReplaceable = true;
            } else {
                this.cacheL.update(node);
            }
        } else {
            this.cacheM.update(node);
        }
    }

    public CacheQueueItem add(CacheQueueItem node) {
        CacheQueueItem removed = null;
        if (this.cacheM.isFull()) {
            removed = this.cacheL.add(node);
            node.inReplaceable = true;
        } else {
            this.cacheM.add(node);
            node.inReplaceable = false;
        }
        return removed;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public CacheQueueItem remove(CacheQueueItem node) {
        CacheQueueItem snode = node;
        if (node.inReplaceable) {
            if (this.cacheL.size > 0) {
                snode = this.cacheL.remove(node);
            }
        } else {
            snode = this.cacheM.remove(node);
            if (this.cacheL.size > 0) {
                CacheQueueItem temp = this.cacheL.remove(this.cacheL.first);
                this.cacheM.add(temp);
                temp.inReplaceable = false;
            }
        }
        return snode;
    }

    public CacheQueueItem removeLast() {
        if (this.cacheL.size != 0) {
            return this.cacheL.removeLast();
        }
        return this.cacheM.removeLast();
    }

    public void print() {
        System.out.println("*");
        System.out.print("* MRU prior  Cache: ");
        this.cacheM.print();
        System.out.print("* Replacable Cache: ");
        this.cacheL.print();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getSize() {
        return this.size;
    }
}

