/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.jndi.cache.ByteArrItem;
import com.sap.engine.services.jndi.cache.CacheQueue;
import com.sap.engine.services.jndi.cache.CacheQueueItem;
import com.sap.engine.services.jndi.cache.CacheQueueLRU;
import com.sap.engine.services.jndi.cache.HName;
import com.sap.engine.services.jndi.cache.HandleItem;
import com.sap.engine.services.jndi.cache.ObjectItem;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.pool.ByteArrItemPool;
import com.sap.engine.services.jndi.pool.HandleItemPool;
import com.sap.engine.services.jndi.pool.ObjectItemPool;
import java.util.Enumeration;

public class CacheManager {
    private ConcurrentHashMapObjectObject chash = new ConcurrentHashMapObjectObject();
    private CacheQueue asObject;
    private CacheQueue asByteArr;
    private CacheQueue asHandle;
    private static ObjectItemPool objItemPool = new ObjectItemPool(10, 2);
    private static HandleItemPool hanItemPool = new HandleItemPool(10, 2);
    private static ByteArrItemPool barItemPool = new ByteArrItemPool(10, 2);

    public CacheManager(ConcurrentHashMapObjectObject properties) {
        this(properties, new CacheQueueLRU(), new CacheQueueLRU(), new CacheQueueLRU());
    }

    public CacheManager(ConcurrentHashMapObjectObject properties, int min, int max) {
        this(properties, new CacheQueueLRU(min, max), new CacheQueueLRU(min, max), new CacheQueueLRU(min, max));
    }

    public CacheManager(ConcurrentHashMapObjectObject properties, CacheQueue asObject, CacheQueue asByteArr, CacheQueue asHandle) {
        this.asObject = asObject;
        this.asByteArr = asByteArr;
        this.asHandle = asHandle;
    }

    public synchronized CacheQueueItem lookupCache(HName name) {
        CacheQueueItem cItem = (CacheQueueItem)this.chash.get(name);
        if (cItem != null) {
            switch (cItem.cacheType) {
                case 1: {
                    this.asObject.update(cItem);
                    return cItem;
                }
                case 2: {
                    this.asByteArr.update(cItem);
                    return cItem;
                }
                case 3: {
                    this.asHandle.update(cItem);
                    return cItem;
                }
            }
            return null;
        }
        return null;
    }

    public synchronized void addCache(HName name, Object object, int accessSpeed) {
        if (this.chash.containsKey(name)) {
            return;
        }
        ObjectItem oi = objItemPool.getObject();
        oi.reuse(name, object);
        oi.cacheType = 1;
        this.chash.put(name, oi);
        CacheQueueItem c = this.asObject.add(oi);
        if (c != null) {
            this.chash.remove(c.name);
            objItemPool.releaseObject((ObjectItem)c);
        }
    }

    public void addCache(HName name, byte[] object, int accessSpeed) {
        HName hName = name;
        synchronized (hName) {
            if (this.chash.containsKey(name)) {
                return;
            }
            ByteArrItem bi = barItemPool.getObject();
            bi.reuse(name, object);
            bi.cacheType = (short)2;
            CacheQueue cacheQueue = this.asByteArr;
            synchronized (cacheQueue) {
                this.chash.put(name, bi);
                CacheQueueItem c = this.asByteArr.add(bi);
                if (c != null) {
                    this.chash.remove(c.name);
                    barItemPool.releaseObject((ByteArrItem)c);
                }
            }
        }
    }

    public void addCache(HName name, JNDIHandle object, int accessSpeed) {
        HName hName = name;
        synchronized (hName) {
            if (this.chash.containsKey(name)) {
                return;
            }
            HandleItem hi = hanItemPool.getObject();
            hi.data = object;
            hi.cacheType = (short)3;
            hi.name = name;
            CacheQueue cacheQueue = this.asHandle;
            synchronized (cacheQueue) {
                this.chash.put(name, hi);
                CacheQueueItem c = this.asHandle.add(hi);
                if (c != null) {
                    this.chash.remove(c.name);
                    hanItemPool.releaseObject((HandleItem)c);
                }
            }
        }
    }

    public synchronized void removeCache(HName name) {
        CacheQueueItem cItem = (CacheQueueItem)this.chash.remove(name);
        if (cItem != null) {
            switch (cItem.cacheType) {
                case 1: {
                    this.asObject.remove(cItem);
                    objItemPool.releaseObject((ObjectItem)cItem);
                    break;
                }
                case 2: {
                    CacheQueue cacheQueue = this.asByteArr;
                    synchronized (cacheQueue) {
                        this.asByteArr.remove(cItem);
                        barItemPool.releaseObject((ByteArrItem)cItem);
                        break;
                    }
                }
                case 3: {
                    CacheQueue cacheQueue = this.asHandle;
                    synchronized (cacheQueue) {
                        this.asHandle.remove(cItem);
                        hanItemPool.releaseObject((HandleItem)cItem);
                        break;
                    }
                }
            }
        }
    }

    public void printCaches() {
        this.asHandle.print();
    }

    public void forceShrink() {
        CacheQueue cacheQueue = this.asObject;
        synchronized (cacheQueue) {
            while (this.asObject.getSize() > this.asObject.getMinSize()) {
                objItemPool.releaseObject((ObjectItem)this.asObject.removeLast());
            }
            objItemPool.forceShrink();
        }
        CacheQueue cacheQueue2 = this.asHandle;
        synchronized (cacheQueue2) {
            while (this.asHandle.getSize() > this.asHandle.getMinSize()) {
                hanItemPool.releaseObject((HandleItem)this.asHandle.removeLast());
            }
            hanItemPool.forceShrink();
        }
        CacheQueue cacheQueue3 = this.asByteArr;
        synchronized (cacheQueue3) {
            while (this.asByteArr.getSize() > this.asByteArr.getMinSize()) {
                barItemPool.releaseObject((ByteArrItem)this.asByteArr.removeLast());
            }
            barItemPool.forceShrink();
        }
    }

    public void printCacheHash() {
        System.out.println("******* Cache Hashtable ****************");
        Enumeration e = this.chash.keys();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
    }
}

