/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cache.Cache;
import com.sap.engine.services.jndi.cache.CacheCommunicator;
import java.util.Enumeration;

public class CacheHashtableImpl
implements Cache {
    private static CacheCommunicator cacheCommunicator;
    private static ConcurrentHashMapObjectObject hashtable;
    private static ConcurrentHashMapObjectObject referencableCache;
    private static int cacheMemory;
    private static final int CACHE_LIMIT = 0x400000;

    public CacheHashtableImpl(CacheCommunicator cacheCommunicator) {
        CacheHashtableImpl.cacheCommunicator = cacheCommunicator;
        cacheCommunicator.setCache(this);
    }

    public synchronized void addCache(String name, Object data, boolean referencable) {
        byte[] byteArray;
        if (data instanceof byte[] && (byteArray = (byte[])data).length < 0x400000) {
            if (cacheMemory + byteArray.length > 0x400000) {
                referencableCache.clear();
                hashtable.clear();
                cacheMemory = 0;
            }
            cacheMemory += byteArray.length;
        }
        if (referencable) {
            referencableCache.put(name, data);
        } else {
            hashtable.put(name, data);
        }
    }

    public synchronized Object lookupCache(String name, boolean referencable) {
        if (referencable) {
            return referencableCache.get(name);
        }
        return hashtable.get(name);
    }

    public void removeClusterCache(String name) {
        this.removeLocalCache(name);
        cacheCommunicator.notifyCluster(name);
    }

    public synchronized void removeLocalCache(String name) {
        Object data = hashtable.remove(name);
        if (data instanceof byte[]) {
            byte[] byteArray = (byte[])data;
            cacheMemory -= byteArray.length;
        }
        referencableCache.remove(name);
        try {
            String appCacheName = null;
            Enumeration keys = referencableCache.keys();
            while (keys.hasMoreElements()) {
                appCacheName = (String)keys.nextElement();
                if (!appCacheName.endsWith(name)) continue;
                referencableCache.remove(appCacheName);
            }
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
        }
    }

    public void emptyReferencableCache() {
        referencableCache.clear();
        hashtable.clear();
        cacheMemory = 0;
    }

    public int getByteArrayCacheSize() {
        return (int)((float)cacheMemory / 1024.0f + 0.49f);
    }

    public void releaseSession(String session) {
    }

    public void printCache() {
        System.out.println("Cache: ");
        System.out.println("---------------------------------------------");
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
        System.out.println("---------------------------------------------");
    }

    static {
        hashtable = new ConcurrentHashMapObjectObject();
        referencableCache = new ConcurrentHashMapObjectObject();
        cacheMemory = 0;
    }
}

