/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIProxy;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.localization.LocalizableTextFormatter;
import javax.naming.NamingException;

public abstract class NamingManager {
    public static final String persistentNaming = "com.sap.engine.services.jndi.JNDIManager";
    public static NamingManager manager;

    public static NamingManager getNamingManager() throws NoClassDefFoundError {
        if (manager == null) {
            String loadClassName = null;
            loadClassName = persistentNaming;
            try {
                Class<?> implClass = Class.forName(loadClassName);
                manager = (NamingManager)implClass.newInstance();
            }
            catch (Exception exc) {
                if (JNDIFrame.log.toLogErrorInLocation()) {
                    JNDIFrame.log.logError(JNDILogConstants.CLASS_NOT_FOUND_IN_GETTING_NAMING_MANAGER, new Object[]{loadClassName});
                    JNDIFrame.log.logCatching(exc);
                }
                LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), JNDILogConstants.CLASS_NOT_FOUND_IN_GETTING_NAMING_MANAGER, new Object[]{loadClassName});
                throw new NoClassDefFoundError(formater.toString());
            }
        }
        return manager;
    }

    public abstract JNDIProxy start() throws NamingException;

    public abstract JNDIProxy getProxy() throws NamingException;

    public abstract void stop() throws NamingException;
}

