/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIProxy;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.implclient.LoginHelper;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.persistent.exceptions.SecurityException;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.NoPermissionException;
import javax.rmi.PortableRemoteObject;

public class JNDIProxyImpl
extends PortableRemoteObject
implements JNDIProxy {
    protected static JNDIPersistentRepository db = null;
    protected static JNDIHandle rootObject;
    protected static JNDIHandle jndiRootContainer;

    public JNDIProxyImpl(JNDIPersistentRepository db, JNDIHandle rootObject, JNDIHandle jndiRootContainer) throws RemoteException {
        this(db, rootObject, jndiRootContainer, true);
    }

    public JNDIProxyImpl(JNDIPersistentRepository db, JNDIHandle rootObject, JNDIHandle jndiRootContainer, boolean remote) throws RemoteException {
        JNDIProxyImpl.db = db;
        JNDIProxyImpl.rootObject = rootObject;
        JNDIProxyImpl.jndiRootContainer = jndiRootContainer;
    }

    public ServerContextInface getNewServerContext() {
        return this.getNewServerContext(true, true);
    }

    private ServerContextInface getNewServerContext(boolean remote, boolean onlyLookUpOperation, boolean redirectable) {
        try {
            if (redirectable) {
                return new ServerContextRedirectableImpl(db.getNewConnection(), rootObject, jndiRootContainer, remote, onlyLookUpOperation);
            }
            return new ServerContextImpl(db.getNewConnection(), rootObject, jndiRootContainer, remote, onlyLookUpOperation);
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(RuntimeExceptionConstants.ERROR_OBTAINING_CONNECTION_TO_JNDI);
                JNDIFrame.log.logCatching(e);
            }
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.ERROR_OBTAINING_CONNECTION_TO_JNDI), (Throwable)e);
            bre.log();
            throw bre;
        }
    }

    public ServerContextInface getNewServerContext(boolean remote, boolean domain) {
        return this.checkPermissions(remote, domain, true);
    }

    private ServerContextInface checkPermissions(boolean remote, boolean domain, boolean redirectable) {
        if (!remote) {
            try {
                return new ServerContextImpl(db.getNewConnection(), rootObject, jndiRootContainer, remote, false);
            }
            catch (Exception e) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(RuntimeExceptionConstants.ERROR_OBTAINING_CONNECTION_TO_JNDI);
                    JNDIFrame.log.logCatching(e);
                }
                BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.ERROR_OBTAINING_CONNECTION_TO_JNDI), (Throwable)e);
                bre.log();
                throw bre;
            }
        }
        boolean onlyLookupAllowed = false;
        try {
            if (!SecurityBase.WITHOUT_SECURITY) {
                if (SecurityBase.isOperationLegal("jndi_get_initial_context")) {
                    if (!SecurityBase.isOperationLegal("jndi_all_operations")) {
                        onlyLookupAllowed = true;
                    }
                } else {
                    SecurityException se = new SecurityException(SecurityException.NOT_ALLOWED_TO_GET_INITIAL_CONTEXT);
                    JNDIFrame.log.logThrowable(se);
                    throw se;
                }
            }
            return this.getNewServerContext(remote, onlyLookupAllowed, redirectable);
        }
        catch (RuntimeException re) {
            JNDIFrame.log.logCatching(re);
            throw re;
        }
    }

    public ServerContextInface getNewServerContext(boolean remote) {
        return this.getNewServerContext(remote, false);
    }

    public ServerContextInface getNewServerContext(boolean remote, String user, String pass, boolean beaLoggedIn) {
        if (user != null && pass != null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.security.principal", user);
            env.put("java.naming.security.credentials", pass);
            LoginHelper loginContext = new LoginHelper();
            try {
                loginContext.serverSideLogin(env);
            }
            catch (NoPermissionException npe) {
                SecurityException se = new SecurityException(SecurityException.NOT_ALLOWED_TO_GET_INITIAL_CONTEXT, npe);
                JNDIFrame.log.logThrowable(se);
                throw se;
            }
        }
        return this.checkPermissions(remote, true, false);
    }
}

