/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIProxy;
import com.sap.engine.services.jndi.JNDIProxyImpl;
import com.sap.engine.services.jndi.NamingManager;
import com.sap.engine.services.jndi.cache.CacheCommunicatorImpl;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.implserver.ServerCtxCrossObjectFactory;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIMemoryImpl;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.directory.BasicAttributes;

public class JNDIManager
extends NamingManager {
    public static JNDIPersistentRepository db = null;
    private JNDIProxy proxy;
    private CrossObjectFactory objFactoryImpl;
    private ApplicationContainerContext containerCtx = null;
    private CacheCommunicatorImpl communicator = null;

    public JNDIProxy start() throws javax.naming.NamingException {
        try {
            SecurityBase x;
            if (db == null) {
                db = new JNDIMemoryImpl();
                db.open();
            }
            JNDIHandle rootc = db.getRootContainer();
            JNDIHandle rooto = db.findObject(rootc, "root");
            JNDIHandle jndirootc = null;
            if (!SecurityBase.WITHOUT_SECURITY && (x = SecurityBase.getServerInfo()) == null) {
                throw new NamingException(NamingException.NAMING_NOT_STARTED);
            }
            if (rooto == null) {
                rooto = db.bindObject(rootc, "root", DirObject.getNewDirObject(new BasicAttributes(), null), (short)3);
                byte[] data = null;
                try {
                    data = Serializator.toByteArray(new Properties());
                }
                catch (JNDIException je) {
                    if (JNDIFrame.log.toLogPathInCategory()) {
                        JNDIFrame.log.logCatching((Throwable)((Object)je));
                    }
                    data = new byte[]{};
                }
                jndirootc = db.createContainer("", data, false);
                db.linkObjectToContainer(rooto, jndirootc, (short)3);
                ((JNDIMemoryImpl)db).setCommunicator(this.communicator);
            } else {
                JNDIHandle tempr = db.findObject(rootc, "root");
                jndirootc = db.getLinkedContainer(tempr);
                ((JNDIMemoryImpl)db).setCommunicator(this.communicator);
            }
            this.proxy = new JNDIProxyImpl(db, rooto, jndirootc, true);
            this.objFactoryImpl = new ServerCtxCrossObjectFactory(db, rooto, jndirootc, true);
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.JNDI_PROXY_IS_INITIALIZED);
            }
            return this.proxy;
        }
        catch (JNDIException je) {
            if (JNDIFrame.log.toLogErrorInCategory()) {
                JNDIFrame.log.errorT(JNDILogConstants.JNDI_PROXY_CANNOT_BE_CREATED, new Object[]{((Throwable)((Object)je)).toString()});
                JNDIFrame.log.logCatching((Throwable)((Object)je));
            }
            NamingException ne = new NamingException(NamingException.CANNOT_START_NAMING, (Throwable)((Object)je));
            ne.log();
            throw ne;
        }
        catch (RemoteException re) {
            if (JNDIFrame.log.toLogErrorInCategory()) {
                JNDIFrame.log.errorT(JNDILogConstants.JNDI_PROXY_CANNOT_BE_CREATED, new Object[]{re.toString()});
                JNDIFrame.log.logCatching(re);
            }
            NamingException ne = new NamingException(NamingException.REMOTE_EXCEPTION_IN_START_OF_NAMING, re);
            ne.log();
            throw ne;
        }
    }

    public void stop() throws javax.naming.NamingException {
        try {
            db = null;
            NamingManager.manager = null;
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.JNDI_PROXY_CANNOT_BE_RELEASED, new Object[]{e.toString()});
                JNDIFrame.log.logCatching(e);
            }
            NamingException ne = new NamingException(NamingException.ERROR_CLOSING_OBJECT_FACTORIES, e);
            ne.log();
            throw ne;
        }
    }

    public JNDIProxy getProxy() throws javax.naming.NamingException {
        if (this.proxy != null) {
            return this.proxy;
        }
        throw new NamingException(NamingException.NAMING_NOT_STARTED);
    }

    public CrossObjectFactory getObjectFactory() throws javax.naming.NamingException {
        if (this.objFactoryImpl != null) {
            return this.objFactoryImpl;
        }
        throw new NamingException(NamingException.NAMING_NOT_STARTED);
    }

    public void setContainerContext(ApplicationContainerContext containerCtx) {
        this.containerCtx = containerCtx;
    }

    public void setCommunicator(CacheCommunicatorImpl cc) {
        this.communicator = cc;
    }
}

