/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.shellcmd.JNDIAttrServ;
import com.sap.engine.services.jndi.shellcmd.JNDIBindServ;
import com.sap.engine.services.jndi.shellcmd.JNDICdServ;
import com.sap.engine.services.jndi.shellcmd.JNDIDelTreeServ;
import com.sap.engine.services.jndi.shellcmd.JNDIFindServ;
import com.sap.engine.services.jndi.shellcmd.JNDILookupServ;
import com.sap.engine.services.jndi.shellcmd.JNDILsServ;
import com.sap.engine.services.jndi.shellcmd.JNDILsecServ;
import com.sap.engine.services.jndi.shellcmd.JNDIMAttrServ;
import com.sap.engine.services.jndi.shellcmd.JNDIMEnvServ;
import com.sap.engine.services.jndi.shellcmd.JNDIMSubServ;
import com.sap.engine.services.jndi.shellcmd.JNDIPwdServ;
import com.sap.engine.services.jndi.shellcmd.JNDIRSubServ;
import com.sap.engine.services.jndi.shellcmd.JNDIRebindServ;
import com.sap.engine.services.jndi.shellcmd.JNDISearchServ;
import com.sap.engine.services.jndi.shellcmd.JNDIUnbindServ;
import com.sap.engine.services.jndi.shellcmd.ListNamingServ;
import com.sap.engine.services.jndi.shellcmd.PrintNamingServ;
import java.util.Properties;
import javax.naming.Context;

public class JNDIContainerEventListener
extends ContainerEventListenerAdapter {
    private int shellCommandsId;
    private ShellInterface shell = null;
    private Properties properties = null;
    private Context ctx = null;

    public JNDIContainerEventListener(Properties p) {
        this.properties = p;
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_AVAILABLE, new Object[]{"shell"});
            }
            this.setCommands();
        } else if (interfaceName.equals("appcontext")) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_AVAILABLE, new Object[]{"appcontext"});
            }
            JNDIFrame.setAppContextProvider((ComponentExecutionContext)interfaceImpl);
        } else if (interfaceName.equals("security")) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_AVAILABLE, new Object[]{"security"});
            }
            try {
                JNDIFrame.initializeSecurity();
            }
            catch (ServiceException e) {
                if (JNDIFrame.log.toLogWarningInCategory()) {
                    JNDIFrame.log.warningT(JNDILogConstants.SECURITY_CHECKS_DISABLED);
                }
                JNDIFrame.log.logCatching((Throwable)((Object)e));
                JNDIFrame.loginContext = null;
                SecurityBase.WITHOUT_SECURITY = true;
            }
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_NOT_AVAILABLE, new Object[]{"shell"});
            }
            if (this.shell != null) {
                this.shell.unregisterCommands(this.shellCommandsId);
                this.shell = null;
            }
        } else if (interfaceName.equals("appcontext")) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_NOT_AVAILABLE, new Object[]{"appcontext"});
            }
            JNDIFrame.setAppContextProvider(null);
        } else if (interfaceName.equals("security")) {
            if (JNDIFrame.log.toLogPathInCategory()) {
                JNDIFrame.log.logPath(JNDILogConstants.EVENT_RECEIVED_INTERFACE_NOT_AVAILABLE, new Object[]{"security"});
            }
            JNDIFrame.loginContext = null;
            SecurityBase.WITHOUT_SECURITY = true;
        }
    }

    private void setCommands() {
        Command[] cmds = new Command[]{new JNDIBindServ(), new JNDILookupServ(), new JNDIMSubServ(), new JNDIRebindServ(), new JNDIRSubServ(), new JNDIUnbindServ(), new ListNamingServ(), new PrintNamingServ(), new JNDICdServ(), new JNDIPwdServ(), new JNDILsServ(), new JNDIAttrServ(), new JNDIMAttrServ(), new JNDIMEnvServ(), new JNDISearchServ(), new JNDIFindServ(), new JNDIDelTreeServ(), new JNDILsecServ()};
        this.shellCommandsId = this.shell.registerCommands(cmds);
    }

    public void unregisterResources() {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.shellCommandsId);
        }
        JNDIFrame.setAppContextProvider(null);
    }

    public void setContext(Context c) {
        this.ctx = c;
    }
}

