/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.lib.security.HomeHandlePermission;
import com.sap.engine.lib.security.VirtualPermission;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIProxy;
import com.sap.engine.services.jndi.LoadBalancerEnvironment;
import com.sap.engine.services.jndi.NamingManager;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.implclient.LoginHelper;
import com.sap.engine.services.jndi.implclient.OffsetClientContext;
import com.sap.engine.services.jndi.implclient.P4ReferenceFactory;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.RemoteSerializator;
import com.sap.engine.services.jndi.persistent.SerializatorFactory;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryImpl
implements InitialContextFactory {
    static Properties systemProperties = new Properties();
    static /* synthetic */ Class class$com$sap$engine$services$jndi$JNDIProxy;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Context getInitialContext(Hashtable environment) throws javax.naming.NamingException {
        String temp;
        boolean beaLoggedIn;
        Hashtable env;
        String appClientName;
        String componentName;
        block82: {
            componentName = null;
            appClientName = null;
            env = environment == null ? SystemProperties.getProperties() : (Hashtable)environment.clone();
            beaLoggedIn = false;
            boolean clear_cache = false;
            if (env.get("clear_cache") != null && env.get("clear_cache").equals("true")) {
                clear_cache = true;
            }
            if (SystemProperties.getProperty("server") != null && SystemProperties.getProperty("memory") == null) {
                env.put("server", "true");
            }
            if (env.get("server") != null && JNDIFrame.isAppContextAvailable() && JNDIFrame.threadSystem.getThreadContext() != null) {
                componentName = JNDIFrame.getAppContextProvider().getComponentName();
                if (componentName != null) {
                    componentName = componentName + ":" + JNDIFrame.getAppContextProvider().getApplicationName();
                } else if (JNDIFrame.log.toLogWarningInLocation()) {
                    JNDIFrame.log.logWarning(JNDILogConstants.CANNOT_GET_COMPONENT_NAME);
                }
            }
            try {
                block83: {
                    ServerContextImpl sc;
                    LoginHelper loginHelper;
                    block87: {
                        block84: {
                            block85: {
                                block86: {
                                    if (env.get("server") == null || env.get("force_remote") != null) break block83;
                                    String factoryName = (String)env.get("java.naming.factory.initial");
                                    if (factoryName != null && !"com.sap.engine.services.jndi.InitialContextFactoryImpl".equals(factoryName)) {
                                        if (componentName == null) return ((InitialContextFactory)Class.forName(factoryName, true, JNDIFrame.getClassLoader("service:naming")).newInstance()).getInitialContext(environment);
                                        ClassLoader loader = null;
                                        int lindex = componentName.lastIndexOf(58);
                                        loader = lindex != -1 ? JNDIFrame.getClassLoader(componentName.substring(lindex + 1)) : JNDIFrame.getClassLoader("service:naming");
                                        Class<?> factoryClass = null;
                                        try {
                                            factoryClass = Class.forName(factoryName, true, loader);
                                        }
                                        catch (Exception e) {
                                            factoryClass = Class.forName(factoryName, true, JNDIFrame.getClassLoader("service:naming"));
                                        }
                                        InitialContextFactory loadedFactory = (InitialContextFactory)factoryClass.newInstance();
                                        return loadedFactory.getInitialContext(environment);
                                    }
                                    ThreadContext threadContext = JNDIFrame.threadSystem.getThreadContext();
                                    Object loginContext = null;
                                    loginHelper = new LoginHelper();
                                    if (threadContext == null) break block84;
                                    SecurityContextObject contextObject = (SecurityContextObject)((Object)threadContext.getContextObject("security"));
                                    if (contextObject == null) break block85;
                                    if (contextObject.getSession() == null) break block86;
                                    if (contextObject.getSession().getAuthenticationConfiguration() == null) {
                                        loginHelper.serverSideLogin(env);
                                        break block87;
                                    } else if (JNDIFrame.log.toLogPathInLocation()) {
                                        JNDIFrame.log.logPath(JNDILogConstants.NO_LOGIN_FOR_AUTHENTICATED_SERVER_CLIENT, new Object[]{componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                                    }
                                    break block87;
                                }
                                if (JNDIFrame.log.toLogPathInLocation()) {
                                    JNDIFrame.log.logPath(JNDILogConstants.NO_SECURITY_SESSION, new Object[]{componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                                }
                                break block87;
                            }
                            if (JNDIFrame.log.toLogPathInLocation()) {
                                JNDIFrame.log.logPath(JNDILogConstants.NO_SECURITY_CONTEXT_OBJECT, new Object[]{componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                            }
                            break block87;
                        }
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(JNDILogConstants.NO_LOGIN_FOR_SYSTEM_CLIENT, new Object[]{componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                        }
                    }
                    if (env.get("domain") == null || !((String)env.get("domain")).equalsIgnoreCase("true")) {
                        if (componentName != null) {
                            sc = (ServerContextImpl)NamingManager.getNamingManager().getProxy().getNewServerContext(false, false);
                            if (!clear_cache) return new OffsetClientContext(env, sc, true, null, componentName, true, loginHelper);
                            ServerContextImpl.cache.emptyReferencableCache();
                            return new OffsetClientContext(env, sc, true, null, componentName, true, loginHelper);
                        }
                    } else if (componentName != null) {
                        sc = (ServerContextImpl)NamingManager.getNamingManager().getProxy().getNewServerContext(false, true);
                        if (!clear_cache) return new OffsetClientContext(env, sc, true, null, componentName, false, loginHelper);
                        ServerContextImpl.cache.emptyReferencableCache();
                        return new OffsetClientContext(env, sc, true, null, componentName, false, loginHelper);
                    }
                    sc = (ServerContextImpl)NamingManager.getNamingManager().getProxy().getNewServerContext(false, false);
                    if (!clear_cache) return new ClientContext(env, sc, true, null, loginHelper);
                    ServerContextImpl.cache.emptyReferencableCache();
                    return new ClientContext(env, sc, true, null, loginHelper);
                }
                appClientName = null;
                if (env.get("appclient") != null) break block82;
                VirtualPermission permission = new VirtualPermission(null);
                try {
                    AccessController.checkPermission(permission);
                }
                catch (Exception e) {
                    appClientName = null;
                }
                appClientName = permission.getComponentName();
                if (appClientName == null) break block82;
                if (appClientName.startsWith("@a@p@p")) {
                    appClientName = appClientName.substring(6);
                    break block82;
                }
                if (appClientName.equals("@e@j@b")) {
                    try {
                        AccessController.checkPermission(new HomeHandlePermission());
                        appClientName = null;
                        beaLoggedIn = true;
                    }
                    catch (Exception ex) {
                        JNDIFrame.log.logCatching(ex);
                        appClientName = null;
                    }
                } else {
                    appClientName = null;
                }
            }
            catch (Exception e) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.FAILED_TO_GET_INITIAL_CONTEXT, new Object[]{e.toString(), componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                    JNDIFrame.log.logCatching(e);
                }
                NamingException ne = new NamingException(NamingException.CANNOT_GET_NAMING_ON_SERVER, e);
                ne.log();
                throw ne;
            }
        }
        if (environment.get("java.naming.corba.orb") != null) {
            Object COSNamingfactory = null;
            try {
                COSNamingfactory = Class.forName("com.sap.engine.services.jndi.CosNamingInitialContextFactoryImpl").newInstance();
                return ((InitialContextFactory)COSNamingfactory).getInitialContext(environment);
            }
            catch (Exception e) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.FAILED_TO_GET_INITIAL_CONTEXT, new Object[]{e.toString(), componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                    JNDIFrame.log.logCatching(e);
                }
                NamingException ne = new NamingException(NamingException.CANNOT_GET_NAMING_ON_SERVER, e);
                ne.log();
                throw ne;
            }
        }
        if ((env = LoadBalancerEnvironment.updateEnv(env)).get("TransportLayerQueue") == null && (temp = systemProperties.getProperty("TransportLayerQueue")) != null) {
            env.put("TransportLayerQueue", temp);
        }
        if (env.get("java.naming.provider.url") == null && (temp = systemProperties.getProperty("java.naming.provider.url")) != null) {
            env.put("java.naming.provider.url", temp);
        }
        try {
            String connType;
            String primaryUrl;
            if (RemoteSerializator.serializatorFactory == null) {
                Class<?> factory = Class.forName("com.sap.engine.services.jndi.persistent.ClientSerializatorFactory");
                RemoteSerializator.serializatorFactory = (SerializatorFactory)factory.newInstance();
            }
            P4ObjectBroker broker = P4ObjectBroker.init(this.getProperties(env));
            String string = primaryUrl = env.containsKey("java.naming.provider.url") ? env.get("java.naming.provider.url").toString().trim() : SystemProperties.getProperty("java.naming.provider.url");
            if (primaryUrl.indexOf("sapms://") != -1 && primaryUrl.startsWith("sapms://")) {
                primaryUrl = env.get("sap.msg.balanced_url").toString().trim();
            }
            if (primaryUrl == null) {
                primaryUrl = InetAddress.getLocalHost().getHostAddress();
            }
            String wholeURL = new String(primaryUrl);
            if (primaryUrl.indexOf(":") != -1) {
                primaryUrl = primaryUrl.substring(0, primaryUrl.indexOf(":"));
            }
            String user = (String)env.get("java.naming.security.principal");
            String pass = (String)env.get("java.naming.security.credentials");
            if (user == null && pass == null) {
                user = SystemProperties.getProperty("_java.naming.security.principal");
                pass = SystemProperties.getProperty("_java.naming.security.credentials");
                if (user != null || pass != null) {
                    env.put("java.naming.security.principal", user);
                    env.put("java.naming.security.credentials", pass);
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(JNDILogConstants.WILL_GET_USER_AND_PASS_FROM_SYSTEM, new Object[]{componentName, env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", primaryUrl});
                    }
                }
            }
            if ((connType = (String)env.get("TransportLayerQueue")) == null && (connType = SystemProperties.getProperty("TransportLayerQueue")) == null) {
                connType = "None";
            }
            int port = 3011;
            int serverId = 0;
            if (env.containsKey("java.naming.provider.url")) {
                String idStr;
                String portStr = env.get("java.naming.provider.url").toString().trim();
                if (portStr.indexOf("sapms://") != -1 && portStr.startsWith("sapms://")) {
                    portStr = env.get("sap.msg.balanced_url").toString().trim();
                }
                if (portStr.indexOf(":") != -1) {
                    idStr = new String(portStr = portStr.substring(portStr.indexOf(":") + 1).trim());
                    if (idStr.indexOf(35) != -1) {
                        portStr = portStr.substring(0, portStr.indexOf(35)).trim();
                        idStr = idStr.substring(idStr.indexOf(35) + 1).trim();
                        try {
                            serverId = Integer.parseInt(idStr);
                        }
                        catch (NumberFormatException nfe) {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(JNDILogConstants.WRONG_SERVER_ID, new Object[]{wholeURL});
                                JNDIFrame.log.logCatching(nfe);
                            }
                            serverId = 0;
                        }
                    }
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException nfe) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.WRONG_URL_PORT, new Object[]{wholeURL});
                            JNDIFrame.log.logCatching(nfe);
                        }
                        port = 3011;
                    }
                } else if (portStr.indexOf(35) != -1) {
                    idStr = portStr.substring(portStr.indexOf("#") + 1).trim();
                    try {
                        serverId = Integer.parseInt(idStr);
                    }
                    catch (NumberFormatException nfe) {
                        if (JNDIFrame.log.toLogInfoInCategory()) {
                            JNDIFrame.log.infoT(JNDILogConstants.WRONG_SERVER_ID, new Object[]{wholeURL});
                            JNDIFrame.log.logCatching(nfe);
                        }
                        serverId = 0;
                    }
                }
            }
            LoginHelper loginContext = null;
            if (!beaLoggedIn) {
                if (env.get("force_remote") != null && env.get("server") != null && env.get("server").equals("true")) {
                    loginContext = new LoginHelper();
                    loginContext.serverSideLogin(env, connType, primaryUrl, port);
                } else {
                    loginContext = new LoginHelper();
                    loginContext.clientSideLogin(env, connType, primaryUrl, port);
                }
            }
            if (serverId == 0) {
                serverId = loginContext.getServerId();
            }
            StubBaseInfo info = null;
            boolean repeat = true;
            int count = 5;
            InitialContextFactoryImpl initialContextFactoryImpl = this;
            synchronized (initialContextFactoryImpl) {
                while (repeat) {
                    try {
                        info = serverId != 0 ? (StubBaseInfo)broker.resolveInitialReference(connType, "naming", primaryUrl, port, serverId) : (StubBaseInfo)broker.resolveInitialReference(connType, "naming", primaryUrl, port);
                        repeat = false;
                    }
                    catch (ConnectException e) {
                        JNDIFrame.log.logCatching(e);
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException ie) {
                            repeat = true;
                        }
                        if (count-- != 0) continue;
                    }
                }
            }
            JNDIProxy proxy = null;
            proxy = (JNDIProxy)broker.narrow(info, class$com$sap$engine$services$jndi$JNDIProxy == null ? (class$com$sap$engine$services$jndi$JNDIProxy = InitialContextFactoryImpl.class$("com.sap.engine.services.jndi.JNDIProxy")) : class$com$sap$engine$services$jndi$JNDIProxy, P4ObjectBroker.transportType);
            systemProperties.setProperty("java.naming.provider.url", wholeURL);
            systemProperties.setProperty("TransportLayerQueue", connType);
            ServerContextInface serverContextInface = proxy.getNewServerContext(true, true);
            if (env.get("Replicate") == null) {
                env.put("Replicate", "true");
            }
            if (appClientName != null) return (ClientContext)new ClientContext(env, serverContextInface, false, new P4ReferenceFactory(), loginContext).lookup("appclients/" + appClientName);
            if (componentName == null) return new ClientContext(env, serverContextInface, false, new P4ReferenceFactory(), loginContext);
            return new OffsetClientContext(env, serverContextInface, false, null, componentName, false, loginContext);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                if (m.indexOf("com.sap.engine.services.rmi_p4.P4IOException") != -1) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.NO_SERVER_IS_RUNNING, new Object[]{e.toString(), env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", env.get("java.naming.provider.url") != null ? env.get("java.naming.provider.url") : "N/A"});
                    }
                    JNDIFrame.log.logCatching(e);
                    NamingException ne = new NamingException(NamingException.NO_SERVER_RUNNING, e);
                    ne.log();
                    ne.setRootCause(e);
                    throw ne;
                }
                if (m.indexOf("LoginException") != -1) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.WRONG_LOGIN_INFO, new Object[]{e.toString(), env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", env.get("java.naming.provider.url") != null ? env.get("java.naming.provider.url") : "N/A"});
                    }
                    JNDIFrame.log.logCatching(e);
                    NoPermissionException npe = new NoPermissionException(NoPermissionException.LOGIN_EXCEPTION_IN_GETTING_INITIAL_CONTEXT, e);
                    npe.log();
                    throw npe;
                }
            }
            if (e instanceof P4IOException) {
                if (m != null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(JNDILogConstants.NO_SERVER_IS_RUNNING, new Object[]{e.toString(), env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", env.get("java.naming.provider.url") != null ? env.get("java.naming.provider.url") : "N/A"});
                        JNDIFrame.log.logCatching(e);
                    }
                    NamingException ne = new NamingException(NamingException.NO_SERVER_RUNNING, e);
                    ne.log();
                    throw ne;
                }
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_ESTABLISH_CONNECTION, new Object[]{e.toString(), env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", env.get("java.naming.provider.url") != null ? env.get("java.naming.provider.url") : "N/A"});
                    JNDIFrame.log.logCatching(e);
                }
                NamingException ne = new NamingException(NamingException.WRONG_URL, e);
                ne.log();
                throw ne;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.FAILED_TO_GET_INITIAL_CONTEXT, new Object[]{e.toString(), env.get("java.naming.factory.initial") != null ? env.get("java.naming.factory.initial") : "N/A", env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A", env.get("java.naming.provider.url") != null ? env.get("java.naming.provider.url") : "N/A"});
                JNDIFrame.log.logCatching(e);
            }
            NamingException ne = new NamingException(NamingException.EXCEPTION_IN_GETTING_INITIAL_CONTEXT, e);
            ne.setRootCause(e);
            ne.log();
            throw ne;
        }
    }

    private Properties getProperties(Hashtable environment) {
        Properties properties = new Properties();
        Enumeration e = environment.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)properties).put(key, environment.get(key));
        }
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

