/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.services.jndi.cosnaming.CosNamingContext;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class CosNamingInitialContextFactoryImpl
implements InitialContextFactory {
    public static final String DEFAULT_INIT_ORB_PORT = "3333";
    public static final String IIOP_PREFIX = "iiop://";
    private static java.lang.Object monitor = new java.lang.Object();

    public Context getInitialContext(Hashtable environment) throws javax.naming.NamingException {
        java.lang.Object object = monitor;
        synchronized (object) {
            try {
                Properties env = environment == null ? SystemProperties.getProperties() : (Hashtable)environment.clone();
                ORB orb = null;
                java.lang.Object orbObject = ((Hashtable)env).get("java.naming.corba.orb");
                if (orbObject != null && orbObject instanceof ORB) {
                    orb = (ORB)orbObject;
                } else {
                    int colonIndex;
                    String url;
                    String string = url = ((Hashtable)env).containsKey("java.naming.provider.url") ? ((Hashtable)env).get("java.naming.provider.url").toString().trim() : SystemProperties.getProperty("java.naming.provider.url");
                    if (url == null) {
                        url = InetAddress.getLocalHost().getHostAddress();
                    }
                    String host = url;
                    String port = DEFAULT_INIT_ORB_PORT;
                    if (url.startsWith(IIOP_PREFIX)) {
                        url = url.substring(url.indexOf(IIOP_PREFIX) + IIOP_PREFIX.length());
                    }
                    if ((colonIndex = url.indexOf(":")) != -1) {
                        host = url.substring(0, colonIndex);
                        port = url.substring(colonIndex + 1);
                    }
                    Properties props = new Properties();
                    ((Hashtable)props).putAll(environment);
                    ((Hashtable)props).put("org.omg.CORBA.ORBInitialPort", port);
                    ((Hashtable)props).put("org.omg.CORBA.ORBInitialHost", host);
                    orb = ORB.init((String[])new String[0], (Properties)props);
                }
                Object obj = orb.resolve_initial_references("NameService");
                NamingContextExt cosNaming = NamingContextExtHelper.narrow((Object)obj);
                CosNamingContext result = new CosNamingContext((NamingContext)cosNaming, env);
                if ("true".equals(((Hashtable)env).get("global"))) {
                    // empty if block
                }
                CosNamingContext cosNamingContext = result;
                return cosNamingContext;
            }
            catch (Exception e) {
                NamingException ne = new NamingException(NamingException.EXCEPTION_IN_GETTING_INITIAL_CONTEXT, e);
                ne.log();
                throw ne;
            }
        }
    }
}

