/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.shellcmd;

import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jmx.shellcmd.Utils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class QueryNamesCommand
implements Command {
    private static final String[] DEFAULT_PARAMS = new String[]{"*:*"};
    private static final String NAME = "QUERY_NAMES";
    private ObjectRegistry registry;

    public QueryNamesCommand(ObjectRegistry registry) {
        this.registry = registry;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        Set<ObjectName> names;
        ObjectName pattern;
        PrintStream outputStream = new PrintStream(output);
        if (params.length == 0) {
            params = DEFAULT_PARAMS;
        } else if (params.length != 1 || params.length == 1 && (params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help") || params[0].equals("-?"))) {
            outputStream.println(this.getHelpMessage());
            return;
        }
        try {
            pattern = new ObjectName(params[0]);
        }
        catch (MalformedObjectNameException e) {
            outputStream.println("  Malformed ObjectName pattern: " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace(outputStream);
            return;
        }
        try {
            names = Utils.getMBeanServer(this.registry).queryNames(pattern, null);
        }
        catch (RuntimeException e) {
            e.printStackTrace(outputStream);
            return;
        }
        if (names.isEmpty()) {
            outputStream.println("  No matching names found.");
        } else {
            outputStream.println("  Matching names:");
            Iterator<ObjectName> iter = names.iterator();
            while (iter.hasNext()) {
                outputStream.println("    " + iter.next());
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public String getGroup() {
        return "JMX";
    }

    public String[] getSupportedShellProviderNames() {
        return Utils.SEHLL_PROVIDER_NAMES;
    }

    public String getHelpMessage() {
        return "  Returns the names of the MBeans matching the given pattern." + Utils.NEW_LINE + "    Usage: " + this.getName() + " <[pattern]>" + Utils.NEW_LINE + "      Parameters: " + Utils.NEW_LINE + "        <pattern> - the pattern to match, no pattern means *:*";
    }
}

