/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.connector.notification;

import com.sap.engine.services.jmx.connector.notification.ListenerID;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationFilter;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationListener;
import com.sap.engine.services.jmx.exception.JmxIllegalStateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class ListenerRegistry {
    private Map broadcasterProxies = new HashMap();
    private Map index;

    public ListenerRegistry(Map listenerIndex) {
        this.index = listenerIndex;
    }

    public ListenerID addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        ListenerID id = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster == null) {
                broadcaster = new NotificationBroadcasterProxy();
                this.broadcasterProxies.put(observed, broadcaster);
            }
            id = broadcaster.addNotificationListener(listener, filter, handback);
        }
        return id;
    }

    public ListenerID addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        ListenerID id = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster == null) {
                broadcaster = new NotificationBroadcasterProxy();
                this.broadcasterProxies.put(observed, broadcaster);
            }
            id = broadcaster.addNotificationListener(new NullListener(listener), filter, handback);
        }
        return id;
    }

    public ListenerID removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ListenerID id = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster == null) {
                throw new ListenerNotFoundException();
            }
            id = broadcaster.removeNotificationListener(listener, filter, handback);
        }
        return id;
    }

    public ListenerID[] removeNotificationListener(ObjectName observed, NotificationListener listener) throws ListenerNotFoundException {
        ListenerID[] ids = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster != null) {
                ids = broadcaster.removeNotificationListener(listener);
            }
        }
        return ids;
    }

    public ListenerID removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ListenerID id = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster == null) {
                throw new ListenerNotFoundException();
            }
            id = broadcaster.removeNotificationListener(new NullListener(listener), filter, handback);
        }
        return id;
    }

    public ListenerID[] removeNotificationListener(int targetID, ObjectName observed, ObjectName listener) throws ListenerNotFoundException {
        ListenerID[] ids = null;
        Map map = this.index;
        synchronized (map) {
            NotificationBroadcasterProxy broadcaster = (NotificationBroadcasterProxy)this.broadcasterProxies.get(observed);
            if (broadcaster == null) {
                throw new ListenerNotFoundException();
            }
            ids = broadcaster.removeNotificationListener(new NullListener(listener));
        }
        return ids;
    }

    public Boolean checkEnabled(ListenerID id, Notification notification) {
        Map map = this.index;
        synchronized (map) {
            ListenerRegistrationInfo info = (ListenerRegistrationInfo)this.index.get(id);
            if (info == null) {
                Boolean bl = new Boolean(false);
                return bl;
            }
            NotificationFilter filter = info.getClientSideFilter();
            if (!ListenerRegistrationInfo.NULL_FILTER.equals(filter)) {
                Boolean bl = new Boolean(filter.isNotificationEnabled(notification));
                return bl;
            }
            Boolean bl = new Boolean(false);
            return bl;
        }
    }

    public void sendNotification(ListenerID id, Notification notification) {
        ListenerRegistrationInfo info;
        Map map = this.index;
        synchronized (map) {
            info = (ListenerRegistrationInfo)this.index.get(id);
        }
        if (info == null) {
            return;
        }
        this.sendNotification(notification, info);
    }

    private void sendNotification(Notification notification, ListenerRegistrationInfo info) {
        NotificationFilter filter = info.getClientSideFilter();
        NotificationListener listener = info.getClientSideListener();
        Object handback = info.getClientSideHandback();
        if (!ListenerRegistrationInfo.NULL_FILTER.equals(filter) && !filter.isNotificationEnabled(notification)) {
            return;
        }
        if (!(listener instanceof NullListener)) {
            listener.handleNotification(notification, handback);
        }
    }

    static /* synthetic */ void access$400(ListenerRegistry x0, Notification x1, ListenerRegistrationInfo x2) {
        x0.sendNotification(x1, x2);
    }

    public class NullListener
    implements NotificationListener {
        ObjectName listener;

        public NullListener(ObjectName listener) {
            this.listener = listener;
        }

        public void handleNotification(Notification notification, Object handback) {
        }

        public String toString() {
            return "null listener";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            try {
                if (this.listener == null && ((NullListener)obj).listener == null) {
                    return true;
                }
                if (this.listener != null && this.listener.equals(((NullListener)obj).listener)) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    private static final class ListenerRegistrationInfo {
        private static final NotificationFilter NULL_FILTER = new NotificationFilter(){

            public boolean isNotificationEnabled(Notification notification) {
                return true;
            }

            public String toString() {
                return "null filter";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return true;
                }
                return obj == this;
            }
        };
        private static final Object NULL_HANDBACK = new Object(){

            public String toString() {
                return "null handback";
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return true;
                }
                return obj == this;
            }
        };
        private NotificationListener listener;
        private NotificationFilter filter;
        private Object handback;
        private ListenerID id;

        public ListenerRegistrationInfo(NotificationListener listener, NotificationFilter filter, Object handback, ListenerID id) {
            if (listener == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
            }
            if (filter == null) {
                filter = NULL_FILTER;
            }
            if (handback == null) {
                handback = NULL_HANDBACK;
            }
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
            this.id = id;
        }

        public NotificationListener getListener() {
            return this.listener;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public Object getHandback() {
            return this.handback;
        }

        public ListenerID getID() {
            return this.id;
        }

        public NotificationListener getClientSideListener() {
            if (this.listener instanceof NullListener) {
                return null;
            }
            if (this.listener instanceof ServerSideNotificationListener) {
                return null;
            }
            return this.listener;
        }

        public NotificationFilter getClientSideFilter() {
            if (this.filter.equals(NULL_FILTER)) {
                return null;
            }
            if (this.filter instanceof ServerSideNotificationFilter) {
                return null;
            }
            return this.filter;
        }

        public Object getClientSideHandback() {
            if (this.handback.equals(NULL_HANDBACK)) {
                return null;
            }
            if (this.listener instanceof ServerSideNotificationListener) {
                return null;
            }
            return this.handback;
        }
    }

    private final class NotificationBroadcasterProxy {
        private HashMap listeners = new HashMap();
        private HashMap defaultListeners = new HashMap();
        private int defaultListenerCount = 0;
        private NotificationListener defaultListenerForwarder = new NotificationListener(this){
            private final /* synthetic */ NotificationBroadcasterProxy this$1;
            {
                this.this$1 = this$1;
            }

            public void handleNotification(Notification notification, Object handback) {
                Iterator<V> listenerIter = NotificationBroadcasterProxy.access$200(this.this$1).values().iterator();
                while (listenerIter.hasNext()) {
                    Iterator<E> listIter = ((List)listenerIter.next()).iterator();
                    while (listIter.hasNext()) {
                        ListenerRegistrationInfo info = (ListenerRegistrationInfo)listIter.next();
                        ListenerRegistry.access$400(NotificationBroadcasterProxy.access$300(this.this$1), notification, info);
                    }
                }
            }

            public String toString() {
                return "default listener";
            }
        };
        private ListenerRegistrationInfo defaultListenerInfo;

        private NotificationBroadcasterProxy() {
        }

        public ListenerID addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
            ListenerID result;
            if (this.isIndividualListener(listener, filter)) {
                Map map = ListenerRegistry.this.index;
                synchronized (map) {
                    LinkedList<ListenerRegistrationInfo> registrationList = (LinkedList<ListenerRegistrationInfo>)this.listeners.get(listener);
                    if (registrationList == null) {
                        registrationList = new LinkedList<ListenerRegistrationInfo>();
                        this.listeners.put(listener, registrationList);
                    }
                    ListenerRegistrationInfo info = new ListenerRegistrationInfo(listener, filter, handback, ListenerID.newListenerID());
                    registrationList.add(info);
                    ListenerRegistry.this.index.put(info.getID(), info);
                    result = info.getID();
                }
            }
            Map map = ListenerRegistry.this.index;
            synchronized (map) {
                LinkedList<ListenerRegistrationInfo> registrationList = (LinkedList<ListenerRegistrationInfo>)this.defaultListeners.get(listener);
                if (registrationList == null) {
                    registrationList = new LinkedList<ListenerRegistrationInfo>();
                    this.defaultListeners.put(listener, registrationList);
                }
                if (this.defaultListenerInfo == null) {
                    this.defaultListenerInfo = new ListenerRegistrationInfo(this.defaultListenerForwarder, null, null, ListenerID.newListenerID());
                    result = this.defaultListenerInfo.getID();
                } else {
                    result = null;
                }
                ListenerRegistrationInfo info = new ListenerRegistrationInfo(listener, filter, handback, this.defaultListenerInfo.getID());
                registrationList.add(info);
                ListenerRegistry.this.index.put(this.defaultListenerInfo.getID(), this.defaultListenerInfo);
                this.incDefaultListenerCount();
            }
            return result;
        }

        public ListenerID removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
            ListenerID result;
            if (this.isIndividualListener(listener, filter)) {
                Map map = ListenerRegistry.this.index;
                synchronized (map) {
                    List registrationList = (List)this.listeners.get(listener);
                    if (registrationList == null) {
                        throw new ListenerNotFoundException();
                    }
                    Iterator iter = registrationList.iterator();
                    boolean found = false;
                    result = null;
                    while (iter.hasNext()) {
                        ListenerRegistrationInfo info = (ListenerRegistrationInfo)iter.next();
                        if (!info.getFilter().equals(filter) || !info.getHandback().equals(handback)) continue;
                        iter.remove();
                        ListenerRegistry.this.index.remove(info.getID());
                        result = info.getID();
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new ListenerNotFoundException();
                    }
                    if (registrationList.isEmpty()) {
                        this.listeners.remove(listener);
                    }
                }
            }
            Map map = ListenerRegistry.this.index;
            synchronized (map) {
                List registrationList = (List)this.defaultListeners.get(listener);
                if (registrationList == null) {
                    throw new ListenerNotFoundException();
                }
                Iterator iter = registrationList.iterator();
                boolean found = false;
                result = null;
                while (iter.hasNext()) {
                    ListenerRegistrationInfo info = (ListenerRegistrationInfo)iter.next();
                    if (!info.getFilter().equals(filter) || !info.getHandback().equals(handback)) continue;
                    iter.remove();
                    if (this.decDefaultListenerCount() <= 0) {
                        result = this.defaultListenerInfo.getID();
                        ListenerRegistry.this.index.remove(result);
                        this.defaultListenerInfo = null;
                    } else {
                        result = null;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    throw new ListenerNotFoundException();
                }
                if (registrationList.isEmpty()) {
                    this.defaultListeners.remove(listener);
                }
            }
            return result;
        }

        public ListenerID[] removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
            Iterator iter;
            ArrayList<ListenerID> result = new ArrayList<ListenerID>();
            boolean found = false;
            Map map = ListenerRegistry.this.index;
            synchronized (map) {
                List registrationList = (List)this.listeners.get(listener);
                if (registrationList != null) {
                    found = true;
                    Iterator iter2 = registrationList.iterator();
                    while (iter2.hasNext()) {
                        ListenerRegistrationInfo info = (ListenerRegistrationInfo)iter2.next();
                        ListenerRegistry.this.index.remove(info.getID());
                        result.add(info.getID());
                    }
                    this.listeners.remove(listener);
                }
            }
            Map map2 = ListenerRegistry.this.index;
            synchronized (map2) {
                List registrationList = (List)this.defaultListeners.get(listener);
                if (registrationList != null) {
                    found = true;
                    iter = registrationList.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        if (this.decDefaultListenerCount() > 0) continue;
                        result.add(this.defaultListenerInfo.getID());
                        ListenerRegistry.this.index.remove(this.defaultListenerInfo.getID());
                        this.defaultListenerInfo = null;
                    }
                    this.defaultListeners.remove(listener);
                }
            }
            if (!found) {
                throw new ListenerNotFoundException();
            }
            ListenerID[] resArray = new ListenerID[result.size()];
            iter = result.iterator();
            int i = 0;
            while (iter.hasNext()) {
                resArray[i++] = (ListenerID)iter.next();
            }
            return resArray;
        }

        private void incDefaultListenerCount() {
            ++this.defaultListenerCount;
            if (this.defaultListenerCount == Integer.MAX_VALUE) {
                throw new JmxIllegalStateException("jmx_1405");
            }
        }

        private int decDefaultListenerCount() {
            --this.defaultListenerCount;
            if (this.defaultListenerCount < 0) {
                this.defaultListenerCount = 0;
            }
            return this.defaultListenerCount;
        }

        private boolean isIndividualListener(NotificationListener listener, NotificationFilter filter) {
            return listener instanceof ServerSideNotificationListener || filter instanceof ServerSideNotificationFilter;
        }

        static /* synthetic */ HashMap access$200(NotificationBroadcasterProxy x0) {
            return x0.defaultListeners;
        }

        static /* synthetic */ ListenerRegistry access$300(NotificationBroadcasterProxy x0) {
            return x0.ListenerRegistry.this;
        }
    }
}

