/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ThreadContextSerializator {
    private final ClientThreadContext threadContext;
    private int coCount;
    private int pos;
    private byte[] serializedThreadContext;
    private int threadContextLength;

    public ThreadContextSerializator(ClientThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public byte[] getBytes() throws IOException {
        this.serialize();
        return this.serializedThreadContext;
    }

    private void serialize() throws IOException {
        if (this.threadContext != null && this.serializedThreadContext == null) {
            ContextObjectNameIterator coIt = this.threadContext.getTransferableContextObjectNames();
            this.coCount = 0;
            this.threadContextLength = 0;
            this.calculateThreadContextInfo(coIt);
        }
    }

    private void calculateThreadContextInfo(ContextObjectNameIterator coIt) throws IOException {
        if (coIt.hasNext()) {
            String coName = coIt.nextName();
            byte[] serializedCoName = null;
            int serializedCoNameLength = 0;
            int coSize = 0;
            Transferable co = null;
            ContextObject obj = this.threadContext.getContextObject(coName);
            if (obj instanceof Transferable) {
                co = (Transferable)((Object)obj);
                coSize = co.size();
                if (coSize > 0) {
                    ++this.coCount;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeUTF(coName);
                    serializedCoName = baos.toByteArray();
                    serializedCoNameLength = serializedCoName.length;
                    this.threadContextLength += coSize + 2;
                    this.threadContextLength += serializedCoNameLength + 2;
                }
            } else {
                coSize = -1;
            }
            this.calculateThreadContextInfo(coIt);
            if (coSize > 0) {
                this.serializedThreadContext[this.pos++] = (byte)(serializedCoNameLength >>> 8 & 0xFF);
                this.serializedThreadContext[this.pos++] = (byte)(serializedCoNameLength >>> 0 & 0xFF);
                System.arraycopy(serializedCoName, 0, this.serializedThreadContext, this.pos, serializedCoNameLength);
                this.pos += serializedCoNameLength;
                this.serializedThreadContext[this.pos++] = (byte)(coSize >>> 8 & 0xFF);
                this.serializedThreadContext[this.pos++] = (byte)(coSize >>> 0 & 0xFF);
                co.store(this.serializedThreadContext, this.pos);
                this.pos += coSize;
            }
        } else {
            if (this.coCount > 0) {
                this.threadContextLength += 2;
                this.serializedThreadContext = new byte[this.threadContextLength];
                this.pos = 0;
                this.serializedThreadContext[this.pos++] = (byte)(this.coCount >>> 8 & 0xFF);
                this.serializedThreadContext[this.pos++] = (byte)(this.coCount >>> 0 & 0xFF);
            } else {
                this.serializedThreadContext = new byte[0];
            }
            return;
        }
    }

    public static void restore(byte[] src, int off, ClientThreadContext target) throws IOException {
        int nbCo = ((src[off] & 0xFF) << 8) + ((src[off + 1] & 0xFF) << 0);
        off += 2;
        int i = 0;
        while (i < nbCo) {
            int nameSize = ((src[off] & 0xFF) << 8) + ((src[off + 1] & 0xFF) << 0);
            ByteArrayInputStream bais = new ByteArrayInputStream(src, off += 2, nameSize);
            DataInputStream dis = new DataInputStream(bais);
            String coName = dis.readUTF();
            int coSize = ((src[off += nameSize] & 0xFF) << 8) + ((src[off + 1] & 0xFF) << 0);
            off += 2;
            ContextObject co = target.getContextObject(coName);
            if (co instanceof Transferable) {
                ((Transferable)((Object)co)).load(src, off);
            }
            off += coSize;
            ++i;
        }
    }

    public static void restore(ClientThreadContext src, ClientThreadContext target) {
        ContextObjectNameIterator coIt = src.getContextObjectNames();
        while (coIt.hasNext()) {
            String coName = coIt.nextName();
            target.setContextObject(coName, src.getContextObject(coName));
        }
    }
}

