/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.Message;
import com.sap.engine.services.jmx.ObjectStreamFactory;
import com.sap.engine.services.jmx.ParameterizedStream;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class ResponseMessage
extends Message {
    private static final byte IS_EXCEPTION_MASK = 1;
    private static final byte IS_EXCEPTION_SHIFT = 0;
    private transient boolean isException;
    private transient Object result;
    private transient boolean deserialized;
    private transient byte srcType;

    public ResponseMessage() {
        this.deserialized = false;
        this.srcType = 0;
    }

    protected ResponseMessage(Object result, byte srcType, boolean isException) {
        this.deserialized = true;
        this.result = result;
        this.srcType = srcType;
        this.isException = isException;
    }

    public ResponseMessage(Object result, byte srcType) {
        this(result, srcType, false);
    }

    public boolean isNull() {
        if (this.deserialized) {
            return this.result == null;
        }
        return this.getBodyLength() <= 1;
    }

    public final Object getResult(Map streamParams) throws JmxConnectorException {
        this.readResult(streamParams);
        return this.result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readResult(Map streamParams) throws JmxConnectorException {
        if (this.deserialized) {
            return;
        }
        if (this.getBodyLength() <= 1) {
            this.result = null;
            return;
        }
        ObjectInputStream ois = null;
        try {
            try {
                ois = ObjectStreamFactory.getInputStream(this.getInputStream(this.getHeaderLength()));
                ((ParameterizedStream)((Object)ois)).setParameters(streamParams);
                this.result = ois.readObject();
                this.deserialized = true;
            }
            catch (Throwable t) {
                throw new JmxConnectorException("jmx_2217", new Object[]{this.toString()}, t);
            }
            Object var5_3 = null;
            if (ois == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        ois.close();
        return;
    }

    protected int writeVariableHeader(int startPos) throws IOException {
        this.getDataOutput(startPos).writeByte((this.isException ? 1 : 0) << 0 & 1);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeBody(int startPos) throws IOException {
        if (this.result == null) return this.getCurrentWritePos() - startPos;
        ObjectOutputStream oos = null;
        try {
            try {
                oos = ObjectStreamFactory.getOutputStream(this.getOutputStream(startPos));
                oos.writeObject(this.result);
                oos.flush();
            }
            catch (IOException e) {
                throw new JmxConnectorException("jmx_2215", new Object[]{this.toString()}, e);
            }
            Object var5_3 = null;
            if (oos == null) return this.getCurrentWritePos() - startPos;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        oos.close();
        return this.getCurrentWritePos() - startPos;
    }

    protected void readVariableHeader(DataInput din) throws IOException {
        byte flag = din.readByte();
        this.isException = (flag & 1) >>> 0 == 1;
    }

    public boolean isException() {
        return this.isException;
    }

    protected StringBuffer appendBody(StringBuffer sb) {
        if (this.deserialized) {
            sb.append(this.result);
        }
        return sb;
    }
}

