/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.JmxFrame;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerSecurityWrapper
implements MBeanServer {
    private final JmxFrame frame;
    private final MBeanServer mbs;

    public MBeanServerSecurityWrapper(JmxFrame frame, MBeanServer mbs) {
        this.frame = frame;
        this.mbs = mbs;
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        this.frame.checkIsAdmin();
        return this.mbs.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbs.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        return this.mbs.deserialize(className, loaderName, data);
    }

    public Object instantiate(String className) throws MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        return this.mbs.instantiate(className);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        return this.mbs.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        return this.mbs.instantiate(className, loaderName);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        return this.mbs.instantiate(className, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.frame.checkMBeanPermission(object == null ? null : object.getClass().getName(), null, name, "registerMBean");
        return this.mbs.registerMBean(object, name);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "addNotificationListener");
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "addNotificationListener");
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbs.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbs.createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbs.createMBean(className, name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.frame.checkMBeanPermission(null, attribute, name, "getAttribute");
        return this.mbs.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.frame.checkMBeanPermission(null, null, name, "getAttribute");
        return this.mbs.getAttributes(name, attributes);
    }

    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.frame.checkMBeanPermission(null, null, name, "getMBeanInfo");
        return this.mbs.getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "getObjectInstance");
        return this.mbs.getObjectInstance(name);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(null, operationName, name, "invoke");
        return this.mbs.invoke(name, operationName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "isInstanceOf");
        return this.mbs.isInstanceOf(name, className);
    }

    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.frame.checkMBeanPermission(null, null, null, "queryMBeans");
        return this.mbs.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        this.frame.checkMBeanPermission(null, null, null, "queryNames");
        return this.mbs.queryNames(name, query);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbs.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbs.removeNotificationListener(name, listener);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.frame.checkMBeanPermission(null, attribute == null ? null : attribute.getName(), name, "setAttribute");
        this.mbs.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.frame.checkMBeanPermission(null, null, name, "setAttribute");
        return this.mbs.setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.frame.checkMBeanPermission(null, null, name, "unregisterMBean");
        this.mbs.unregisterMBean(name);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, name, "getClassLoaderFor");
        return this.mbs.getClassLoaderFor(name);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.frame.checkMBeanPermission(null, null, loaderName, "getClassLoader");
        return this.mbs.getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.frame.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.mbs.getClassLoaderRepository();
    }

    public String[] getDomains() {
        this.frame.checkMBeanPermission(null, null, null, "getDomains");
        return this.mbs.getDomains();
    }
}

