/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.connector.notification.ListenerID;
import com.sap.engine.services.jmx.connector.notification.ListenerRegistry;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationFilter;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import com.sap.engine.services.jmx.exception.JmxIllegalStateException;
import com.sap.engine.services.jmx.exception.RemoteMBeanServerException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.MarshalledObject;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;

public class MBeanServerInvoker
implements JmxServiceMessageClient {
    private final MBeanServer server;
    private final Map serverListeners = new HashMap();
    private final ListenerRegistry myListenerRegistry;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$MBeanServerInvoker == null ? (class$com$sap$engine$services$jmx$MBeanServerInvoker = MBeanServerInvoker.class$("com.sap.engine.services.jmx.MBeanServerInvoker")) : class$com$sap$engine$services$jmx$MBeanServerInvoker));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$MBeanServerInvoker;

    public MBeanServerInvoker(MBeanServer server, Map listenerIndex) {
        this.server = server;
        this.myListenerRegistry = listenerIndex == null ? null : new ListenerRegistry(listenerIndex);
    }

    private ListenerRegistry getMyListenerRegistry() {
        if (this.myListenerRegistry == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"MBeanServerInvoker", "listenerRegistry"});
        }
        return this.myListenerRegistry;
    }

    public void invokeMbsAsync(RequestMessage request) throws JmxConnectorException {
        if (request.getRequestType() != 29) {
            throw new JmxIllegalArgumentException("jmx_1306", new Object[]{String.valueOf(request.getRequestType()), request.toString()});
        }
        ResponseMessage response = this.invokeMbs(request);
        if (response != null && !response.isNull()) {
            LoggingHelper.SYS_SERVER.logT(500, LOCATION, "invokeMbsAsync(RequestMessage)", "unexpected response received, message " + response + " request " + request);
        }
    }

    public ResponseMessage invokeMbs(RequestMessage request) {
        if (this.server == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"MBeanServerInvoker", "MBeanServer"});
        }
        try {
            Object[] params;
            try {
                params = request.getParams(this.server);
            }
            catch (JmxConnectorException e) {
                Category.SYS_SERVER.logThrowableT(400, LOCATION, "JMX connector exception occurred while processing external JMX request " + request, (Throwable)((Object)e));
                return new ExceptionMessage((Throwable)((Object)e));
            }
            Object result = null;
            switch (request.getRequestType()) {
                case 1: {
                    result = this.server.createMBean((String)params[0], (ObjectName)params[1]);
                    break;
                }
                case 2: {
                    result = this.server.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2]);
                    break;
                }
                case 4: {
                    result = this.server.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2], (Object[])params[3], (String[])params[4]);
                    break;
                }
                case 3: {
                    result = this.server.createMBean((String)params[0], (ObjectName)params[1], (Object[])params[2], (String[])params[3]);
                    break;
                }
                case 5: {
                    result = this.server.getAttribute((ObjectName)params[0], (String)params[1]);
                    break;
                }
                case 6: {
                    result = this.server.getAttributes((ObjectName)params[0], (String[])params[1]);
                    break;
                }
                case 7: {
                    result = this.server.getDefaultDomain();
                    break;
                }
                case 8: {
                    result = this.server.getMBeanCount();
                    break;
                }
                case 9: {
                    result = this.server.getMBeanInfo((ObjectName)params[0]);
                    break;
                }
                case 10: {
                    result = this.server.getObjectInstance((ObjectName)params[0]);
                    break;
                }
                case 11: {
                    result = this.server.invoke((ObjectName)params[0], (String)params[1], (Object[])params[2], (String[])params[3]);
                    break;
                }
                case 12: {
                    result = new Boolean(this.server.isInstanceOf((ObjectName)params[0], (String)params[1]));
                    break;
                }
                case 13: {
                    result = new Boolean(this.server.isRegistered((ObjectName)params[0]));
                    break;
                }
                case 14: {
                    result = this.server.queryMBeans((ObjectName)params[0], (QueryExp)params[1]);
                    break;
                }
                case 15: {
                    result = this.server.queryNames((ObjectName)params[0], (QueryExp)params[1]);
                    break;
                }
                case 16: {
                    this.server.setAttribute((ObjectName)params[0], (Attribute)params[1]);
                    break;
                }
                case 17: {
                    result = this.server.setAttributes((ObjectName)params[0], (AttributeList)params[1]);
                    break;
                }
                case 18: {
                    this.server.unregisterMBean((ObjectName)params[0]);
                    break;
                }
                case 19: {
                    this.server.addNotificationListener((ObjectName)params[0], (NotificationListener)params[1], (NotificationFilter)params[2], params[3]);
                    break;
                }
                case 20: {
                    this.server.addNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                    break;
                }
                case 21: {
                    this.server.removeNotificationListener((ObjectName)params[0], (NotificationListener)params[1]);
                    break;
                }
                case 22: {
                    this.server.removeNotificationListener((ObjectName)params[0], (NotificationListener)params[1], (NotificationFilter)params[2], params[3]);
                    break;
                }
                case 23: {
                    this.server.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1]);
                    break;
                }
                case 24: {
                    this.server.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                    break;
                }
                case 25: {
                    this.addServerSideListener((ListenerID)params[0], (ObjectName)params[1], (NotificationListener)params[2], (ServerSideNotificationFilter)params[3], (MarshalledObject)params[4]);
                    break;
                }
                case 26: {
                    this.addServerSideListener((ListenerID)params[0], (ObjectName)params[1], (ObjectName)params[2], (ServerSideNotificationFilter)params[3], (MarshalledObject)params[4]);
                    break;
                }
                case 27: {
                    this.removeServerSideListeners((ListenerID[])params[0]);
                    break;
                }
                case 28: {
                    result = this.checkEnabled((ListenerID)params[0], (Notification)params[1]);
                    break;
                }
                case 29: {
                    this.sendNotification((ListenerID)params[0], (Notification)params[1]);
                    break;
                }
                case 30: {
                    result = this.server.getDomains();
                    break;
                }
                default: {
                    throw new JmxIllegalArgumentException("jmx_1305", new Object[]{String.valueOf(request.getRequestType()), request.toString()});
                }
            }
            return new ResponseMessage(result, request.getSourceType());
        }
        catch (JMException e) {
            Category.SYS_SERVER.logThrowableT(400, LOCATION, "Exception occurred while processing external JMX request " + request, (Throwable)e);
            return new ExceptionMessage((Throwable)((Object)new RemoteMBeanServerException(e)));
        }
        catch (JMRuntimeException e) {
            Category.SYS_SERVER.logThrowableT(400, LOCATION, "Runtime exception occurred while processing external JMX request " + request, (Throwable)e);
            return new ExceptionMessage((Throwable)((Object)new RemoteMBeanServerException(e)));
        }
    }

    public Boolean checkEnabled(ListenerID id, Notification notification) {
        return this.getMyListenerRegistry().checkEnabled(id, notification);
    }

    public void sendNotification(ListenerID id, Notification notification) {
        this.getMyListenerRegistry().sendNotification(id, notification);
    }

    public void addServerSideListener(ListenerID id, ObjectName observed, NotificationListener listener, ServerSideNotificationFilter filter, MarshalledObject handback) throws InstanceNotFoundException {
        Map map = this.serverListeners;
        synchronized (map) {
            this.server.addNotificationListener(observed, listener, (NotificationFilter)filter, (Object)handback);
            this.serverListeners.put(id, new ListenerRegistrationInfo(observed, listener, (NotificationFilter)filter, (Object)handback));
        }
    }

    public void addServerSideListener(ListenerID id, ObjectName observed, ObjectName listener, ServerSideNotificationFilter filter, MarshalledObject handback) throws InstanceNotFoundException {
        Map map = this.serverListeners;
        synchronized (map) {
            this.server.addNotificationListener(observed, listener, (NotificationFilter)filter, (Object)handback);
            this.serverListeners.put(id, new ListenerRegistrationInfo(observed, listener, (NotificationFilter)filter, (Object)handback));
        }
    }

    public void removeServerSideListeners(ListenerID[] ids) throws JMException {
        if (ids == null) {
            return;
        }
        Map map = this.serverListeners;
        synchronized (map) {
            boolean error = false;
            OperationsException exception = null;
            int i = 0;
            while (i < ids.length) {
                ListenerRegistrationInfo info = (ListenerRegistrationInfo)this.serverListeners.remove(ids[i]);
                if (info == null) {
                    error = true;
                    exception = new ListenerNotFoundException("listener not found, id: " + ids[i]);
                }
                try {
                    if (info.getListener() instanceof ObjectName) {
                        this.server.removeNotificationListener(info.getObserved(), (ObjectName)info.getListener(), info.getFilter(), info.getHandback());
                    } else {
                        this.server.removeNotificationListener(info.getObserved(), (NotificationListener)info.getListener(), info.getFilter(), info.getHandback());
                    }
                }
                catch (ListenerNotFoundException e) {
                    error = true;
                    exception = e;
                }
                catch (InstanceNotFoundException e) {
                    error = true;
                    exception = e;
                }
                ++i;
            }
            if (error) {
                throw exception;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListenerRegistrationInfo {
        private ObjectName observed;
        private Object listener;
        private NotificationFilter filter;
        private Object handback;

        public ListenerRegistrationInfo(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) {
            this.observed = observed;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public ListenerRegistrationInfo(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) {
            this.observed = observed;
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public ObjectName getObserved() {
            return this.observed;
        }

        public Object getListener() {
            return this.listener;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public Object getHandback() {
            return this.handback;
        }
    }
}

