/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.JmxFrame;
import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public final class MBeanServerConnectionSecurityWrapper
implements MBeanServerConnection {
    private final JmxFrame frame;
    private final MBeanServerConnection mbsc;

    public MBeanServerConnectionSecurityWrapper(JmxFrame frame, MBeanServerConnection mbsc) {
        this.frame = frame;
        this.mbsc = mbsc;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.addNotificationListener(name, listener, filter, handback);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws IOException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws IOException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws IOException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        return this.mbsc.createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws IOException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        return this.mbsc.createMBean(className, name, loaderName, params, signature);
    }

    public Object getAttribute(ObjectName name, String attribute) throws IOException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws IOException, InstanceNotFoundException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.getAttributes(name, attributes);
    }

    public String getDefaultDomain() throws IOException {
        this.frame.checkIsAdmin();
        return this.mbsc.getDefaultDomain();
    }

    public Integer getMBeanCount() throws IOException {
        this.frame.checkIsAdmin();
        return this.mbsc.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.getMBeanInfo(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws IOException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        return this.mbsc.getObjectInstance(name);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.invoke(name, operationName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws IOException, InstanceNotFoundException {
        this.frame.checkIsAdmin();
        return this.mbsc.isInstanceOf(name, className);
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        this.frame.checkIsAdmin();
        return this.mbsc.isRegistered(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        this.frame.checkIsAdmin();
        return this.mbsc.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        this.frame.checkIsAdmin();
        return this.mbsc.queryNames(name, query);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.removeNotificationListener(observed, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
        this.frame.checkIsAdmin();
        this.mbsc.removeNotificationListener(observed, listener, filter, handback);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws IOException, AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.frame.checkIsAdmin();
        this.mbsc.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws IOException, InstanceNotFoundException, ReflectionException {
        this.frame.checkIsAdmin();
        return this.mbsc.setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws IOException, InstanceNotFoundException, MBeanRegistrationException {
        this.frame.checkIsAdmin();
        this.mbsc.unregisterMBean(name);
    }

    public String[] getDomains() throws IOException {
        return new String[0];
    }
}

