/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.JmxServiceServerSideFilter;
import com.sap.engine.services.jmx.JmxServiceServerSideListener;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.connector.notification.ListenerID;
import com.sap.engine.services.jmx.connector.notification.ListenerRegistry;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationFilter;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationListener;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxImplementationException;
import com.sap.engine.services.jmx.exception.RemoteMBeanServerException;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class MBeanServerConnectionImpl
implements MBeanServerConnection,
Serializable {
    private final int targetID;
    private final String sourceID;
    private final byte sourceType;
    private final transient ListenerRegistry listenerRegistry;
    private final transient JmxFrame frame;
    private transient Map streamParams;
    private final JmxServiceMessageClient invoker;

    public MBeanServerConnectionImpl(JmxServiceMessageClient invoker, int targetID, JmxFrame frame, Map streamParams, byte sourceType) {
        this.invoker = invoker;
        this.targetID = targetID;
        this.frame = frame;
        this.streamParams = streamParams;
        this.sourceType = sourceType;
        if (frame == null) {
            this.listenerRegistry = null;
            this.sourceID = null;
        } else {
            this.listenerRegistry = frame.getListenerRegistry(targetID);
            this.sourceID = frame.getElementIdAsString();
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectName appLoaderName = null;
        if (this.frame != null) {
            appLoaderName = this.frame.getApplicationClassLoaderName();
        }
        try {
            if (appLoaderName == null) {
                return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(1, new Object[]{className, objectName}));
            }
            return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(2, new Object[]{className, objectName, appLoaderName}));
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(2, new Object[]{className, objectName, loaderName}));
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectName appLoaderName = null;
        if (this.frame != null) {
            appLoaderName = this.frame.getApplicationClassLoaderName();
        }
        try {
            if (appLoaderName == null) {
                return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(3, new Object[]{className, objectName, args, parameters}));
            }
            return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(4, new Object[]{className, objectName, appLoaderName, args, parameters}));
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(4, new Object[]{className, objectName, loaderName, args, parameters}));
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(18, new Object[]{objectName}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.invokeMbsInternal(new RequestMessage(5, new Object[]{objectName, attribute}));
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(16, new Object[]{objectName, attribute}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (InvalidAttributeValueException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return (AttributeList)this.invokeMbsInternal(new RequestMessage(6, new Object[]{objectName, attributes}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return (AttributeList)this.invokeMbsInternal(new RequestMessage(17, new Object[]{objectName, attributes}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            return this.invokeMbsInternal(new RequestMessage(11, new Object[]{objectName, methodName, args, parameters}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public String getDefaultDomain() throws IOException {
        try {
            return (String)this.invokeMbsInternal(new RequestMessage(7, null));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Integer getMBeanCount() throws IOException {
        try {
            return (Integer)this.invokeMbsInternal(new RequestMessage(8, null));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public boolean isRegistered(ObjectName objectname) throws IOException {
        try {
            return (Boolean)this.invokeMbsInternal(new RequestMessage(13, new Object[]{objectname}));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            return (MBeanInfo)this.invokeMbsInternal(new RequestMessage(9, new Object[]{objectName}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.invokeMbsInternal(new RequestMessage(10, new Object[]{objectName}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException, IOException {
        try {
            return (Boolean)this.invokeMbsInternal(new RequestMessage(12, new Object[]{objectName, className}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) throws IOException {
        try {
            return (Set)this.invokeMbsInternal(new RequestMessage(14, new Object[]{patternName, filter}));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) throws IOException {
        try {
            return (Set)this.invokeMbsInternal(new RequestMessage(15, new Object[]{patternName, filter}));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    private Object invokeMbsInternal(RequestMessage request) throws JmxConnectorException, JMException {
        request.setSourceType(this.sourceType);
        ResponseMessage response = this.invoker.invokeMbs(request);
        Object result = response.getResult(this.streamParams);
        if (response.isException()) {
            if (result instanceof JmxConnectorException) {
                ((Throwable)result).fillInStackTrace();
                throw (JmxConnectorException)((Object)result);
            }
            if (result instanceof RemoteMBeanServerException) {
                Throwable cause = ((RemoteMBeanServerException)((Object)result)).getCause();
                if (cause instanceof JMException) {
                    cause.fillInStackTrace();
                    throw (JMException)cause;
                }
                if (cause instanceof JMRuntimeException) {
                    cause.fillInStackTrace();
                    throw (JMRuntimeException)cause;
                }
                throw new JmxConnectorException("jmx_2218", new Object[]{cause.getClass().getName(), response.toString()});
            }
            throw new JmxConnectorException("jmx_2219", new Object[]{result.getClass().getName(), response.toString()});
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null."));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null."));
        }
        ListenerID id = this.listenerRegistry.addNotificationListener(observed, listener, filter, handback);
        if (id == null) return;
        MarshalledObject serverSideHandback = this.getMarshalledHandback(listener, handback);
        ServerSideNotificationListener serverSideListener = this.getServerSideListener(listener, filter, id);
        ServerSideNotificationFilter serverSideFilter = this.getServerSideFilter(filter, id);
        boolean succeded = false;
        try {
            try {
                this.addServerSideListener(id, observed, serverSideListener, serverSideFilter, serverSideHandback);
                return;
            }
            catch (InstanceNotFoundException e) {
                throw e;
            }
            catch (JmxConnectorException e) {
                throw e;
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JmxConnectorException("jmx_1101", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            if (succeded) throw throwable;
            try {
                this.listenerRegistry.removeNotificationListener(observed, listener, filter, handback);
                throw throwable;
            }
            catch (ListenerNotFoundException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private ServerSideNotificationListener getServerSideListener(NotificationListener listener, NotificationFilter filter, ListenerID id) {
        if (listener instanceof ServerSideNotificationListener) {
            return (ServerSideNotificationListener)listener;
        }
        return new JmxServiceServerSideListener(this.sourceID, id);
    }

    private ServerSideNotificationFilter getServerSideFilter(NotificationFilter filter, ListenerID id) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof ServerSideNotificationFilter) {
            return (ServerSideNotificationFilter)filter;
        }
        return new JmxServiceServerSideFilter(this.sourceID, id);
    }

    private MarshalledObject getMarshalledHandback(Object listener, Object handback) throws IOException {
        if (listener instanceof ServerSideNotificationListener || listener instanceof ObjectName) {
            if (handback instanceof MarshalledObject) {
                return (MarshalledObject)handback;
            }
            return new MarshalledObject<Object>(handback);
        }
        return null;
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        ListenerID id = this.listenerRegistry.removeNotificationListener(observed, listener, filter, handback);
        if (id != null) {
            this.removeServerSideListeners(new ListenerID[]{id});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        ListenerID id = null;
        ServerSideNotificationFilter serverSideFilter = null;
        if (filter != null) {
            id = this.listenerRegistry.addNotificationListener(observed, listener, filter, handback);
            if (id == null) {
                throw new JmxImplementationException("jmx_1102");
            }
            serverSideFilter = this.getServerSideFilter(filter, id);
        }
        MarshalledObject serverSideHandback = this.getMarshalledHandback(listener, handback);
        boolean succeded = false;
        try {
            try {
                this.addServerSideListener(id, observed, listener, serverSideFilter, serverSideHandback);
                return;
            }
            catch (InstanceNotFoundException e) {
                throw e;
            }
            catch (JmxConnectorException e) {
                throw e;
            }
            catch (JMRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JmxConnectorException("jmx_1101", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            if (succeded || filter == null) throw throwable;
            try {
                this.listenerRegistry.removeNotificationListener(observed, listener, filter, handback);
                throw throwable;
            }
            catch (ListenerNotFoundException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        ListenerID[] ids = this.listenerRegistry.removeNotificationListener(observed, listener);
        if (ids != null) {
            this.removeServerSideListeners(ids);
        }
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        ListenerID[] ids = this.listenerRegistry.removeNotificationListener(this.targetID, observed, listener);
        if (ids != null) {
            this.removeServerSideListeners(ids);
        }
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (observed == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null"));
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        ListenerID id = this.listenerRegistry.removeNotificationListener(observed, listener, filter, handback);
        if (id != null) {
            this.removeServerSideListeners(new ListenerID[]{id});
        }
    }

    private void addServerSideListener(ListenerID id, ObjectName observed, NotificationListener listener, ServerSideNotificationFilter filter, MarshalledObject handback) throws InstanceNotFoundException, IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(25, new Object[]{id, observed, listener, filter, handback}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    private void addServerSideListener(ListenerID id, ObjectName observed, ObjectName listener, ServerSideNotificationFilter filter, MarshalledObject handback) throws InstanceNotFoundException, IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(26, new Object[]{id, observed, listener, filter, handback}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    private void removeServerSideListeners(ListenerID[] ids) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(27, new Object[]{ids}));
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public Boolean checkEnabled(ListenerID id, Notification notification) throws IOException {
        try {
            return (Boolean)this.invokeMbsInternal(new RequestMessage(28, new Object[]{id, notification}));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public void sendNotification(ListenerID id, Notification notification) throws IOException {
        try {
            this.invokeMbsInternal(new RequestMessage(29, new Object[]{id, notification}));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }

    public String[] getDomains() throws IOException {
        try {
            return (String[])this.invokeMbsInternal(new RequestMessage(30, null));
        }
        catch (JmxConnectorException e) {
            throw e;
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmxConnectorException("jmx_1101", e);
        }
    }
}

