/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.DefaultClassLoader;
import com.sap.engine.services.jmx.JmxClientFactory;
import com.sap.engine.services.jmx.JmxServiceConnectorClient;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.connector.notification.ListenerID;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationFilter;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.tc.logging.Location;
import java.io.IOException;
import javax.management.Notification;

public class JmxServiceServerSideFilter
implements ServerSideNotificationFilter {
    private String clusterID;
    private ListenerID id;
    private transient JmxServiceMessageClient msgClient;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$JmxServiceServerSideFilter == null ? (class$com$sap$engine$services$jmx$JmxServiceServerSideFilter = JmxServiceServerSideFilter.class$("com.sap.engine.services.jmx.JmxServiceServerSideFilter")) : class$com$sap$engine$services$jmx$JmxServiceServerSideFilter));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$JmxServiceServerSideFilter;

    public JmxServiceServerSideFilter(String clusterID, ListenerID id) {
        this.clusterID = clusterID;
        this.id = id;
    }

    public boolean isNotificationEnabled(Notification notification) {
        return this.checkEnabled(this.id, notification);
    }

    private boolean checkEnabled(ListenerID id, Notification notification) {
        Object result;
        ResponseMessage response;
        try {
            response = this.getMessageClient().invokeMbs(new RequestMessage(28, new Object[]{id, notification}));
        }
        catch (IOException e) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "checkEnabled(ListenerID, Notification)", "Unable to invoke notification filter for a remote JMX notification listener. Sending the notification failed. " + notification, e);
            return false;
        }
        try {
            result = response.getResult(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
        }
        catch (JmxConnectorException e) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "checkEnabled(ListenerID, Notification)", "Unable to invoke notification filter for a remote JMX notification listener. Sending the notification failed. " + notification, (Throwable)((Object)e));
            return false;
        }
        if (response.isException()) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "checkEnabled(ListenerID, Notification)", "Unable to invoke notification filter for a remote JMX notification listener. Sending the notification failed. " + notification, (Throwable)result);
            return false;
        }
        return (Boolean)result;
    }

    private JmxServiceMessageClient getMessageClient() throws IOException {
        if (this.msgClient == null) {
            JmxServiceConnectorClient connector = (JmxServiceConnectorClient)JmxClientFactory.getJmxClient().getConnector("service:jmx:com.sap.engine.services.jmx.connector.n2n:" + this.clusterID);
            this.msgClient = connector.getMessageClient();
        }
        return this.msgClient;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

