/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.RuntimeProperties;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.UserStoreActivationListener;
import com.sap.engine.services.jmx.connector.p4.P4ConnectorServer;
import com.sap.engine.services.jmx.connector.p4.P4ConnectorServerImpl;
import com.sap.engine.services.jmx.exception.JmxImplementationException;
import com.sap.engine.services.jmx.exception.JmxSecurityException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.management.MBeanPermission;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JmxServerFrame
extends JmxFrame
implements ApplicationServiceFrame {
    private static final String SYSTEM_LOADER_DETECTOR = ":";
    private static final String SECURITY_INTERFACE_NAME = "security";
    private ThreadSystem threadSystem = null;
    private SecurityRole admin = null;
    private SecurityContext secCtx = null;
    private UserStoreActivationListener userStoreListener = null;
    private P4ConnectorServer p4ConnectorServer = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$JmxServerFrame == null ? (class$com$sap$engine$services$jmx$JmxServerFrame = JmxServerFrame.class$("com.sap.engine.services.jmx.JmxServerFrame")) : class$com$sap$engine$services$jmx$JmxServerFrame));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$JmxServerFrame;

    public void start(ApplicationServiceContext servCtx) throws ServiceException {
        this.initFrame(servCtx, servCtx.getClusterContext(), servCtx.getContainerContext());
        this.threadSystem = this.getServiceContext().getCoreContext().getThreadSystem();
        this.secCtx = (SecurityContext)this.getContainerContext().getObjectRegistry().getProvidedInterface(SECURITY_INTERFACE_NAME);
        this.resetAdminRole();
        this.userStoreListener = new UserStoreActivationListener(this);
        this.secCtx.getUserStoreContext().registerListener(this.userStoreListener);
        this.startMbs();
        this.registerClientInterface();
    }

    public void stop() throws ServiceRuntimeException {
        this.unregisterClientInterface();
        this.resetFrame();
        try {
            this.secCtx.getUserStoreContext().unregisterListener(this.userStoreListener);
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable(300, LOCATION, "stop()", e);
        }
        this.admin = null;
    }

    void checkIsAdmin() {
        this.checkMBeanPermissionInternal(null, null, null, null, null);
    }

    void checkMBeanPermission(String className, String member, ObjectName objectName, String action) {
        this.checkMBeanPermissionInternal(null, className, member, objectName, action);
    }

    void checkMBeanPermissionInternal(final Class clazz, String className, String member, ObjectName objectName, String action) {
        if (this.threadSystem.getThreadContext() != null) {
            SecurityRole adminRole = this.getAdminRole();
            if (adminRole == null) {
                throw new JmxSecurityException("jmx_1702", new Object[]{RuntimeProperties.get(2), "administrators"});
            }
            if (!adminRole.isCallerInRole()) {
                if (action != null && RuntimeProperties.get(4) != null) {
                    try {
                        AccessController.checkPermission(new MBeanPermission(className, member, objectName, action));
                        if (clazz != null) {
                            MBeanTrustPermission perm = new MBeanTrustPermission("register");
                            ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return clazz.getProtectionDomain();
                                }
                            });
                            if (!pd.implies(perm)) {
                                throw new SecurityException("access denied (" + perm.getClass().getName() + " " + perm.getName() + ")");
                            }
                        }
                        return;
                    }
                    catch (AccessControlException e) {
                        throw new JmxSecurityException("jmx_1701", new Object[]{RuntimeProperties.get(2), adminRole.getName()}, e);
                    }
                }
                throw new JmxSecurityException("jmx_1701", new Object[]{RuntimeProperties.get(2), adminRole.getName()});
            }
        }
    }

    void checkMBeanTrustPermission(Class clazz, String member, ObjectName objectName, String action) {
        this.checkMBeanPermissionInternal(clazz, clazz != null ? clazz.getName() : null, member, objectName, action);
    }

    boolean isServerElement() {
        return true;
    }

    ObjectName getApplicationClassLoaderName() {
        String loaderName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader instanceof ReferencedLoader && (loaderName = ((ReferencedLoader)loader).getName()) != null && loaderName.indexOf(SYSTEM_LOADER_DETECTOR) < 0) {
            try {
                return ObjectNameFactory.getNameForClassLoader((String)loaderName, null, null);
            }
            catch (MalformedObjectNameException e) {
                throw new JmxImplementationException("jmx_1101", e);
            }
        }
        return null;
    }

    private synchronized void initNaming() {
        try {
            InitialContext initCtx = new InitialContext();
            P4ConnectorServer server = this.p4ConnectorServer;
            if (server == null) {
                return;
            }
            initCtx.rebind("jmx_p4_connector_server", (Object)server);
        }
        catch (NamingException e) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "initNaming(boolean)", "Binding RMI-P4 connector in JNDI failed. Remote administration of this server node will not be possible. Please check the attached exception for the cause of this failure.", e);
        }
    }

    private synchronized void resetNaming() {
        try {
            InitialContext initCtx = new InitialContext();
            initCtx.unbind("jmx_p4_connector_server");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected void registerClientInterface() throws ServiceException {
        super.registerClientInterface();
        try {
            this.p4ConnectorServer = new P4ConnectorServerImpl(this.getOuterChainInvoker());
        }
        catch (RemoteException e) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "registerClientInterface()", "Creating RMI-P4 connector failed. Remote administration of this server node will not be possible. Please check the attached exception for the cause of this failure.", e);
        }
        this.initNaming();
    }

    protected void unregisterClientInterface() {
        super.unregisterClientInterface();
        this.resetNaming();
        this.p4ConnectorServer = null;
    }

    private SecurityRole getAdminRole() {
        SecurityRole adminRole = this.admin;
        if (adminRole == null) {
            this.admin = adminRole = this.secCtx.getAuthorizationContext().getSecurityRoleContext().getSecurityRole("administrators");
        }
        return adminRole;
    }

    protected void resetAdminRole() {
        this.admin = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

