/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.container.ServiceContainerContext;
import com.sap.engine.services.jmx.ClusterInterceptor;
import com.sap.engine.services.jmx.CompletionInterceptor;
import com.sap.engine.services.jmx.ContainerEventListenerProxy;
import com.sap.engine.services.jmx.JmxClientFactory;
import com.sap.engine.services.jmx.JmxServiceConnectorServer;
import com.sap.engine.services.jmx.JmxServiceManagementInterfaceImpl;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.JmxServicePropertyManager;
import com.sap.engine.services.jmx.MBeanServerInterceptorInvoker;
import com.sap.engine.services.jmx.MBeanServerSecurityWrapper;
import com.sap.engine.services.jmx.ObjectStreamFactory;
import com.sap.engine.services.jmx.RedirectInterceptor;
import com.sap.engine.services.jmx.ShellInterfaceEventListener;
import com.sap.engine.services.jmx.connector.n2n.ConnectorFactory;
import com.sap.engine.services.jmx.connector.notification.ListenerRegistry;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalStateException;
import com.sap.engine.services.jmx.exception.JmxServiceStartupException;
import com.sap.engine.services.jmx.server.NotificationQueue;
import com.sap.engine.services.jmx.timer.TimerImpl;
import com.sap.engine.services.jmx.timer.j2ee.TimerFactory;
import com.sap.engine.services.jmx_notification.JmxNotificationFrame;
import com.sap.engine.services.jmx_notification.MBeanServerClusterDelegate;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.provider.ProviderInterceptor;
import com.sap.pj.jmx.server.interceptor.InterceptorChainBuilder;
import com.sap.pj.jmx.server.interceptor.InvalidInterceptorException;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptorChainMBean;
import com.sap.pj.jmx.timer.Timer;
import com.sap.pj.jmx.timer.j2ee.TimerFactoryImpl;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class JmxFrame
implements ClusterEventListener {
    private static final String TIMEOUT_SERVICE_NAME = "timeout";
    private static final String JMX_NOTIFICATION_SERVICE_NAME = "jmx_notification";
    private String serviceName;
    private ServiceContext servCtx;
    private ClusterContext clusCtx;
    private ServiceContainerContext contCtx;
    private JmxServicePropertyManager propMgr;
    private String systemName;
    private String elementID;
    private MBeanServer innerMbs;
    private MBeanServer outerMbs;
    private JmxServiceConnectorServer connector;
    private JmxServiceMessageClient outerChainInvoker;
    private Map clientListenerRegistries;
    private Map listenerIndex;
    private JmxServiceManagementInterfaceImpl mgmtInterface;
    private ContainerEventListenerProxy contEventListenerProxy;
    private final Object elementsLock = new Object();
    private HashMap elements = new HashMap(10, 0.75f);
    static /* synthetic */ Class class$com$sap$engine$services$jmx$server$AsynchronousProxyListenerFactory;
    static /* synthetic */ Class class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean;
    static /* synthetic */ Class class$com$sap$pj$jmx$timer$j2ee$TimerFactoryImpl;
    static /* synthetic */ Class class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor;

    protected void initFrame(ServiceContext servCtx, ClusterContext clusCtx, ServiceContainerContext contCtx) throws JmxServiceStartupException {
        ObjectStreamFactory.initialize(this.isServerElement());
        this.serviceName = servCtx.getServiceState().getServiceName();
        this.systemName = SystemProperties.getProperty("SAPSYSTEMNAME", clusCtx.getClusterMonitor().getClusterName());
        this.elementID = String.valueOf(clusCtx.getClusterMonitor().getCurrentParticipant().getClusterId());
        try {
            this.propMgr = new JmxServicePropertyManager(servCtx.getServiceState().getProperties());
        }
        catch (RuntimeException e) {
            throw new JmxServiceStartupException("jmx_2004", (Throwable)e);
        }
        this.clientListenerRegistries = new HashMap();
        this.listenerIndex = new HashMap();
        this.servCtx = servCtx;
        this.clusCtx = clusCtx;
        this.contCtx = contCtx;
        this.initTimerFactory();
        try {
            servCtx.getServiceState().registerClusterEventListener(this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            new JmxServiceStartupException("jmx_2006", (Throwable)((Object)e));
        }
        this.setDebugState(clusCtx.getClusterMonitor().getParticipants());
        this.contEventListenerProxy = new ContainerEventListenerProxy(this);
    }

    protected void resetFrame() throws ServiceRuntimeException {
        this.servCtx.getServiceState().unregisterContainerEventListener();
        this.servCtx.getServiceState().unregisterClusterEventListener();
        this.clientListenerRegistries = null;
        this.contEventListenerProxy = null;
        this.mgmtInterface = null;
        this.listenerIndex = null;
        this.outerChainInvoker = null;
        this.connector = null;
        this.outerMbs = null;
        this.innerMbs = null;
        this.servCtx = null;
        this.clusCtx = null;
        this.contCtx = null;
        this.propMgr = null;
        this.systemName = null;
        this.elementID = null;
        this.serviceName = null;
    }

    protected void startMbs() throws ServiceException {
        ClusterInterceptor headInterceptor;
        CompletionInterceptor outerEntryPoint;
        MBeanServerInterceptorChainMBean outerChain;
        NotificationQueue.init(this.getServiceContext().getCoreContext().getThreadSystem(), this.getPropertyManager(), this.getManagementInterfaceImpl());
        SystemProperties.setProperty("com.sap.pj.jmx.ProxyListenerFactory", (class$com$sap$engine$services$jmx$server$AsynchronousProxyListenerFactory == null ? (class$com$sap$engine$services$jmx$server$AsynchronousProxyListenerFactory = JmxFrame.class$("com.sap.engine.services.jmx.server.AsynchronousProxyListenerFactory")) : class$com$sap$engine$services$jmx$server$AsynchronousProxyListenerFactory).getName());
        InterceptorChainBuilder builder = new InterceptorChainBuilder(false);
        MBeanServerClusterDelegate clusterDelegate = ((JmxNotificationFrame)this.getContainerContext().getObjectRegistry().getServiceInterface(JMX_NOTIFICATION_SERVICE_NAME)).getClusterDelegate();
        MBeanServer oMbs = builder.newMBeanServer(this.getPropertyManager().getDefaultDomain(), null, (MBeanServerDelegate)clusterDelegate);
        try {
            ObjectName chainName = new ObjectName("JMImplementation:type=MBeanServerInterceptorChain");
            outerChain = (MBeanServerInterceptorChainMBean)MBeanServerInvocationHandler.newProxyInstance(oMbs, chainName, class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean == null ? (class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean = JmxFrame.class$("com.sap.pj.jmx.server.interceptor.MBeanServerInterceptorChainMBean")) : class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean, false);
            ObjectName compIName = this.getInterceptorName("ParameterCompletionInterceptor");
            CompletionInterceptor compI = new CompletionInterceptor(this);
            outerChain.addInterceptor((MBeanServerInterceptor)compI, compIName);
            outerEntryPoint = compI;
            ObjectName pion = this.getInterceptorName("ProviderInterceptor");
            ProviderInterceptor pi = new ProviderInterceptor(this.getPropertyManager().getDefaultDomain());
            outerChain.addInterceptor((MBeanServerInterceptor)pi, pion);
            outerEntryPoint = pi;
            ObjectName clusIName = this.getInterceptorName("ClusterInterceptor");
            ClusterInterceptor clusI = new ClusterInterceptor(this);
            outerChain.addInterceptor((MBeanServerInterceptor)clusI, clusIName);
            headInterceptor = clusI;
        }
        catch (InvalidInterceptorException e) {
            throw new JmxServiceStartupException("jmx_2002", (Throwable)e);
        }
        catch (JMException e) {
            throw new JmxServiceStartupException("jmx_2002", (Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw new JmxServiceStartupException("jmx_2002", e.getUndeclaredThrowable());
        }
        catch (RuntimeException e) {
            throw new JmxServiceStartupException("jmx_2002", (Throwable)e);
        }
        MBeanServer iMbs = builder.newMBeanServer(this.getPropertyManager().getDefaultDomain(), null, builder.newMBeanServerDelegate());
        try {
            this.connector = new JmxServiceConnectorServer(this);
            iMbs.registerMBean(this.connector, null);
            ObjectName chainName = new ObjectName("JMImplementation:type=MBeanServerInterceptorChain");
            MBeanServerInterceptorChainMBean innerChain = (MBeanServerInterceptorChainMBean)MBeanServerInvocationHandler.newProxyInstance(iMbs, chainName, class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean == null ? (class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean = JmxFrame.class$("com.sap.pj.jmx.server.interceptor.MBeanServerInterceptorChainMBean")) : class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptorChainMBean, false);
            ObjectName dummyIName = this.getInterceptorName("RedirectInterceptor");
            RedirectInterceptor dummyI = new RedirectInterceptor(outerEntryPoint);
            innerChain.addInterceptor((MBeanServerInterceptor)dummyI, dummyIName);
            innerChain.start();
        }
        catch (InvalidInterceptorException e) {
            throw new JmxServiceStartupException("jmx_2003", (Throwable)e);
        }
        catch (JMException e) {
            throw new JmxServiceStartupException("jmx_2003", (Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw new JmxServiceStartupException("jmx_2003", e.getUndeclaredThrowable());
        }
        catch (RuntimeException e) {
            throw new JmxServiceStartupException("jmx_2003", (Throwable)e);
        }
        outerChain.start();
        this.innerMbs = new MBeanServerSecurityWrapper(this, iMbs);
        this.outerMbs = oMbs;
        this.outerChainInvoker = new MBeanServerInterceptorInvoker(headInterceptor, this.getElementIdAsString());
        try {
            this.registerServerMBeans();
        }
        catch (JMException e) {
            throw new JmxServiceStartupException("jmx_2005", (Throwable)e);
        }
    }

    private void registerServerMBeans() throws JMException {
        NotificationQueue.registerMBean(this.getOuterMBeanServer());
        this.registerTimerFactoryMBean();
    }

    private void registerTimerFactoryMBean() throws JMException {
        Object timeout = this.getContainerContext().getObjectRegistry().getServiceInterface(TIMEOUT_SERVICE_NAME);
        if (timeout instanceof TimeoutManager) {
            TimerFactory timerFactory = new TimerFactory((TimeoutManager)timeout);
            MBeanServer mbs = this.getOuterMBeanServer();
            ObjectName name = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EETimerFactory", (String)"TimerFactory", null, null);
            mbs.registerMBean(timerFactory, name);
        }
    }

    protected void registerClientInterface() throws ServiceException {
        this.getServiceContext().getServiceState().registerManagementInterface(this.getManagementInterfaceImpl());
        this.getContainerContext().getObjectRegistry().registerInterface(this.outerMbs);
        com.sap.engine.services.jmx.connector.local.ConnectorFactory.init(this);
        ConnectorFactory.init(this);
        JmxClientFactory.setFrame(this);
        this.getContainerEventListenerProxy().addContainerEventListener(new ShellInterfaceEventListener(this));
    }

    protected void unregisterClientInterface() {
        this.getContainerEventListenerProxy().beginServiceStop(this.serviceName);
        JmxClientFactory.setFrame(null);
        com.sap.engine.services.jmx.connector.local.ConnectorFactory.init(null);
        ConnectorFactory.init(null);
        this.getContainerContext().getObjectRegistry().unregisterInterface();
    }

    private void initTimerFactory() throws JmxServiceStartupException {
        Object timeout = this.getContainerContext().getObjectRegistry().getServiceInterface(TIMEOUT_SERVICE_NAME);
        if (!(timeout instanceof TimeoutManager)) {
            throw new JmxServiceStartupException("jmx_2001");
        }
        TimerFactoryImpl.init((Timer)new TimerImpl((TimeoutManager)timeout));
        SystemProperties.setProperty("com.sap.pj.jmx.TimerFactory", (class$com$sap$pj$jmx$timer$j2ee$TimerFactoryImpl == null ? (class$com$sap$pj$jmx$timer$j2ee$TimerFactoryImpl = JmxFrame.class$("com.sap.pj.jmx.timer.j2ee.TimerFactoryImpl")) : class$com$sap$pj$jmx$timer$j2ee$TimerFactoryImpl).getName());
    }

    private ObjectName getInterceptorName(String name) throws MalformedObjectNameException {
        return ObjectNameFactory.getNameForServerChildPerNode((String)(class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor == null ? (class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor = JmxFrame.class$("com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor")) : class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor).getName(), (String)name, (String)this.getElementIdAsString(), (String)this.getSystemName());
    }

    ServiceContext getServiceContext() {
        ServiceContext context = this.servCtx;
        if (context == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "ServiceContext"});
        }
        return context;
    }

    ClusterContext getClusterContext() {
        ClusterContext context = this.clusCtx;
        if (context == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "ClusterContext"});
        }
        return context;
    }

    ServiceContainerContext getContainerContext() {
        ServiceContainerContext context = this.contCtx;
        if (context == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "ContainerContext"});
        }
        return context;
    }

    JmxServicePropertyManager getPropertyManager() {
        JmxServicePropertyManager props = this.propMgr;
        if (props == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "PropertyManager"});
        }
        return props;
    }

    JmxServiceManagementInterfaceImpl getManagementInterfaceImpl() {
        JmxServiceManagementInterfaceImpl mgmtIf = this.mgmtInterface;
        if (mgmtIf == null) {
            JmxFrame jmxFrame = this;
            synchronized (jmxFrame) {
                if (this.mgmtInterface == null) {
                    this.mgmtInterface = new JmxServiceManagementInterfaceImpl();
                }
                JmxServiceManagementInterfaceImpl jmxServiceManagementInterfaceImpl = this.mgmtInterface;
                return jmxServiceManagementInterfaceImpl;
            }
        }
        return mgmtIf;
    }

    private ContainerEventListenerProxy getContainerEventListenerProxy() {
        ContainerEventListenerProxy cep = this.contEventListenerProxy;
        if (cep == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "containerEventListenerProxy"});
        }
        return cep;
    }

    MBeanServer getInnerMBeanServer() {
        MBeanServer mbs = this.innerMbs;
        if (mbs == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "innerMBeanServer"});
        }
        return mbs;
    }

    MBeanServer getOuterMBeanServer() {
        MBeanServer mbs = this.outerMbs;
        if (mbs == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "outerMBeanServer"});
        }
        return mbs;
    }

    JmxServiceConnectorServer getConnectorServer() {
        JmxServiceConnectorServer conn = this.connector;
        if (conn == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "JmxServiceConnectorServer"});
        }
        return conn;
    }

    JmxServiceMessageClient getOuterChainInvoker() {
        JmxServiceMessageClient invoker = this.outerChainInvoker;
        if (invoker == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "outerChainInvoker"});
        }
        return invoker;
    }

    String getSystemName() {
        String name = this.systemName;
        if (name == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "systemName"});
        }
        return name;
    }

    String getElementIdAsString() {
        String id = this.elementID;
        if (id == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "elementID"});
        }
        return id;
    }

    abstract boolean isServerElement();

    abstract void checkIsAdmin();

    void checkMBeanPermission(String className, String member, ObjectName objectName, String action) {
    }

    void checkMBeanTrustPermission(Class clazz, String member, ObjectName objectName, String action) {
    }

    abstract ObjectName getApplicationClassLoaderName();

    ListenerRegistry getListenerRegistry(int targetID) {
        Map map = this.clientListenerRegistries;
        synchronized (map) {
            if (this.clientListenerRegistries == null) {
                throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "clientListenerRegistries"});
            }
            ListenerRegistry clientRegistry = (ListenerRegistry)this.clientListenerRegistries.get(String.valueOf(targetID));
            if (clientRegistry == null) {
                clientRegistry = new ListenerRegistry(this.listenerIndex);
                this.clientListenerRegistries.put(clientRegistry, String.valueOf(targetID));
            }
            ListenerRegistry listenerRegistry = clientRegistry;
            return listenerRegistry;
        }
    }

    Map getListenerIndex() {
        Map index = this.listenerIndex;
        if (index == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxFrame", "listenerIndex"});
        }
        return index;
    }

    public void elementJoin(ClusterElement element) {
        this.setDebugState(element);
    }

    public void elementLoss(ClusterElement element) {
        this.removeElement(element);
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        this.setDebugState(element);
    }

    private void removeElement(ClusterElement element) {
        Object object = this.elementsLock;
        synchronized (object) {
            HashMap newEls = new HashMap(this.elements);
            newEls.remove(String.valueOf(element));
            this.elements = newEls;
        }
    }

    private void setDebugState(ClusterElement element) {
        Object object = this.elementsLock;
        synchronized (object) {
            HashMap<String, Boolean> newEls = new HashMap<String, Boolean>(this.elements);
            newEls.put(String.valueOf(element.getClusterId()), element.getState() == 7 ? Boolean.TRUE : Boolean.FALSE);
            this.elements = newEls;
        }
    }

    private void setDebugState(ClusterElement[] elementsToAdd) {
        if (elementsToAdd == null) {
            return;
        }
        Object object = this.elementsLock;
        synchronized (object) {
            HashMap<String, Boolean> newEls = new HashMap<String, Boolean>(this.elements);
            int i = 0;
            while (i < elementsToAdd.length) {
                newEls.put(String.valueOf(elementsToAdd[i].getClusterId()), elementsToAdd[i].getState() == 7 ? Boolean.TRUE : Boolean.FALSE);
                ++i;
            }
            this.elements = newEls;
        }
    }

    private boolean isInDebugState(String element) {
        HashMap cEls = this.elements;
        Boolean result = (Boolean)cEls.get(element);
        return result == null ? false : result;
    }

    private boolean isCurrentInDebugState() {
        return this.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 7;
    }

    MultipleAnswer sendAndWaitForAnswer(int groupID, byte nodeType, int messageType, byte[] body, int offset, int length, long timeout) throws ClusterException, JmxConnectorException {
        if (this.isCurrentInDebugState()) {
            throw new JmxConnectorException("jmx_2234", new Object[]{String.valueOf(groupID)});
        }
        return this.getClusterContext().getMessageContext().sendAndWaitForAnswer(groupID, nodeType, messageType, body, offset, length, timeout);
    }

    MessageAnswer sendAndWaitForAnswer(int clusterID, int messageType, byte[] body, int offset, int lenght, long timeout) throws ClusterException, JmxConnectorException {
        if (this.isCurrentInDebugState()) {
            throw new JmxConnectorException("jmx_2234", new Object[]{String.valueOf(clusterID)});
        }
        if (this.isInDebugState(String.valueOf(clusterID))) {
            throw new JmxConnectorException("jmx_2233", new Object[]{String.valueOf(clusterID)});
        }
        return this.getClusterContext().getMessageContext().sendAndWaitForAnswer(clusterID, messageType, body, offset, lenght, timeout);
    }

    void send(int groupID, byte nodeType, int messageType, byte[] body, int offset, int lenght) throws ClusterException, JmxConnectorException {
        if (this.isCurrentInDebugState()) {
            throw new JmxConnectorException("jmx_2234", new Object[]{String.valueOf(groupID)});
        }
        this.getClusterContext().getMessageContext().send(groupID, nodeType, messageType, body, offset, lenght);
    }

    void send(int clusterID, int messageType, byte[] body, int offset, int length) throws ClusterException, JmxConnectorException {
        if (this.isCurrentInDebugState()) {
            throw new JmxConnectorException("jmx_2234", new Object[]{String.valueOf(clusterID)});
        }
        if (this.isInDebugState(String.valueOf(clusterID))) {
            throw new JmxConnectorException("jmx_2233", new Object[]{String.valueOf(clusterID)});
        }
        this.getClusterContext().getMessageContext().send(clusterID, messageType, body, offset, length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

