/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceConnectorClient;
import com.sap.engine.services.jmx.LocalConnectorClient;
import com.sap.engine.services.jmx.client.JmxClient;
import com.sap.engine.services.jmx.client.JmxConnector;
import com.sap.engine.services.jmx.connector.p4.P4ConnectorClient;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;

class JmxClientImpl
implements JmxClient {
    private JmxFrame frame;
    private LocalConnectorClient localClient;
    private final Map clients = new HashMap();

    JmxClientImpl() {
    }

    void setFrame(JmxFrame frame) {
        this.frame = frame;
    }

    public JmxConnector getConnector(String address) throws JmxConnectorException {
        return this.getConnector(address, null);
    }

    public JmxConnector getConnector(String address, Hashtable props) throws JmxConnectorException {
        String connectorAddress;
        if (address == null) {
            throw new JmxIllegalArgumentException("jmx_1303");
        }
        if (!address.startsWith("service:jmx:")) {
            throw new JmxIllegalArgumentException("jmx_1302", new Object[]{address, "service:jmx:"});
        }
        String protocolName = address;
        int delimPos = protocolName.lastIndexOf(":");
        if (delimPos < 0) {
            connectorAddress = null;
        } else {
            connectorAddress = protocolName.substring(delimPos + 1);
            protocolName = protocolName.substring(0, delimPos + 1);
        }
        if (protocolName.equals("service:jmx:com.sap.engine.services.jmx.connector.n2n:")) {
            return this.getConnectorClient(String.valueOf(connectorAddress));
        }
        if (protocolName.equals("service:jmx:com.sap.engine.services.jmx.connector.local:")) {
            if (this.localClient == null) {
                this.localClient = new LocalConnectorClient(this.frame);
            }
            return this.localClient;
        }
        if (protocolName.equals("service:jmx:com.sap.engine.services.jmx.connector.p4:")) {
            return new P4ConnectorClient(props);
        }
        throw new JmxConnectorException("jmx_2205", new Object[]{protocolName, address});
    }

    public MBeanServerConnection getMBeanServerConnection(String address) throws JmxConnectorException {
        return this.getConnector(address).getMBeanServerConnection();
    }

    public MBeanServerConnection getMBeanServerConnection(String address, Hashtable props) throws JmxConnectorException {
        return this.getConnector(address, props).getMBeanServerConnection();
    }

    private JmxServiceConnectorClient getConnectorClient(String targetID) throws JmxConnectorException {
        Map map = this.clients;
        synchronized (map) {
            JmxServiceConnectorClient client = (JmxServiceConnectorClient)this.clients.get(targetID);
            if (client == null) {
                JmxFrame theFrame = this.frame;
                if (theFrame == null) {
                    throw new JmxConnectorException("jmx_2206");
                }
                client = new JmxServiceConnectorClient(targetID, theFrame, new Hashtable(2));
                this.clients.put(targetID, client);
            }
            JmxServiceConnectorClient jmxServiceConnectorClient = client;
            return jmxServiceConnectorClient;
        }
    }

    public MBeanServerConnection getMBeanServerConnection(String address, ClassLoader classLoader) throws JmxConnectorException {
        return this.getConnector(address).getMBeanServerConnection(classLoader);
    }

    public MBeanServerConnection getMBeanServerConnection(String address, Hashtable props, ClassLoader classLoader) throws JmxConnectorException {
        return this.getConnector(address, props).getMBeanServerConnection(classLoader);
    }
}

