/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.services.jmx.JmxFrame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ContainerEventListenerProxy
implements ContainerEventListener {
    private static final String SHELL_INTERFACE_NAME = "shell";
    private final List listeners = new ArrayList();
    private final JmxFrame frame;

    public ContainerEventListenerProxy(JmxFrame frame) {
        this.frame = frame;
        int mask = 192;
        HashSet<String> names = new HashSet<String>(1);
        names.add(SHELL_INTERFACE_NAME);
        frame.getServiceContext().getServiceState().registerContainerEventListener(mask, names, this);
    }

    public void containerStarted() {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.containerStarted();
            }
        }
    }

    public void beginContainerStop() {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.beginContainerStop();
            }
        }
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.serviceStarted(serviceName, serviceInterface);
            }
        }
    }

    public void serviceNotStarted(String serviceName) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.serviceNotStarted(serviceName);
            }
        }
    }

    public void beginServiceStop(String serviceName) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.beginServiceStop(serviceName);
            }
        }
    }

    public void serviceStopped(String serviceName) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.serviceStopped(serviceName);
            }
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.interfaceAvailable(interfaceName, interfaceImpl);
            }
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.interfaceNotAvailable(interfaceName);
            }
        }
    }

    public void markForShutdown(long time) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ContainerEventListener listener = (ContainerEventListener)iter.next();
                if (listener == null) continue;
                listener.markForShutdown(time);
            }
        }
    }

    public boolean setServiceProperty(String key, String value) {
        return this.frame.getPropertyManager().setServiceProperty(key, value);
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return this.frame.getPropertyManager().setServiceProperties(serviceProperties);
    }

    public void addContainerEventListener(ContainerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public void removeContainerEventListener(ContainerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                if (iter.next() != listener) continue;
                iter.remove();
            }
        }
    }
}

