/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.CompletionInterceptorMBean;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.ObjectNameCache;
import com.sap.engine.services.jmx.exception.JmxImplementationException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.pj.jmx.introspect.Utilities;
import com.sap.pj.jmx.server.interceptor.InvocationContext;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.loading.ClassLoaderRepository;

public final class CompletionInterceptor
implements MBeanServerInterceptor,
CompletionInterceptorMBean,
NotificationEmitter {
    static final String NAME = "ParameterCompletionInterceptor";
    private final ObjectNameCache objectNameCache;
    private MBeanServerInterceptor next = null;
    private final JmxFrame frame;
    private final String systemName;
    private final String nodeID;
    private final String defaultDomain;

    public CompletionInterceptor(JmxFrame frame) {
        this.frame = frame;
        this.nodeID = frame.getElementIdAsString();
        this.systemName = frame.getSystemName();
        this.defaultDomain = frame.getPropertyManager().getDefaultDomain();
        this.objectNameCache = new ObjectNameCache(frame, this);
    }

    public String getType() {
        return NAME;
    }

    public ObjectName replaceEmptyKeyValues(ObjectName name) {
        if (name == null) {
            return name;
        }
        boolean updateClusterKey = "\"\"".equals(name.getKeyProperty("SAP_J2EECluster"));
        boolean updateClusterNodeKey = "\"\"".equals(name.getKeyProperty("SAP_J2EEClusterNode"));
        if (!updateClusterKey && !updateClusterNodeKey) {
            return name;
        }
        ObjectName newName = this.objectNameCache.lookup(name);
        if (newName != null) {
            return newName;
        }
        Hashtable<String, String> newTable = name.getKeyPropertyList();
        if (updateClusterKey) {
            newTable.put("SAP_J2EECluster", this.systemName);
        }
        if (updateClusterNodeKey) {
            newTable.put("SAP_J2EEClusterNode", this.nodeID);
        }
        try {
            String domainName = name.getDomain();
            if (domainName == null || domainName.length() == 0) {
                domainName = this.defaultDomain;
            }
            if (name.isPropertyPattern()) {
                StringBuffer sb = new StringBuffer();
                sb.append(domainName).append(':');
                sb.append('*');
                Enumeration<String> e = newTable.keys();
                while (e.hasMoreElements()) {
                    sb.append(',');
                    String key = e.nextElement();
                    sb.append(key);
                    sb.append('=');
                    sb.append(newTable.get(key));
                }
                newName = new ObjectName(sb.toString());
            } else {
                newName = new ObjectName(domainName, newTable);
            }
            this.objectNameCache.add(name, newName);
            return newName;
        }
        catch (MalformedObjectNameException e) {
            throw new JmxImplementationException("jmx_1101", e);
        }
    }

    public void addNotificationListener(InvocationContext context, ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.next.addNotificationListener(context, this.replaceEmptyKeyValues(name), listener, filter, handback);
    }

    public void addNotificationListener(InvocationContext context, ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.next.addNotificationListener(context, this.replaceEmptyKeyValues(name), this.replaceEmptyKeyValues(listener), filter, handback);
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, ReflectionException {
        return this.createMBean(context, className, name, null, null);
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, Object[] params, String[] signature) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        try {
            return this.createMBean(context, className, name, null, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxImplementationException("jmx_1101", e);
        }
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(context, className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader loader = this.getClassLoader(context, loaderName);
        Object object = this.instantiate(className, loader, params, signature);
        return this.next.registerMBean(context, object, this.replaceEmptyKeyValues(name));
    }

    public ObjectInputStream deserialize(InvocationContext context, ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.next.deserialize(context, this.replaceEmptyKeyValues(name), data);
    }

    public ObjectInputStream deserialize(InvocationContext context, String className, byte[] data) throws OperationsException, ReflectionException {
        return this.next.deserialize(context, className, data);
    }

    public ObjectInputStream deserialize(InvocationContext context, String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException, InstanceNotFoundException {
        return this.next.deserialize(context, className, this.replaceEmptyKeyValues(loaderName), data);
    }

    public Object getAttribute(InvocationContext context, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.next.getAttribute(context, this.replaceEmptyKeyValues(name), attribute);
    }

    public AttributeList getAttributes(InvocationContext context, ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.next.getAttributes(context, this.replaceEmptyKeyValues(name), attributes);
    }

    public String getDefaultDomain(InvocationContext context) {
        return this.next.getDefaultDomain(context);
    }

    public Integer getMBeanCount(InvocationContext context) {
        return this.next.getMBeanCount(context);
    }

    public MBeanInfo getMBeanInfo(InvocationContext context, ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.next.getMBeanInfo(context, this.replaceEmptyKeyValues(name));
    }

    public ObjectInstance getObjectInstance(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        return this.next.getObjectInstance(context, this.replaceEmptyKeyValues(name));
    }

    public Object instantiate(InvocationContext context, String className) throws MBeanException, ReflectionException {
        return this.next.instantiate(context, className);
    }

    public Object instantiate(InvocationContext context, String className, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.next.instantiate(context, className, params, signature);
    }

    public Object instantiate(InvocationContext context, String className, ObjectName loaderName) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.next.instantiate(context, className, this.replaceEmptyKeyValues(loaderName));
    }

    public Object instantiate(InvocationContext context, String className, ObjectName loaderName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.next.instantiate(context, className, this.replaceEmptyKeyValues(loaderName), params, signature);
    }

    public Object invoke(InvocationContext context, ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.next.invoke(context, this.replaceEmptyKeyValues(name), operationName, params, signature);
    }

    public boolean isInstanceOf(InvocationContext context, ObjectName name, String className) throws InstanceNotFoundException {
        return this.next.isInstanceOf(context, this.replaceEmptyKeyValues(name), className);
    }

    public boolean isRegistered(InvocationContext context, ObjectName name) {
        return this.next.isRegistered(context, this.replaceEmptyKeyValues(name));
    }

    public Set queryMBeans(InvocationContext context, ObjectName name, QueryExp query) {
        return this.next.queryMBeans(context, this.replaceEmptyKeyValues(name), query);
    }

    public Set queryNames(InvocationContext context, ObjectName name, QueryExp query) {
        return this.next.queryNames(context, this.replaceEmptyKeyValues(name), query);
    }

    public ObjectInstance registerMBean(InvocationContext context, Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.next.registerMBean(context, object, this.replaceEmptyKeyValues(name));
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(context, this.replaceEmptyKeyValues(observed), listener);
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(context, this.replaceEmptyKeyValues(observed), listener, filter, handback);
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(context, this.replaceEmptyKeyValues(observed), this.replaceEmptyKeyValues(listener));
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(context, this.replaceEmptyKeyValues(observed), this.replaceEmptyKeyValues(listener), filter, handback);
    }

    public void setAttribute(InvocationContext context, ObjectName name, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.next.setAttribute(context, this.replaceEmptyKeyValues(name), attribute);
    }

    public AttributeList setAttributes(InvocationContext context, ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.next.setAttributes(context, this.replaceEmptyKeyValues(name), attributes);
    }

    public void unregisterMBean(InvocationContext context, ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.next.unregisterMBean(context, this.replaceEmptyKeyValues(name));
    }

    public ClassLoader getClassLoader(InvocationContext context, ObjectName loaderName) throws InstanceNotFoundException {
        try {
            return this.next.getClassLoader(context, this.replaceEmptyKeyValues(loaderName));
        }
        catch (InstanceNotFoundException ignored) {
            String loaderString = ObjectNameFactory.getName((ObjectName)loaderName);
            if (loaderString == null) {
                return this.frame.getOuterMBeanServer().getClass().getClassLoader();
            }
            loaderString = loaderString.substring(1, loaderString.length() - 1);
            ClassLoader loader = this.frame.getServiceContext().getCoreContext().getLoadContext().getClassLoader(loaderString);
            if (loader == null) {
                throw new InstanceNotFoundException("ClassLoader with name " + loaderName + " not found in repository");
            }
            return loader;
        }
    }

    public ClassLoader getClassLoaderFor(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        return this.next.getClassLoaderFor(context, this.replaceEmptyKeyValues(name));
    }

    public ClassLoaderRepository getClassLoaderRepository(InvocationContext context) {
        return this.next.getClassLoaderRepository(context);
    }

    public String[] getDomains(InvocationContext context) {
        return this.next.getDomains(context);
    }

    public MBeanServerInterceptor getNext() {
        return this.next;
    }

    public void setNext(MBeanServerInterceptor next) {
        this.next = next;
    }

    private Object instantiate(String className, ClassLoader loader, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        Object object = null;
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        try {
            Class<?> clazz = loader.loadClass(className);
            Constructor<?> constr = clazz.getConstructor(Utilities.convertSignature((String[])signature, (ClassLoader)loader));
            object = constr.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)targetException, "RuntimeException in the constructor of object " + className);
            }
            if (targetException instanceof Error) {
                throw new RuntimeErrorException((Error)targetException, "Error in the constructor of object " + className);
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception in the constructor of object " + className);
            }
            throw new ReflectionException(e, "InvocationTargetException in the constructor of object " + className + ", nested exception " + targetException.getClass().getName());
        }
        return object;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.objectNameCache.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.objectNameCache.getNotificationInfo();
    }

    public int getObjectNameCacheCurrentUsage() {
        return this.objectNameCache.getObjectNameCacheCurrentUsage();
    }

    public int getObjectNameCacheMaxSize() {
        return this.objectNameCache.getObjectNameCacheMaxSize();
    }

    public int getObjectNameCacheReplacedObjects() {
        return this.objectNameCache.getObjectNameCacheReplacedObjects();
    }

    public long getObjectNameCacheTotalHits() {
        return this.objectNameCache.getObjectNameCacheTotalHits();
    }

    public long getObjectNameCacheTotalReads() {
        return this.objectNameCache.getObjectNameCacheTotalReads();
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.objectNameCache.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.objectNameCache.removeNotificationListener(listener, filter, handback);
    }
}

