/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxNoSuchElementException;
import com.sap.engine.services.jmx.exception.JmxUnsupportedOperationException;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ClusterResultIterator
implements Iterator {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$ClusterResultIterator == null ? (class$com$sap$engine$services$jmx$ClusterResultIterator = ClusterResultIterator.class$("com.sap.engine.services.jmx.ClusterResultIterator")) : class$com$sap$engine$services$jmx$ClusterResultIterator));
    private final Iterator iter;
    private final Map streamParams;
    private boolean hasNextLA;
    private Object nextLA;
    static /* synthetic */ Class class$com$sap$engine$services$jmx$ClusterResultIterator;

    private Object nextLookAhead() {
        if (!this.hasNextLA) {
            throw new JmxNoSuchElementException("jmx_1501");
        }
        Object result = this.nextLA;
        try {
            this.hasNextLA = this.iter.hasNext();
            this.nextLA = this.iter.next();
        }
        catch (NoSuchElementException e) {
            this.hasNextLA = false;
        }
        return result;
    }

    ClusterResultIterator(Iterator iter, Map streamParams) {
        this.iter = iter;
        this.streamParams = streamParams;
        this.hasNextLA = true;
        this.nextLookAhead();
    }

    public boolean hasNext() {
        try {
            while (this.hasNextLA && this.nextLA instanceof ResponseMessage && ((ResponseMessage)this.nextLA).isException()) {
                try {
                    Exception skippedException = (Exception)((ResponseMessage)this.nextLA).getResult(this.streamParams);
                    LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "hasNext()", "An exception occured during invocation of a MBeanServer operation on a remote cluster node. Though the exception is ignored by the caller, the system might be in an inconsistent state. Please check the attached response and stack-trace for the cause of the exception. " + this.nextLA, skippedException);
                }
                catch (Exception ignored) {
                    LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "hasNext()", "An exception occured during invocation of a MBeanServer operation on a remote cluster node. Though the exception is ignored by the caller, the system might be in an inconsistent state. Unfortunately, it was not possible to get the stack-trace from the remote node (see the attached stacktrace). Please check the attached response as well as the logs on the remote node for the cause of the exception. " + this.nextLA, ignored);
                }
                this.nextLookAhead();
            }
            return this.hasNextLA;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object next() {
        ResponseMessage response;
        while ((response = (ResponseMessage)this.nextLookAhead()).isException()) {
            void var1_1;
            try {
                Exception skippedException = (Exception)var1_1.getResult(this.streamParams);
                LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "next()", "An exception occured during invocation of a MBeanServer operation on a remote cluster node. Though the exception is ignored by the caller, the system might be in an inconsistent state. Please check the attached response and stack-trace for the cause of the exception. " + this.nextLA, skippedException);
            }
            catch (Exception ignored) {
                LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "next()", "An exception occured during invocation of a MBeanServer operation on a remote cluster node. Though the exception is ignored by the caller, the system might be in an inconsistent state. Unfortunately, it was not possible to get the stack-trace from the remote node (see the attached stacktrace). Please check the attached response as well as the logs on the remote node for the cause of the exception. " + var1_1, ignored);
            }
        }
        try {
            return response.getResult(this.streamParams);
        }
        catch (JmxConnectorException skippedException) {
            LoggingHelper.logThrowable(500, LoggingHelper.SYS_SERVER, LOCATION, "next()", "An exception occured when reading the result of a MBeanServer operation from a remote cluster node. As a result, the caller of this operation might be in an inconsistent state. Please check the attached response as well as the stack-trace occured when reading the result. " + response, (Throwable)((Object)skippedException));
            return this.next();
        }
    }

    public void remove() {
        throw new JmxUnsupportedOperationException("jmx_1601");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

