/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.ClusterResultIterator;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.RemoteMBeanServerException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.JMRuntimeException;

public class ClusterResult
implements Serializable {
    private Map results = new HashMap();

    void setResult(String clusterID, ResponseMessage result) {
        this.results.put(clusterID, result);
    }

    public String[] getParticipants() {
        return (String[])this.results.keySet().toArray();
    }

    public ClusterResultIterator getResults(Map streamParams) {
        return new ClusterResultIterator(this.results.values().iterator(), streamParams);
    }

    public Object getResult(String clusterID, Map streamParams) throws JmxConnectorException, JMException {
        ResponseMessage response = (ResponseMessage)this.results.get(clusterID);
        Object result = response.getResult(streamParams);
        if (response.isException()) {
            if (result instanceof JmxConnectorException) {
                ((Throwable)result).fillInStackTrace();
                throw (JmxConnectorException)((Object)result);
            }
            if (result instanceof RemoteMBeanServerException) {
                Throwable cause = ((RemoteMBeanServerException)((Object)result)).getCause();
                if (cause instanceof JMException) {
                    cause.fillInStackTrace();
                    throw (JMException)cause;
                }
                if (cause instanceof JMRuntimeException) {
                    cause.fillInStackTrace();
                    throw (JMRuntimeException)cause;
                }
                throw new JmxConnectorException("jmx_2218", new Object[]{cause.getClass().getName(), response.toString()});
            }
            throw new JmxConnectorException("jmx_2219", new Object[]{result.getClass().getName(), response.toString()});
        }
        return result;
    }
}

