/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.ClusterInterceptorMBean;
import com.sap.engine.services.jmx.ClusterResult;
import com.sap.engine.services.jmx.ClusterResultIterator;
import com.sap.engine.services.jmx.DefaultClassLoader;
import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.InterceptorChainContext;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceConnectorClient;
import com.sap.engine.services.jmx.JmxServiceConnectorServerClusterInvoker;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.MBeanServerClusterConnection;
import com.sap.engine.services.jmx.MBeanServerClusterConnectionImpl;
import com.sap.engine.services.jmx.MBeanServerClusterConnectionSecurityWrapper;
import com.sap.engine.services.jmx.MBeanServerInvoker;
import com.sap.engine.services.jmx.MessageClientSecurityWrapper;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.connector.n2n.ConnectorFactory;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import com.sap.engine.services.jmx.exception.JmxIllegalStateException;
import com.sap.engine.services.jmx.exception.MBeanServerClusterException;
import com.sap.engine.services.jmx.exception.RemoteMBeanServerException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.remote.JmxConnectorFactory;
import com.sap.pj.jmx.server.interceptor.InvocationContext;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public final class ClusterInterceptor
implements MBeanServerInterceptor,
ClusterInterceptorMBean {
    static final String NAME = "ClusterInterceptor";
    private MBeanServerInterceptor next = null;
    private final JmxFrame frame;
    private final String myID;
    private Map connMap = new HashMap();
    private final Map connShadowMap = new HashMap();
    private final MBeanServerClusterConnection mbscc;
    private JmxServiceMessageClient clusterMsgClient;
    private MBeanServerInvoker innerMsgClient = null;
    private final JmxConnectorFactory n2nConnFactory = new ConnectorFactory();

    public ClusterInterceptor(JmxFrame frame) {
        if (frame == null) {
            throw new JmxIllegalArgumentException("com.sap.exception.standard_0001");
        }
        this.frame = frame;
        this.myID = frame.getElementIdAsString();
        JmxServiceConnectorServerClusterInvoker wrappedMessageClient = new JmxServiceConnectorServerClusterInvoker(-1, 3, frame);
        this.mbscc = new MBeanServerClusterConnectionSecurityWrapper(frame, new MBeanServerClusterConnectionImpl(wrappedMessageClient, frame));
        this.clusterMsgClient = new MessageClientSecurityWrapper(frame, wrappedMessageClient);
    }

    public String getType() {
        return NAME;
    }

    public MBeanServerInterceptor getNext() {
        return this.next;
    }

    public void setNext(MBeanServerInterceptor next) {
        this.next = next;
    }

    private MBeanServer getInnerMBS() {
        return this.frame.getInnerMBeanServer();
    }

    private MBeanServerInvoker getInnerMsgClient() {
        if (this.innerMsgClient == null) {
            ClusterInterceptor clusterInterceptor = this;
            synchronized (clusterInterceptor) {
                if (this.innerMsgClient == null) {
                    this.innerMsgClient = new MBeanServerInvoker(this.getInnerMBS(), null);
                }
            }
        }
        return this.innerMsgClient;
    }

    private MBeanServerClusterConnection getMBSCC() {
        MBeanServerClusterConnection connection = this.mbscc;
        if (connection == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{NAME, "MBeanServerClusterConnection"});
        }
        return connection;
    }

    private JmxServiceMessageClient getClusterMsgClient() {
        JmxServiceMessageClient cMsgC = this.clusterMsgClient;
        if (cMsgC == null) {
            throw new JmxIllegalStateException("jmx_1401", new Object[]{"JmxServiceMessageClient", "MBeanServerClusterConnection"});
        }
        return cMsgC;
    }

    private MBeanServerConnection getMBSC(ObjectName name) throws JmxConnectorException {
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)name, (String)this.myID)) {
            try {
                return this.getConnector(this.getElementID(name)).getMBeanServerConnection();
            }
            catch (IOException e) {
                if (e instanceof JmxConnectorException) {
                    throw (JmxConnectorException)((Object)e);
                }
                throw new JmxConnectorException("jmx_2213", new Object[]{this.getElementID(name)}, e);
            }
        }
        return this.getInnerMBS();
    }

    private ResponseMessage invokeMbs(RequestMessage request) throws JmxConnectorException {
        String elementID = request.getTargetNodeIdAsString();
        if (elementID != null && !elementID.equals(this.myID)) {
            try {
                return this.getConnector(elementID).getMessageClient().invokeMbs(request);
            }
            catch (IOException e) {
                if (e instanceof JmxConnectorException) {
                    throw (JmxConnectorException)((Object)e);
                }
                throw new JmxConnectorException("jmx_2213", new Object[]{elementID}, e);
            }
        }
        return this.getInnerMsgClient().invokeMbs(request);
    }

    private JmxServiceConnectorClient getConnector(String elementID) throws JmxConnectorException {
        JmxServiceConnectorClient conn = (JmxServiceConnectorClient)this.connMap.get(elementID);
        if (conn == null) {
            Map map = this.connShadowMap;
            synchronized (map) {
                conn = (JmxServiceConnectorClient)this.connShadowMap.get(elementID);
                if (conn == null) {
                    try {
                        conn = (JmxServiceConnectorClient)this.n2nConnFactory.getJmxConnector(elementID, DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                    }
                    catch (IOException e) {
                        if (e instanceof JmxConnectorException) {
                            throw (JmxConnectorException)((Object)e);
                        }
                        throw new JmxConnectorException("jmx_2213", new Object[]{elementID}, e);
                    }
                    this.connShadowMap.put(elementID, conn);
                    this.connMap = new HashMap(this.connShadowMap);
                }
            }
        }
        return conn;
    }

    private String getElementID(ObjectName name) {
        String elementID = ObjectNameFactory.getClusterNode((ObjectName)name);
        if (elementID == null || elementID.equals("\"\"")) {
            elementID = this.myID;
        }
        return elementID;
    }

    public void addNotificationListener(InvocationContext context, ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(name).addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
            }
        }
    }

    public void addNotificationListener(InvocationContext context, ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(name).addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
            }
        }
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).createMBean(className, name);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, Object[] params, String[] signature) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).createMBean(className, name, params, signature);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).createMBean(className, name, loaderName);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public ObjectInstance createMBean(InvocationContext context, String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).createMBean(className, name, loaderName, params, signature);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public ObjectInputStream deserialize(InvocationContext context, ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"deserialize(ObjectName, byte[])"});
        }
        if (!ObjectNameFactory.isJ2eeLocalName((ObjectName)name, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"deserialize(ObjectName, byte[])", this.getElementID(name)});
        }
        return this.getInnerMBS().deserialize(name, data);
    }

    public ObjectInputStream deserialize(InvocationContext context, String className, byte[] data) throws OperationsException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"deserialize(String, byte[])"});
        }
        return this.getInnerMBS().deserialize(className, data);
    }

    public ObjectInputStream deserialize(InvocationContext context, String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException, InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"deserialize(String, ObjectName, byte[])"});
        }
        if (!ObjectNameFactory.isJ2eeLocalName((ObjectName)loaderName, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"deserialize(String, ObjectName, byte[])", this.getElementID(loaderName)});
        }
        return this.getInnerMBS().deserialize(className, loaderName, data);
    }

    public Object getAttribute(InvocationContext context, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).getAttribute(name, attribute);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public AttributeList getAttributes(InvocationContext context, ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).getAttributes(name, attributes);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public String getDefaultDomain(InvocationContext context) {
        if (context instanceof InterceptorChainContext) {
            ((InterceptorChainContext)context).response = this.getInnerMsgClient().invokeMbs(((InterceptorChainContext)context).request);
            return null;
        }
        return this.getInnerMBS().getDefaultDomain();
    }

    public Integer getMBeanCount(InvocationContext context) {
        try {
            int result = 0;
            ClusterResultIterator iter = this.getMBSCC().queryNames(null, null).getResults(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
            while (iter.hasNext()) {
                Set singleResult = (Set)iter.next();
                Iterator nameIter = singleResult.iterator();
                while (nameIter.hasNext()) {
                    ObjectName name = (ObjectName)nameIter.next();
                    if (ObjectNameFactory.getClusterNode((ObjectName)name) == null) continue;
                    ++result;
                }
            }
            result += this.getInnerMBS().getMBeanCount().intValue();
            if (context instanceof InterceptorChainContext) {
                ((InterceptorChainContext)context).response = new ResponseMessage(new Integer(result), ((InterceptorChainContext)context).request.getSourceType());
                return null;
            }
            return new Integer(result);
        }
        catch (JmxConnectorException e) {
            MBeanServerClusterException wrappedEx = new MBeanServerClusterException("jmx_1202", (Throwable)((Object)e));
            if (context instanceof InterceptorChainContext) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)new RemoteMBeanServerException(this.myID, wrappedEx)));
                return null;
            }
            throw wrappedEx;
        }
    }

    public MBeanInfo getMBeanInfo(InvocationContext context, ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).getMBeanInfo(name);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public ObjectInstance getObjectInstance(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).getObjectInstance(name);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public Object instantiate(InvocationContext context, String className) throws MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"instantiate(String)"});
        }
        return this.getInnerMBS().instantiate(className);
    }

    public Object instantiate(InvocationContext context, String className, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"instantiate(String, Object[], String[])"});
        }
        return this.getInnerMBS().instantiate(className, params, signature);
    }

    public Object instantiate(InvocationContext context, String className, ObjectName loaderName) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"instantiate(String, ObjectName)"});
        }
        if (!ObjectNameFactory.isJ2eeLocalName((ObjectName)loaderName, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"instantiate(String, ObjectName)", this.getElementID(loaderName)});
        }
        return this.getInnerMBS().instantiate(className, loaderName);
    }

    public Object instantiate(InvocationContext context, String className, ObjectName loaderName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"instantiate(String, ObjectName, Object[], String[])"});
        }
        if (!ObjectNameFactory.isJ2eeLocalName((ObjectName)loaderName, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"instantiate(String, ObjectName, Object[], String[])", this.getElementID(loaderName)});
        }
        return this.getInnerMBS().instantiate(className, loaderName, params, signature);
    }

    public Object invoke(InvocationContext context, ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).invoke(name, operationName, params, signature);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public boolean isInstanceOf(InvocationContext context, ObjectName name, String className) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return false;
        }
        try {
            return this.getMBSC(name).isInstanceOf(name, className);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public boolean isRegistered(InvocationContext context, ObjectName name) {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return false;
        }
        try {
            return this.getMBSC(name).isRegistered(name);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Set queryMBeans(InvocationContext context, ObjectName pattern, QueryExp query) {
        block20: {
            block21: {
                targetID = null;
                if (!(context instanceof InterceptorChainContext)) break block20;
                targetID = ((InterceptorChainContext)context).request.getTargetNodeIdAsString();
                localResponse = null;
                try {
                    localResponse = this.invokeMbs(((InterceptorChainContext)context).request);
                    result = (Set)localResponse.getResult(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                }
                catch (JmxConnectorException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)e);
                    return null;
                }
                catch (RuntimeException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)new JmxConnectorException("jmx_2217", new Object[]{localResponse == null ? null : localResponse.toString()}, e));
                    return null;
                }
                if (targetID != null && !this.myID.equals(targetID)) {
                    iter = result.iterator();
                    while (iter.hasNext()) {
                        if (ObjectNameFactory.getClusterNode((ObjectName)((ObjectInstance)iter.next()).getObjectName()) != null) continue;
                        iter.remove();
                    }
                }
                if (targetID != null) break block21;
                multiResponse = this.getClusterMsgClient().invokeMbs(((InterceptorChainContext)context).request);
                try {
                    iter = ((ClusterResult)multiResponse.getResult(DefaultClassLoader.DEFAULT_STREAM_PARAMS)).getResults(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                    if (true) ** GOTO lbl41
                }
                catch (JmxConnectorException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)e);
                    return null;
                }
                catch (RuntimeException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)new JmxConnectorException("jmx_2217", new Object[]{multiResponse.toString()}, e));
                    return null;
                }
                do {
                    singleResult = (Set)iter.next();
                    instanceIter = singleResult.iterator();
                    while (instanceIter.hasNext()) {
                        instance = (ObjectInstance)instanceIter.next();
                        if (ObjectNameFactory.getClusterNode((ObjectName)instance.getObjectName()) == null) continue;
                        result.add(instance);
                    }
lbl41:
                    // 2 sources

                } while (iter.hasNext());
            }
            ((InterceptorChainContext)context).response = new ResponseMessage(result, ((InterceptorChainContext)context).request.getSourceType());
            return null;
        }
        if (pattern != null) {
            targetID = ObjectNameFactory.getClusterNode((ObjectName)pattern);
        }
        try {
            result = this.getMBSC(pattern).queryMBeans(pattern, query);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{targetID}, e);
        }
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)pattern, (String)this.myID)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                if (ObjectNameFactory.getClusterNode((ObjectName)iter.next().getObjectName()) != null) continue;
                iter.remove();
            }
        }
        if (targetID == null) {
            try {
                iter = this.getMBSCC().queryMBeans(pattern, query).getResults(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                while (iter.hasNext()) {
                    singleResult = (Set)iter.next();
                    instanceIter = singleResult.iterator();
                    while (instanceIter.hasNext()) {
                        instance = (ObjectInstance)instanceIter.next();
                        if (ObjectNameFactory.getClusterNode((ObjectName)instance.getObjectName()) == null) continue;
                        result.add(instance);
                    }
                }
            }
            catch (JmxConnectorException e) {
                throw new MBeanServerClusterException("jmx_1202", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Set queryNames(InvocationContext context, ObjectName pattern, QueryExp query) {
        block20: {
            block21: {
                targetID = null;
                if (!(context instanceof InterceptorChainContext)) break block20;
                targetID = ((InterceptorChainContext)context).request.getTargetNodeIdAsString();
                localResponse = null;
                try {
                    localResponse = this.invokeMbs(((InterceptorChainContext)context).request);
                    result = (Set)localResponse.getResult(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                }
                catch (JmxConnectorException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)e);
                    return null;
                }
                catch (RuntimeException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)new JmxConnectorException("jmx_2217", new Object[]{localResponse == null ? null : localResponse.toString()}, e));
                    return null;
                }
                if (targetID != null && !this.myID.equals(targetID)) {
                    iter = result.iterator();
                    while (iter.hasNext()) {
                        if (ObjectNameFactory.getClusterNode((ObjectName)((ObjectName)iter.next())) != null) continue;
                        iter.remove();
                    }
                }
                if (targetID != null) break block21;
                multiResponse = this.getClusterMsgClient().invokeMbs(((InterceptorChainContext)context).request);
                try {
                    iter = ((ClusterResult)multiResponse.getResult(DefaultClassLoader.DEFAULT_STREAM_PARAMS)).getResults(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                    if (true) ** GOTO lbl41
                }
                catch (JmxConnectorException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)e);
                    return null;
                }
                catch (RuntimeException e) {
                    ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)new JmxConnectorException("jmx_2217", new Object[]{multiResponse.toString()}, e));
                    return null;
                }
                do {
                    singleResult = (Set)iter.next();
                    nameIter = singleResult.iterator();
                    while (nameIter.hasNext()) {
                        name = (ObjectName)nameIter.next();
                        if (ObjectNameFactory.getClusterNode((ObjectName)name) == null) continue;
                        result.add(name);
                    }
lbl41:
                    // 2 sources

                } while (iter.hasNext());
            }
            ((InterceptorChainContext)context).response = new ResponseMessage(result, ((InterceptorChainContext)context).request.getSourceType());
            return null;
        }
        if (pattern != null) {
            targetID = ObjectNameFactory.getClusterNode((ObjectName)pattern);
        }
        try {
            result = this.getMBSC(pattern).queryNames(pattern, query);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{targetID}, e);
        }
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)pattern, (String)this.myID)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                if (ObjectNameFactory.getClusterNode((ObjectName)iter.next()) != null) continue;
                iter.remove();
            }
        }
        if (targetID == null) {
            try {
                iter = this.getMBSCC().queryNames(pattern, query).getResults(DefaultClassLoader.DEFAULT_STREAM_PARAMS);
                while (iter.hasNext()) {
                    singleResult = (Set)iter.next();
                    nameIter = singleResult.iterator();
                    while (nameIter.hasNext()) {
                        name = (ObjectName)nameIter.next();
                        if (ObjectNameFactory.getClusterNode((ObjectName)name) == null) continue;
                        result.add(name);
                    }
                }
            }
            catch (JmxConnectorException e) {
                throw new MBeanServerClusterException("jmx_1202", (Throwable)e);
            }
        }
        return result;
    }

    public ObjectInstance registerMBean(InvocationContext context, Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"registerMBean(Object, ObjectName)"});
        }
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)name, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"registerMBean(Object, ObjectName)", this.getElementID(name)});
        }
        return this.getInnerMBS().registerMBean(object, name);
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(observed).removeNotificationListener(observed, listener);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(observed)}, e);
            }
        }
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(observed).removeNotificationListener(observed, listener, filter, handback);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(observed)}, e);
            }
        }
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(observed).removeNotificationListener(observed, listener);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(observed)}, e);
            }
        }
    }

    public void removeNotificationListener(InvocationContext context, ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(observed).removeNotificationListener(observed, listener, filter, handback);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(observed)}, e);
            }
        }
    }

    public void setAttribute(InvocationContext context, ObjectName name, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(name).setAttribute(name, attribute);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
            }
        }
    }

    public AttributeList setAttributes(InvocationContext context, ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
            return null;
        }
        try {
            return this.getMBSC(name).setAttributes(name, attributes);
        }
        catch (IOException e) {
            throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
        }
    }

    public void unregisterMBean(InvocationContext context, ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (context instanceof InterceptorChainContext) {
            try {
                ((InterceptorChainContext)context).response = this.invokeMbs(((InterceptorChainContext)context).request);
            }
            catch (JmxConnectorException e) {
                ((InterceptorChainContext)context).response = new ExceptionMessage((Throwable)((Object)e));
            }
        } else {
            try {
                this.getMBSC(name).unregisterMBean(name);
            }
            catch (IOException e) {
                throw new MBeanServerClusterException("jmx_1201", new Object[]{this.getElementID(name)}, e);
            }
        }
    }

    public ClassLoader getClassLoader(InvocationContext context, ObjectName loaderName) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"getClassLoader(ObjectName)"});
        }
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)loaderName, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"getClassLoader(ObjectName)", this.getElementID(loaderName)});
        }
        return this.getInnerMBS().getClassLoader(loaderName);
    }

    public ClassLoader getClassLoaderFor(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"getClassLoaderFor(ObjectName)"});
        }
        if (ObjectNameFactory.isJ2eeRemoteName((ObjectName)name, (String)this.myID)) {
            throw new MBeanServerClusterException("jmx_1203", new Object[]{"getClassLoaderFor(ObjectName)", this.getElementID(name)});
        }
        return this.getInnerMBS().getClassLoaderFor(name);
    }

    public ClassLoaderRepository getClassLoaderRepository(InvocationContext context) {
        if (context instanceof InterceptorChainContext) {
            throw new JmxIllegalArgumentException("jmx_1301", new Object[]{"getClassLoaderRepository()"});
        }
        return this.getInnerMBS().getClassLoaderRepository();
    }

    public String[] getDomains(InvocationContext context) {
        if (context instanceof InterceptorChainContext) {
            ((InterceptorChainContext)context).response = this.getInnerMsgClient().invokeMbs(((InterceptorChainContext)context).request);
            return null;
        }
        return this.getInnerMBS().getDomains();
    }
}

