/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.DefaultClassLoader;
import com.sap.engine.services.jmx.ParameterizedStream;
import com.sap.engine.services.jmx.exception.JmxClassNotFoundException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.Map;

public class ClassLoaderSpecificObjectInputStream
extends ObjectInputStream
implements ParameterizedStream {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$ClassLoaderSpecificObjectInputStream == null ? (class$com$sap$engine$services$jmx$ClassLoaderSpecificObjectInputStream = ClassLoaderSpecificObjectInputStream.class$("com.sap.engine.services.jmx.ClassLoaderSpecificObjectInputStream")) : class$com$sap$engine$services$jmx$ClassLoaderSpecificObjectInputStream));
    private ClassLoader loader = null;
    static /* synthetic */ Class class$com$sap$engine$services$jmx$ClassLoaderSpecificObjectInputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ClassLoaderSpecificObjectInputStream(ByteArrayInputStream in) throws IOException, StreamCorruptedException {
        super(in);
        this.enableResolveObject(true);
    }

    private void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        return ClassLoaderSpecificObjectInputStream.loadClass(v.getName(), this.loader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        this.readObject();
        return ClassLoaderSpecificObjectInputStream.loadProxyClass(interfaces, this.loader);
    }

    static Class loadProxyClass(String[] interfaces, ClassLoader loader) throws IOException, ClassNotFoundException {
        Class[] classes = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            classes[i] = ClassLoaderSpecificObjectInputStream.loadClass(interfaces[i], loader);
            ++i;
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return Proxy.getProxyClass(loader, classes);
    }

    static Class loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader != null) {
            try {
                return ClassLoaderSpecificObjectInputStream.convertClassName(name, loader);
            }
            catch (ClassNotFoundException ignored) {
                LOCATION.traceThrowableT(200, "unable to load class " + name + " with the specified loader " + loader + ", try to use the default loader " + DefaultClassLoader.DEFAULT_CLASS_LOADER, (Throwable)ignored);
            }
        }
        return ClassLoaderSpecificObjectInputStream.convertClassName(name, DefaultClassLoader.DEFAULT_CLASS_LOADER);
    }

    public static Class convertClassName(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name == null) {
            throw new JmxClassNotFoundException("null");
        }
        if ((name = name.trim()).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("java.lang.String")) {
            return class$java$lang$String == null ? (class$java$lang$String = ClassLoaderSpecificObjectInputStream.class$("java.lang.String")) : class$java$lang$String;
        }
        if (name.equals("java.lang.Object")) {
            return class$java$lang$Object == null ? (class$java$lang$Object = ClassLoaderSpecificObjectInputStream.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (name.startsWith("[")) {
            int dimension = 0;
            while (name.charAt(dimension) == '[') {
                ++dimension;
            }
            char type = name.charAt(dimension);
            Class cls = null;
            switch (type) {
                case 'Z': {
                    cls = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    cls = Byte.TYPE;
                    break;
                }
                case 'C': {
                    cls = Character.TYPE;
                    break;
                }
                case 'S': {
                    cls = Short.TYPE;
                    break;
                }
                case 'I': {
                    cls = Integer.TYPE;
                    break;
                }
                case 'J': {
                    cls = Long.TYPE;
                    break;
                }
                case 'F': {
                    cls = Float.TYPE;
                    break;
                }
                case 'D': {
                    cls = Double.TYPE;
                    break;
                }
                case 'L': {
                    String n = name.substring(dimension + 1, name.length() - 1);
                    cls = ClassLoaderSpecificObjectInputStream.convertClassName(n, loader);
                }
            }
            if (cls == null) {
                throw new JmxClassNotFoundException(name);
            }
            int[] dim = new int[dimension];
            return Array.newInstance(cls, dim).getClass();
        }
        return loader.loadClass(name);
    }

    public void setParameters(Map params) {
        if (params == null) {
            return;
        }
        Object cl = params.get("StreamClassLoader");
        if (cl instanceof ClassLoader) {
            this.setClassLoader((ClassLoader)cl);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

