/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.spi;

import com.sap.engine.services.jmsconnector.cci.ConnectionImpl;
import com.sap.engine.services.jmsconnector.cci.QueueSessionImpl;
import com.sap.engine.services.jmsconnector.cci.SessionCloseEventListener;
import com.sap.engine.services.jmsconnector.cci.SessionImpl;
import com.sap.engine.services.jmsconnector.cci.TopicSessionImpl;
import com.sap.engine.services.jmsconnector.exceptions.BaseResourceException;
import com.sap.engine.services.jmsconnector.exceptions.BaseXAException;
import com.sap.engine.services.jmsconnector.spi.AbstractManagedConnection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ManagedSession
extends AbstractManagedConnection
implements LocalTransaction,
SessionCloseEventListener {
    private Session realSession;
    private ConnectionImpl connectionImpl;
    private boolean isInTransaction;
    private boolean isClosed;
    private SessionImpl sessionImpl;
    private boolean isTopic;
    private boolean isXA;
    private XAResource xaResource;

    public ManagedSession(Session session, ConnectionImpl connectionImpl, boolean isTopic, boolean isXA) {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.ManagedSession(isTopic = " + isTopic + ", isXA = " + isXA);
        }
        this.realSession = session;
        this.connectionImpl = connectionImpl;
        this.isTopic = isTopic;
        this.isXA = isXA;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.getConnection()");
        }
        if (this.sessionImpl == null) {
            if (this.isXA) {
                try {
                    this.sessionImpl = this.isTopic ? new TopicSessionImpl((Session)((XATopicSession)this.realSession).getTopicSession(), this) : new QueueSessionImpl((Session)((XAQueueSession)this.realSession).getQueueSession(), this);
                    return this.sessionImpl;
                }
                catch (JMSException _) {
                    throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
                }
            }
            this.sessionImpl = this.isTopic ? new TopicSessionImpl(this.realSession, this) : new QueueSessionImpl(this.realSession, this);
            return this.sessionImpl;
        }
        throw new BaseResourceException("jmsconnector_0030");
    }

    public void destroy() throws ResourceException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.destroy()");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.getXAResource()");
        }
        if (this.isXA) {
            if (this.xaResource == null) {
                this.xaResource = new XAManagedResource(((XASession)this.realSession).getXAResource());
                return this.xaResource;
            }
            return this.xaResource;
        }
        throw new BaseResourceException("jmsconnector_0031");
    }

    public LocalTransaction getLocalTransaction() {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.getLocalTransaction()");
        }
        return this;
    }

    public void begin() {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.begin()");
        }
        if (!this.isInTransaction) {
            this.isInTransaction = true;
            this.connectionImpl.addTransactedSession();
        }
    }

    public void commit() throws ResourceException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.commit()");
        }
        try {
            this.realSession.commit();
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
        this.isInTransaction = false;
        try {
            this.connectionImpl.removeTransactedSession();
            if (this.isClosed) {
                this.realSession.close();
                this.connectionImpl.sessionClosed(this.realSession);
            }
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
    }

    public void rollback() throws ResourceException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.rollback()");
        }
        try {
            this.realSession.rollback();
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
        this.isInTransaction = false;
        try {
            this.connectionImpl.removeTransactedSession();
            if (this.isClosed) {
                this.realSession.close();
                this.connectionImpl.sessionClosed(this.realSession);
            }
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
    }

    public void sessionClosed(Session session) throws JMSException {
        if (AbstractManagedConnection.location.beLogged(100)) {
            AbstractManagedConnection.location.logT(100, "ManagedSession.sessionClosed()");
        }
        this.isClosed = true;
        this.sendCloseEvent(this.sessionImpl);
        if (!this.isInTransaction) {
            this.realSession.close();
            this.connectionImpl.sessionClosed(this.realSession);
        }
    }

    private class XAManagedResource
    implements XAResource {
        private XAResource xaResource;
        private Xid activeXid;

        private XAManagedResource(XAResource xa) {
            this.xaResource = xa;
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.commit()");
            }
            this.xaResource.commit(xid, onePhase);
            if (this.activeXid.equals(xid)) {
                ManagedSession.this.isInTransaction = false;
                try {
                    ManagedSession.this.connectionImpl.removeTransactedSession();
                    if (ManagedSession.this.isClosed) {
                        ManagedSession.this.realSession.close();
                        ManagedSession.this.connectionImpl.sessionClosed(ManagedSession.this.realSession);
                    }
                }
                catch (JMSException _) {
                    throw new BaseXAException("jmsconnector_0026", (Throwable)_);
                }
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.end()");
            }
            this.xaResource.end(xid, flags);
        }

        public void forget(Xid xid) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.forget()");
            }
            this.xaResource.forget(xid);
        }

        public int getTransactionTimeout() throws XAException {
            return this.xaResource.getTransactionTimeout();
        }

        public boolean isSameRM(XAResource xaresource) throws XAException {
            boolean result = xaresource instanceof XAManagedResource ? ((XAManagedResource)xaresource).xaResource.isSameRM(this.xaResource) : false;
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.isSameRM() - > " + result);
            }
            return result;
        }

        public int prepare(Xid xid) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.prepare()");
            }
            return this.xaResource.prepare(xid);
        }

        public Xid[] recover(int flag) throws XAException {
            return this.xaResource.recover(flag);
        }

        public void rollback(Xid xid) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.rollback()");
            }
            this.xaResource.rollback(xid);
            if (this.activeXid.equals(xid)) {
                ManagedSession.this.isInTransaction = false;
                try {
                    ManagedSession.this.connectionImpl.removeTransactedSession();
                    if (ManagedSession.this.isClosed) {
                        ManagedSession.this.realSession.close();
                        ManagedSession.this.connectionImpl.sessionClosed(ManagedSession.this.realSession);
                    }
                }
                catch (JMSException _) {
                    throw new BaseXAException("jmsconnector_0026", (Throwable)_);
                }
            }
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            return this.xaResource.setTransactionTimeout(seconds);
        }

        public void start(Xid xid, int flags) throws XAException {
            if (AbstractManagedConnection.location.beLogged(100)) {
                AbstractManagedConnection.location.logT(100, "XAManagedResource.start()");
            }
            ManagedSession.this.isInTransaction = true;
            this.activeXid = xid;
            ManagedSession.this.connectionImpl.addTransactedSession();
            this.xaResource.start(xid, flags);
        }

        public String toString() {
            return "XAManagedResource activeXid = " + this.activeXid + " xaResource = " + this.xaResource;
        }
    }
}

