/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.spi;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.services.jmsconnector.JMSConnectorFrame;
import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.cci.ConnectionImpl;
import com.sap.engine.services.jmsconnector.cci.QueueConnectionFactoryImpl;
import com.sap.engine.services.jmsconnector.cci.TopicConnectionFactoryImpl;
import com.sap.engine.services.jmsconnector.deploy.ConnectionFactoryDescriptor;
import com.sap.engine.services.jmsconnector.exceptions.BaseClassNotFoundException;
import com.sap.engine.services.jmsconnector.exceptions.BaseResourceException;
import com.sap.engine.services.jmsconnector.spi.AbstractManagedConnectionFactory;
import com.sap.engine.services.jmsconnector.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.jmsconnector.spi.DefaultConnectionManager;
import com.sap.engine.services.jmsconnector.spi.ManagedSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;

public class ManagedConnectionFactoryImpl
extends AbstractManagedConnectionFactory {
    private transient ConnectionFactory connectionFactory;
    private ConnectionFactoryDescriptor factoryDescriptor;
    private int factoryType;

    public ManagedConnectionFactoryImpl(ConnectionFactory connectionFactory, ConnectionFactoryDescriptor factoryDescriptor) {
        if (AbstractManagedConnectionFactory.location.beLogged(100)) {
            AbstractManagedConnectionFactory.location.logT(100, "Factory: " + factoryDescriptor + " ManagedConnectionFactoryImpl.ManagedConnectionFactoryImpl.");
        }
        this.connectionFactory = connectionFactory;
        this.factoryDescriptor = factoryDescriptor;
        this.factoryType = factoryDescriptor.getFactoryType();
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (AbstractManagedConnectionFactory.location.beLogged(100)) {
            AbstractManagedConnectionFactory.location.logT(100, "Factory: " + this.factoryDescriptor + " ManagedConnectionFactoryImpl.createConnectionFactory(ConnectionManager)");
        }
        switch (this.factoryDescriptor.getMode()) {
            case 2: {
                throw new BaseResourceException("jmsconnector_0027");
            }
            case 1: {
                throw new BaseResourceException("jmsconnector_0028");
            }
        }
        switch (this.factoryType) {
            case 1: {
                return new TopicConnectionFactoryImpl(this, connectionManager, (TopicConnectionFactory)this.connectionFactory, false, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 2: {
                return new QueueConnectionFactoryImpl(this, connectionManager, (QueueConnectionFactory)this.connectionFactory, false, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 3: {
                return new TopicConnectionFactoryImpl(this, connectionManager, (TopicConnectionFactory)this.connectionFactory, true, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 4: {
                return new QueueConnectionFactoryImpl(this, connectionManager, (QueueConnectionFactory)this.connectionFactory, true, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
        }
        throw new BaseResourceException("jmsconnector_0025", new Integer(this.factoryType));
    }

    public Object createConnectionFactory() throws ResourceException {
        if (AbstractManagedConnectionFactory.location.beLogged(100)) {
            AbstractManagedConnectionFactory.location.logT(100, "Factory: " + this.factoryDescriptor + " ManagedConnectionFactoryImpl.createConnectionFactory() DefaultConnectionManager");
        }
        switch (this.factoryDescriptor.getMode()) {
            case 2: {
                throw new BaseResourceException("jmsconnector_0027");
            }
            case 1: {
                throw new BaseResourceException("jmsconnector_0028");
            }
        }
        switch (this.factoryType) {
            case 1: {
                return new TopicConnectionFactoryImpl(this, new DefaultConnectionManager(this.factoryType), (TopicConnectionFactory)this.connectionFactory, false, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 2: {
                return new QueueConnectionFactoryImpl(this, new DefaultConnectionManager(this.factoryType), (QueueConnectionFactory)this.connectionFactory, false, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 3: {
                return new TopicConnectionFactoryImpl(this, new DefaultConnectionManager(this.factoryType), (TopicConnectionFactory)this.connectionFactory, true, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
            case 4: {
                return new QueueConnectionFactoryImpl(this, new DefaultConnectionManager(this.factoryType), (QueueConnectionFactory)this.connectionFactory, true, this.factoryDescriptor.getUserName(), this.factoryDescriptor.getPassword(), this.factoryDescriptor.getClientID());
            }
        }
        throw new BaseResourceException("jmsconnector_0025", new Integer(this.factoryType));
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (AbstractManagedConnectionFactory.location.beLogged(100)) {
            AbstractManagedConnectionFactory.location.logT(100, "Factory: " + this.factoryDescriptor + " ManagedConnectionFactoryImpl.createManagedConnection()");
        }
        try {
            Connection connection = ((ConnectionRequestInfoImpl)connectionRequestInfo).getConnection();
            ConnectionImpl connectionImpl = (ConnectionImpl)((ConnectionRequestInfoImpl)connectionRequestInfo).getConnectionImpl();
            switch (this.factoryType) {
                case 1: {
                    return new ManagedSession((Session)((TopicConnection)connection).createTopicSession(true, 0), connectionImpl, true, false);
                }
                case 2: {
                    return new ManagedSession((Session)((QueueConnection)connection).createQueueSession(true, 0), connectionImpl, false, false);
                }
                case 3: {
                    return new ManagedSession((Session)((XATopicConnection)connection).createXATopicSession(), connectionImpl, true, true);
                }
                case 4: {
                    return new ManagedSession((Session)((XAQueueConnection)connection).createXAQueueSession(), connectionImpl, false, true);
                }
            }
            throw new BaseResourceException("jmsconnector_0025", new Integer(this.factoryType));
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
    }

    public int hashCode() {
        return this.connectionFactory.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedConnectionFactoryImpl)) {
            return false;
        }
        ManagedConnectionFactoryImpl tObj = (ManagedConnectionFactoryImpl)obj;
        return this.connectionFactory.equals(tObj.connectionFactory);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block20: {
            stream.defaultReadObject();
            if (AbstractManagedConnectionFactory.location.beLogged(300)) {
                AbstractManagedConnectionFactory.location.logT(300, "Factory: " + this.factoryDescriptor + " Start Deserializing...");
            }
            if (this.factoryDescriptor.hasNaming()) {
                if (AbstractManagedConnectionFactory.location.beLogged(300)) {
                    AbstractManagedConnectionFactory.location.logT(300, "Factory: " + this.factoryDescriptor + " Link factory name:" + this.factoryDescriptor.getLinkFactoryName());
                }
                Thread currentThread = Thread.currentThread();
                ClassLoader currentContextClassLoader = currentThread.getContextClassLoader();
                try {
                    try {
                        Properties props = this.factoryDescriptor.getContextProperties();
                        if (!"true".equalsIgnoreCase(SystemProperties.getProperty("server")) && "com.sap.engine.services.jndi.InitialContextFactoryImpl".equals(props.getProperty("java.naming.factory.initial")) && props.getProperty("force_remote") == null) {
                            props = new Properties();
                            props.setProperty("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                        }
                        ((Hashtable)props).put("appclient", "true");
                        ClassLoader classLoader = this.getClassLoader();
                        currentThread.setContextClassLoader(classLoader);
                        Object object = new InitialContext(props).lookup(this.factoryDescriptor.getLinkFactoryName());
                        if (!(object instanceof ConnectionFactory)) {
                            String stackTrace = null;
                            try {
                                Method method = object.getClass().getMethod("getStackTrace", null);
                                stackTrace = (String)method.invoke(object, null);
                            }
                            catch (Exception e) {
                                if (AbstractManagedConnectionFactory.location.beLogged(500)) {
                                    AbstractManagedConnectionFactory.location.traceThrowableT(500, "Factory: " + this.factoryDescriptor + " Error getting stacktrace :", (Throwable)e);
                                }
                                stackTrace = "No Stack Trace: " + e;
                            }
                            if (AbstractManagedConnectionFactory.location.beLogged(500)) {
                                AbstractManagedConnectionFactory.location.logT(500, "Factory: " + this.factoryDescriptor + " Error deserializing :" + stackTrace);
                            }
                            throw new BaseClassNotFoundException("jmsconnector_0045", stackTrace);
                        }
                        this.connectionFactory = (ConnectionFactory)object;
                    }
                    catch (NamingException e) {
                        if (AbstractManagedConnectionFactory.location.beLogged(500)) {
                            AbstractManagedConnectionFactory.location.traceThrowableT(500, "Factory: " + this.factoryDescriptor + " Error loading :", (Throwable)e);
                        }
                        throw new BaseClassNotFoundException("jmsconnector_0029", (Throwable)e);
                    }
                    Object var10_18 = null;
                    currentThread.setContextClassLoader(currentContextClassLoader);
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var10_19 = null;
                    currentThread.setContextClassLoader(currentContextClassLoader);
                    throw throwable;
                }
            }
            String objectFactoryName = this.factoryDescriptor.getObjectFactoryName();
            Reference ref = new Reference(this.factoryDescriptor.getClassName(), objectFactoryName, "");
            Properties objectFactoryProperties = this.factoryDescriptor.getCreateFactoryProperties();
            Enumeration e = ((Hashtable)objectFactoryProperties).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = objectFactoryProperties.getProperty(key);
                ref.add(new StringRefAddr(key, val));
            }
            if (AbstractManagedConnectionFactory.location.beLogged(300)) {
                JMSConnectorResourceAccessor.location.logT(300, "Factory: " + this.factoryDescriptor + " object factory name: " + objectFactoryName);
            }
            try {
                Class<?> cl = this.getClassLoader().loadClass(objectFactoryName);
                this.connectionFactory = (ConnectionFactory)((ObjectFactory)cl.newInstance()).getObjectInstance(ref, null, null, new Hashtable());
            }
            catch (Exception e2) {
                if (AbstractManagedConnectionFactory.location.beLogged(500)) {
                    JMSConnectorResourceAccessor.location.traceThrowableT(500, "Factory: " + this.factoryDescriptor + " error loading class: ", (Throwable)e2);
                }
                throw new BaseClassNotFoundException("jmsconnector_0029", (Throwable)e2);
            }
        }
        if (AbstractManagedConnectionFactory.location.beLogged(300)) {
            AbstractManagedConnectionFactory.location.logT(300, "Factory: " + this.factoryDescriptor + " Deserializabling done.");
        }
    }

    private final ClassLoader getClassLoader() {
        ApplicationServiceContext serviceContext = JMSConnectorFrame.getAppContext();
        if (serviceContext == null) {
            return this.getClass().getClassLoader();
        }
        LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
        String libraryName = this.factoryDescriptor.getLibraryName();
        if (libraryName == null || libraryName.length() == 0) {
            return this.getClass().getClassLoader();
        }
        ClassLoader classLoader = classLoaderContext.getClassLoader("library:" + libraryName);
        if (classLoader == null) {
            if (AbstractManagedConnectionFactory.location.beLogged(500)) {
                JMSConnectorResourceAccessor.location.logT(500, "Factory: " + this.factoryDescriptor + " loader does not exist: " + this.factoryDescriptor.getLibraryName() + " . Using default class loader!!!");
            }
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

