/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.spi;

import com.sap.engine.services.jmsconnector.exceptions.BaseResourceException;
import com.sap.engine.services.jmsconnector.spi.ConnectionRequestInfoImpl;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class DefaultConnectionManager
implements ConnectionManager {
    private int factoryType;

    public DefaultConnectionManager(int factoryType) {
        this.factoryType = factoryType;
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Connection connection = ((ConnectionRequestInfoImpl)connectionRequestInfo).getConnection();
        try {
            switch (this.factoryType) {
                case 1: {
                    return ((TopicConnection)connection).createTopicSession(true, 0);
                }
                case 2: {
                    return ((QueueConnection)connection).createQueueSession(true, 0);
                }
                case 3: {
                    return ((XATopicConnection)connection).createXATopicSession().getTopicSession();
                }
                case 4: {
                    return ((XAQueueConnection)connection).createXAQueueSession().getQueueSession();
                }
            }
            throw new BaseResourceException("jmsconnector_0025", new Integer(this.factoryType));
        }
        catch (JMSException _) {
            throw new BaseResourceException("jmsconnector_0026", (Throwable)_);
        }
    }
}

