/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.spi;

import com.sap.engine.services.jmsconnector.JMSConnectorResourceAccessor;
import com.sap.engine.services.jmsconnector.exceptions.BaseResourceException;
import com.sap.engine.services.jmsconnector.spi.ManagedConnectionMetaDataImpl;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public abstract class AbstractManagedConnection
implements ManagedConnection,
ExceptionListener {
    private PrintWriter printWriter;
    private ArrayList listeners = new ArrayList();
    protected static final Location location = JMSConnectorResourceAccessor.location;

    public void setLogWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.printWriter;
    }

    public void cleanup() {
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.associateConnection()");
        }
        throw new BaseResourceException("jmsconnector_0024");
    }

    public ManagedConnectionMetaData getMetaData() {
        return new ManagedConnectionMetaDataImpl();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.addConnectionEventListener()");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(connectionEventListener)) {
                this.listeners.add(connectionEventListener);
            }
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.removeConnectionEventListener()");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ((AbstractCollection)this.listeners).remove(connectionEventListener);
        }
    }

    protected final void sendCloseEvent(Object handle) {
        Object[] all;
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.sendCloseEvent()");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle(handle);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            all = this.listeners.toArray();
        }
        int i = 0;
        while (i < all.length) {
            ((ConnectionEventListener)all[i]).connectionClosed(event);
            ++i;
        }
    }

    protected final void sendErrorOccurredEvent(Exception exception) {
        Object[] all;
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.sendErrorOccurredEvent()");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, exception);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            all = this.listeners.toArray();
        }
        int i = 0;
        while (i < all.length) {
            ((ConnectionEventListener)all[i]).connectionErrorOccurred(event);
            ++i;
        }
    }

    protected final void sendLocalTransactionStartedEvent() {
        Object[] all;
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            all = this.listeners.toArray();
        }
        int i = 0;
        while (i < all.length) {
            ((ConnectionEventListener)all[i]).localTransactionStarted(event);
            ++i;
        }
    }

    protected final void sendLocalTransactionCommittedEvent() {
        Object[] all;
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            all = this.listeners.toArray();
        }
        int i = 0;
        while (i < all.length) {
            ((ConnectionEventListener)all[i]).localTransactionCommitted(event);
            ++i;
        }
    }

    protected final void sendLocalTransactionRolledbackEvent() {
        Object[] all;
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            all = this.listeners.toArray();
        }
        int i = 0;
        while (i < all.length) {
            ((ConnectionEventListener)all[i]).localTransactionRolledback(event);
            ++i;
        }
    }

    public void onException(JMSException exception) {
        if (location.beLogged(100)) {
            location.logT(100, "AbstractManagedConnection.onException()");
        }
        this.sendErrorOccurredEvent((Exception)((Object)exception));
    }

    public abstract LocalTransaction getLocalTransaction() throws ResourceException;

    public abstract XAResource getXAResource() throws ResourceException;

    public abstract void destroy() throws ResourceException;

    public abstract Object getConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;
}

